/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 * 
 * $Id: IDeltaManager.java,v 1.2 2004/11/22 21:48:51 slavescu Exp $
 **********************************************************************/
package org.eclipse.hyades.loaders.trace;


/**
 * @author slavescu
 */
public interface IDeltaManager {
	/**
	 * take a snapshot, replaces the previous one
	 */
	public void takeSnapshot();
	/**
	 * returns the current snapshot 
	 */
	public ISnapshot retrieveSnapshot();
	/**
	 * returns the current snapshot 
	 */
	public void removeSnapshot();
	/**
	 * returns: 
	 * 		-1 no snapshot exists
	 * 		1 snapshot exists
	 */
	public int computeDelta(IDelta delta);
	public int computeDelta(IDelta delta,int featureID);
}
