/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 * 
 * $Id: TraceMethodBaseLoader.java,v 1.8 2004/11/22 21:48:51 slavescu Exp $
 **********************************************************************/
package org.eclipse.hyades.loaders.trace;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.loaders.trace.TraceUtils.InvocationInfo;
import org.eclipse.hyades.loaders.trace.TraceUtils.InvocationPool;
import org.eclipse.hyades.loaders.util.AgentsContext;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.models.hierarchy.CorrelationSourceInfo;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.UnresolvedCorrelation;
import org.eclipse.hyades.models.hierarchy.impl.UnresolvedCorrelationImpl;
import org.eclipse.hyades.models.hierarchy.util.FastList;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.models.hierarchy.util.SaveUtil;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCFullTraceObject;
import org.eclipse.hyades.models.trace.TRCInputOutputContainer;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCObjectValue;
import org.eclipse.hyades.models.trace.TRCObjectValueKind;
import org.eclipse.hyades.models.trace.TRCObjectValuePosition;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TRCTypedObjectValue;
import org.eclipse.hyades.models.trace.TraceFactory;
import org.eclipse.hyades.models.trace.TracePackage;
import org.eclipse.hyades.models.trace.impl.TRCFullMethodInvocationImpl;
import org.eclipse.hyades.models.trace.impl.TRCThreadImpl;
/**
 * @author slavescu
 */
public class TraceMethodBaseLoader extends TraceXMLFragmentLoader {
	//~ Static fields/initializers
	// -----------------------------------------------------------------
	protected static final String TICKET = "ticket";
	protected static final String STACK_DEPTH = "stackDepth";
	protected static final String PARAMETER = "parameter";
	protected static final String RETURN_VALUE = "returnValue";
	protected static final String VALUE = "value";
	protected static final String VALUE_KIND = "valueKind";
	protected static final String VALUE_POSITION = "valuePos";
	protected static final String PARAM_INDEX = "index";
	
	protected static final String PARAMETER_ID_REF = "parameterIdRef";

	protected static final String INVOCATION_CONTEXT = "InvocationContext";
	protected static final String AGENT_ID_REF = "agentIdRef";
	protected static final String PROCESS_ID_REF = "processIdRef";
	protected static final String NODE_ID_REF = "nodeIdRef";
	protected static final String SEQUENCE_COUNTER = "sequenceCounter";

	protected static final String REMOTE_AGENT_ID_REF = "remoteAgentIdRef";
	protected static final String REMOTE_PROCESS_ID_REF = "remoteProcessIdRef";
	protected static final String REMOTE_NODE_ID_REF = "remoteNodeIdRef";
	protected static final String REMOTE_SEQUENCE_COUNTER = "remoteSequenceCounter";
	protected static final String REMOTE_THREAD_ID_REF = "remoteThreadIdRef";
	protected static final String REMOTE_TICKET = "remoteTicket";
	
	//~ Instance fields
	// ----------------------------------------------------------------------------
	protected CallStackPerThread cs;
	protected InvocationPool invocationPool;
	protected TRCClass invokerClass;
	protected TRCClass invokerObjectClass;
	protected TRCFullMethodInvocation fullInvocation;
	protected TRCFullMethodInvocation fullInvoker;
	protected TRCFullTraceObject invokerObject;
	protected TRCMethod invokerMethod;
	protected double deltaBaseTime;
	protected double lastChildExitTime;
	protected double previousSiblingExitTime;
	protected long ticket;
	protected short stackDepth;
	protected TRCObjectValue objectValue;
	protected int childCount;
	protected List inputValues = new FastList();
	protected List outputValues = new FastList();
	protected InvocationContext invocationContext = new InvocationContext();
	protected boolean activeInvocationContext;
	protected long sequenceCounter;
	protected static final Object REMOTE_INVOCATION_RESOLUTION_LOCK = new Object();
	protected boolean remoteInvocationContext;
	
	//~ Methods
	// ------------------------------------------------------------------------------------
	protected void updateTimeStatistics() {
		//update base time
		invokerMethod.setBaseTime(invokerMethod.getBaseTime() + deltaBaseTime);
		if (invokerObject != null) {
			invokerObject.setBaseTime(invokerObject.getBaseTime() + deltaBaseTime);
			if (invokerObjectClass != null) {
				invokerObjectClass.setInheritedBaseTime(invokerObjectClass.getInheritedBaseTime() + deltaBaseTime);
				invokerObjectClass.getPackage().setInheritedBaseTime(invokerObjectClass.getPackage().getInheritedBaseTime() + deltaBaseTime);
				invokerObjectClass.getPackage().getProcess().setInheritedBaseTime(invokerObjectClass.getPackage().getProcess().getInheritedBaseTime() + deltaBaseTime);
			}
		}
		invokerClass.setBaseTime(invokerClass.getBaseTime() + deltaBaseTime);
		invokerClass.getPackage().setBaseTime(invokerClass.getPackage().getBaseTime() + deltaBaseTime);
		invokerClass.getPackage().getProcess().setBaseTime(invokerClass.getPackage().getProcess().getBaseTime() + deltaBaseTime);
		//update cumulative time
		Iterator stackIter = cs.iterator();
		// current invocation should be on the stack for methodExit but not for
		// methodEntry
		while (stackIter.hasNext()) {
			InvocationInfo invocationInfo = (InvocationInfo) stackIter.next();
			if (!invocationInfo.isObjectLocked()) {
				TRCFullTraceObject obj = invocationInfo.getObject();
				obj.setCumulativeTime(obj.getCumulativeTime() + deltaBaseTime);
			}
			TRCClass objectClass = invocationInfo.getObjectClass();
			if ((objectClass != null) && !invocationInfo.isObjectClassLocked()) {
				objectClass.setInheritedCumulativeTime(objectClass.getInheritedCumulativeTime() + deltaBaseTime);
				objectClass.getPackage().setInheritedCumulativeTime(objectClass.getPackage().getInheritedCumulativeTime() + deltaBaseTime);
				objectClass.getPackage().getProcess().setInheritedCumulativeTime(objectClass.getPackage().getProcess().getInheritedCumulativeTime() + deltaBaseTime);
			}
			if (!invocationInfo.isMethodLocked()) {
				invocationInfo.getMethod().setCumulativeTime(invocationInfo.getMethod().getCumulativeTime() + deltaBaseTime);
			}
			if (!invocationInfo.isClassLocked()) {
				invokerClass = invocationInfo.getTheClass();
				invokerClass.setCumulativeTime(invokerClass.getCumulativeTime() + deltaBaseTime);
				invokerClass.getPackage().setCumulativeTime(invokerClass.getPackage().getCumulativeTime() + deltaBaseTime);
				invokerClass.getPackage().getProcess().setCumulativeTime(invokerClass.getPackage().getProcess().getCumulativeTime() + deltaBaseTime);
			}
		}
	}
	protected TRCClass getExtendedClass(TRCObject anObject, TRCClass aClass) {
		if (anObject != null) {
			if (anObject.getIsA() != aClass) {
				if (anObject.getIsA() != theProcess.getClassClass())
					return anObject.getIsA();
			}
		}
		return null;
	}
	/**
	 * @param theThread
	 */
	protected void setMaxStackDepth(TRCThread theThread) {
		if (theThread == null)
			return;
		if (stackDepth > theThread.getMaxStackDepth())
			theThread.setMaxStackDepth(stackDepth);
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.loaders.hierarchy.IgnoredXMLFragmentLoader#startChild(java.lang.String)
	 */
	public void startChild(String name) {
		childCount++;
		if (name.equals(PARAMETER)) {
			objectValue = TraceFactory.eINSTANCE.createTRCObjectValue();
			inputValues.add(objectValue);
		} else if (name.equals(RETURN_VALUE)) {
			objectValue = TraceFactory.eINSTANCE.createTRCObjectValue();
			outputValues.add(objectValue);
		}
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.loaders.hierarchy.IgnoredXMLFragmentLoader#endChild(java.lang.String)
	 */
	public void endChild(String name) {
		objectValue=null;
	}
	public void addInputOutputValues() {
		if(inputValues.isEmpty() && outputValues.isEmpty())
			return;
		List l = (List) getInputOutputContainer().getEntries().get(fullInvocation);
		if (l == null) {
			l = new FastList();
			getInputOutputContainer().getEntries().put(fullInvocation, l);
			l = (List) getInputOutputContainer().getEntries().get(fullInvocation);
		}
		if (!outputValues.isEmpty()) {
//			getInputOutputContainer().getInputOutputValues().add(outputValues.get(outputValues.size() - 1));
			l.set(0, outputValues.get(outputValues.size() - 1)); // last value wins
		} else if (l.isEmpty()) {
			TRCObjectValue objectValue = TraceFactory.eINSTANCE.createTRCObjectValue(); 
//			getInputOutputContainer().getInputOutputValues().add(objectValue);
			l.add(objectValue); // reserve the first entry for return value
		}
		if (!inputValues.isEmpty()) {
//			getInputOutputContainer().getInputOutputValues().addAll(inputValues);
			if (this instanceof XMLmethodExitLoader && l.size() < (inputValues.size() + 1)) {
				for (int i = 0; i < inputValues.size(); i++) {
					l.add(TraceFactory.eINSTANCE.createTRCObjectValue()); // fill gap for methodEntry input values
				}
			}
			l.addAll(inputValues); // concatenate all input values at the end of the list
		}
	}
	/**
	 * @return
	 */
	protected TRCInputOutputContainer getInputOutputContainer() {
		TRCInputOutputContainer inputOutputContainer = getProcess().getInputOutputContainer();
		if (inputOutputContainer == null) {
			inputOutputContainer = TraceFactory.eINSTANCE.createTRCInputOutputContainer();
			inputOutputContainer.setProcess(getProcess());
			Resource r = createInputOutputContainerResource(inputOutputContainer);
			r.getContents().add(inputOutputContainer);
		}
		return inputOutputContainer;
	}
	/**
	 * @param inputOutputContainer
	 */
	protected Resource createInputOutputContainerResource(TRCInputOutputContainer inputOutputContainer) {
		String uri = inputOutputContainer.getProcess().eResource().getURI().toString();
		String newUri = uri.substring(0, uri.indexOf(".trca"));
		newUri = newUri.concat(".trciov").concat(uri.substring(uri.indexOf(".trca") + 5));
		return HierarchyResourceSetImpl.getInstance().createResource(SaveUtil.createURI(newUri));
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.loaders.trace.TraceXMLFragmentLoader#addAttribute(java.lang.String, java.lang.String)
	 */
	public void addAttribute(String name, String value) {
		switch (LoadersUtils.getHashCode(name)) {
			case TraceConstants.STACK_DEPTH_int :
				stackDepth = Short.parseShort(value);
				break;
			case TraceConstants.TICKET_int :
				if (!activeInvocationContext) {
					ticket = Long.parseLong(value);
				} else {
					invocationContext.setInvocationTicket(Long.parseLong(value));
				}
				break;
			case TraceConstants.SEQUENCE_COUNTER_int :
				if (!activeInvocationContext) {
					sequenceCounter = Long.parseLong(value);
				} else {
					invocationContext.setInvocationSequenceCounter(Long.parseLong(value));
				}
				break;
			case TraceConstants.NODE_ID_REF_int :
				if (activeInvocationContext) {
					invocationContext.setInvocationNodeIdRef(value);
				}
				break;
			case TraceConstants.PROCESS_ID_REF_int :
				if (activeInvocationContext) {
					invocationContext.setInvocationProcessIdRef(value);
				}
				break;
			case TraceConstants.AGENT_ID_REF_int :
				if (activeInvocationContext) {
					invocationContext.setInvocationAgentIdRef(value);
				}
				break;
			case TraceConstants.THREAD_ID_REF_int :
				if (!activeInvocationContext) {
					threadIdRef = Integer.parseInt(value);
				} else {
					invocationContext.setInvocationThreadIdRef(Integer.parseInt(value));
				}
				break;
			case TraceConstants.REMOTE_AGENT_ID_REF_int:
				if(!remoteInvocationContext)
				{
					setNullInvocationContext();
					remoteInvocationContext=true;
				}
				invocationContext.setInvocationAgentIdRef(value);
				break;
			case TraceConstants.REMOTE_NODE_ID_REF_int:
				if(!remoteInvocationContext)
				{
					setNullInvocationContext();
					remoteInvocationContext=true;
				}
				invocationContext.setInvocationNodeIdRef(value);
				break;
			case TraceConstants.REMOTE_PROCESS_ID_REF_int:
				if(!remoteInvocationContext)
				{
					setNullInvocationContext();
					remoteInvocationContext=true;
				}
				invocationContext.setInvocationProcessIdRef(value);
				break;
			case TraceConstants.REMOTE_THREAD_ID_REF_int:
				if(!remoteInvocationContext)
				{
					setNullInvocationContext();
					remoteInvocationContext=true;
				}
				invocationContext.setInvocationThreadIdRef(Integer.parseInt(value));
				break;
			case TraceConstants.REMOTE_SEQUENCE_COUNTER_int:
				if(!remoteInvocationContext)
				{
					setNullInvocationContext();
					remoteInvocationContext=true;
				}
				invocationContext.setInvocationSequenceCounter(Long.parseLong(value));
				break;
			case TraceConstants.REMOTE_TICKET_int:
				if(!remoteInvocationContext)
				{
					setNullInvocationContext();
					remoteInvocationContext=true;
				}
				invocationContext.setInvocationTicket(Long.parseLong(value));
				break;
			case TraceConstants.PARAMETER_ID_REF_int:
				//do nothing
				break;
			case TraceConstants.VALUE_int :
				if (objectValue!=null) {
					objectValue.setStringValue(value);
				}
				break;
			case TraceConstants.VALUE_KIND_int :
				if (objectValue!=null) {
					convertToTypedObjectValue();
					((TRCTypedObjectValue)objectValue).setValueKind(TRCObjectValueKind.get(value));
				}
				break;
			case TraceConstants.VALUE_POSITION_int :
				if (objectValue!=null) {
					convertToTypedObjectValue();
					((TRCTypedObjectValue)objectValue).setPositionKind(TRCObjectValuePosition.get(value));
				}
				break;
			case TraceConstants.PARAM_INDEX_int :
				if (objectValue!=null) {
					convertToTypedObjectValue();
					((TRCTypedObjectValue)objectValue).setPosition(Short.parseShort(value));
				}
				break;
				
			default :
				super.addAttribute(name,value);
				break;
		}
	}

	protected void convertToTypedObjectValue() {
		if(objectValue instanceof TRCTypedObjectValue)
			return;
		int i = outputValues.indexOf(objectValue);
		TRCTypedObjectValue newObjectValue = TraceFactory.eINSTANCE.createTRCTypedObjectValue();
		newObjectValue.setStringValue(objectValue.getStringValue());
		objectValue = newObjectValue;
		outputValues.set(i,objectValue);
	}
	protected void setNullInvocationContext() {
		invocationContext.setInvocationAgentIdRef(null);
		invocationContext.setInvocationNodeIdRef(null);
		invocationContext.setInvocationProcessIdRef(null);
		invocationContext.setInvocationSequenceCounter(0);
		invocationContext.setInvocationThreadIdRef(0);
		invocationContext.setInvocationTicket(0);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.loaders.trace.TraceXMLFragmentLoader#initialize(org.eclipse.hyades.loaders.util.HierarchyContext, java.lang.String)
	 */
	public void initialize(HierarchyContext context, String name) {
		super.initialize(context, name);
		activeInvocationContext=false;
		remoteInvocationContext=false;
        stackDepth = 0;
        ticket = 0;
        sequenceCounter = 0;
		inputValues.clear();
		outputValues.clear();
		objectValue=null;
	}
	protected TRCFullMethodInvocation resolveInvocation(InvocationContext invContext) {
		TRCFullMethodInvocation targetInvocation = null;
		try {
			TRCAgent targetAgent = null;
			HierarchyContext invokerContext;
			AgentsContext agentsContext = (AgentsContext) LookupServiceExtensions.getInstance().locate(null, AgentsContext.class, LoadersUtils.getLookUpKey(invContext.getInvocationAgentIdRef()));
			if (agentsContext != null) {
				targetAgent = agentsContext.getActiveAgent(context.getAgent());
			}
			if (targetAgent != null) {
				HierarchyContext targetContext = LoadersUtils.locateHierarchyContext(targetAgent);
				if (targetContext != null) {
					targetInvocation = (TRCFullMethodInvocation) LookupServiceExtensions.getInstance().locate(targetContext, TRCFullMethodInvocation.class, LoadersUtils.getLookUpKey(TraceUtils.getMethodInvocationId(invContext)));
					if (targetInvocation == null) {
						boolean inOrder = false;
						TRCThread targetThread = (TRCThread) LookupServiceExtensions.getInstance().locate(targetContext, TRCThreadImpl.class, LoadersUtils.getLookUpKey(invContext.getInvocationThreadIdRef()));
						if (targetThread != null) {
							Iterator invocationIterator = targetThread.getInitialInvocations().iterator();
							while (invocationIterator.hasNext()) {
								fullInvoker = (TRCFullMethodInvocation) invocationIterator.next();
								if (!TRCFullMethodInvocationImpl.class.isAssignableFrom(fullInvoker.getClass())) {
									continue;
								}
								if ((fullInvoker.getThread() == targetThread) && (((TRCFullMethodInvocationImpl) fullInvoker).getTicket() == invContext.getInvocationTicket())) {
									inOrder = true;
									break;
								}
								if (checkTicket(targetThread, fullInvoker.getInvokes(), invContext.getInvocationTicket())) {
									inOrder = true;
									break;
								}
							}
						}
						if (inOrder) {
							targetInvocation = fullInvoker;
						}
					}
				}
			}
		} catch (Exception e) {
			LoadersUtils.log(e);
		}
		return targetInvocation;
	}
	protected boolean checkTicket(TRCThread theThread, EList list, long ticket) {
		boolean inOrder = false;
		for (Iterator iter = list.iterator(); iter.hasNext();) {
			fullInvoker = (TRCFullMethodInvocation) iter.next();
			if (fullInvoker.getClass() != TRCFullMethodInvocationImpl.class) {
				continue;
			}
			if ((fullInvoker.getThread() == theThread) && (((TRCFullMethodInvocationImpl) fullInvoker).getTicket() == ticket)) {
				inOrder = true;
				break;
			}
			if (checkTicket(theThread, fullInvoker.getInvokes(), ticket)) {
				inOrder = true;
				break;
			}
		}
		return inOrder;
	}
	/**
	 * @return The invoker's TRCMethodInvocation.
	 */
	protected TRCMethodInvocation setInvokerMethod(TRCThread thread, TRCMethodInvocation invocation) {
		/*
		 * If there is no invocation context then we were invoked on the current
		 * thread and we just need to look at the top of the stack to find our
		 * parent. Otherwise, we need to to look for our invoker based upon the
		 * context information we have. If we cannot find our invoker we can add
		 * this to the bottom of the stack initially and then update it later
		 * when our invoker is loaded.
		 */
		if (activeInvocationContext || remoteInvocationContext) {
			fullInvoker = resolveInvocation(invocationContext);
			if (fullInvoker == null) {
				/*
				 * If we get this far we have arrived before our invokers method
				 * entry, so add us to the callee of the remote method
				 */
				addForwardInvocation(invocation);
			} else {
				//System.out.println("Remote Invocation -- In order");
				invocation.setInvokedBy(fullInvoker);
			}
		} else {
			/* Local invocation or we could not find our invoker */
			if ((cs != null) && !cs.isEmpty()) {
				fullInvoker = ((InvocationInfo) cs.peek()).getMethodInvocation();
			}
			if (fullInvoker != null) {
				if(fullInvoker.getStackDepth()<stackDepth)
					invocation.setInvokedBy(fullInvoker);
				else
				{
					while (fullInvoker.getInvokedBy()!=null && fullInvoker.getInvokedBy() instanceof TRCFullMethodInvocation) {
						fullInvoker = (TRCFullMethodInvocation)fullInvoker.getInvokedBy();
						if(fullInvoker.getStackDepth()<stackDepth)
							invocation.setInvokedBy(fullInvoker);
						break;
					}
				}
			}
		}
		return fullInvoker;
	}
	protected void addForwardInvocation(TRCMethodInvocation invocation) {
		String contextId = invocationContext.getInvocationAgentIdRef() + "/" + invocationContext.getInvocationThreadIdRef() + "/" + invocationContext.getInvocationTicket() + "/" + invocationContext.getInvocationSequenceCounter();
		UnresolvedCorrelation unresolvedCorrelation = HierarchyFactory.eINSTANCE.createUnresolvedCorrelation();
		unresolvedCorrelation.setContextId(contextId);
		CorrelationSourceInfo correlationSourceInfo = HierarchyFactory.eINSTANCE.createCorrelationSourceInfo();
		correlationSourceInfo.setOwner(invocation);
		correlationSourceInfo.setReference(TracePackage.eINSTANCE.getTRCMethodInvocation_InvokedBy());
		unresolvedCorrelation.getSourceInfos().add(correlationSourceInfo);
		unresolvedCorrelation.setAgent(context.getAgent());
	}
	/**
	 * Resolves the links to posible target invocations, invocation that were
	 * received before the invoker (sourceInvocation)
	 */
	protected void updateForwardInvokes(TRCMethodInvocation sourceInvocation) {
		//        InvocationContext source;
		UnresolvedCorrelation unresolvedCorrelation = (UnresolvedCorrelation) LookupServiceExtensions.getInstance().locate(null, UnresolvedCorrelationImpl.class, /*
																																								   * context.getNode().getRuntimeId() +
																																								   * "/" +
																																								   * context.getProcessProxy().getRuntimeId() +
																																								   * "/" +
																																								   */
		context.getAgent().getRuntimeId() + "/" + threadIdRef + "/" + ticket + "/" + sequenceCounter);
		if (unresolvedCorrelation != null) {
			for (Iterator iterator = unresolvedCorrelation.getSourceInfos().iterator(); iterator.hasNext();) {
				CorrelationSourceInfo correlationSourceInfo = (CorrelationSourceInfo) iterator.next();
				EReference reference = correlationSourceInfo.getReference();
				EObject owner = correlationSourceInfo.getOwner();
				if (owner instanceof TRCMethodInvocation && (reference == TracePackage.eINSTANCE.getTRCMethodInvocation_InvokedBy())) {
					if (sourceInvocation != null) {
						((TRCMethodInvocation) owner).setInvokedBy(sourceInvocation);
						iterator.remove();
					}
				}
			}
			if (unresolvedCorrelation.getSourceInfos().size() == 0) {
				unresolvedCorrelation.setAgent(null);
			}
		}
	}
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.loaders.hierarchy.IgnoredXMLFragmentLoader#addCharacters(char[], int, int)
	 */
	public void addCharacters(char[] data, int offset, int length) {
		super.addCharacters(data, offset, length);
		if (objectValue!=null) {
			objectValue.setStringValue(objectValue.getStringValue()+(new String(data,offset,length)));
		}
		
	}
}