/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 * 
 * $Id: XMLmethodInvocationsLoader.java,v 1.8 2004/12/15 15:53:23 slavescu Exp $
 **********************************************************************/
package org.eclipse.hyades.loaders.trace;

import java.util.Iterator;
import org.eclipse.hyades.loaders.hierarchy.Constants;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.models.trace.TRCAggregatedMethodInvocation;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TraceFactory;
import org.eclipse.hyades.models.trace.impl.TRCMethodImpl;
import org.eclipse.hyades.models.trace.impl.TRCMethodWithLLDataImpl;

/**
 * @author slavescu
 * @since 3.2
 */
public class XMLmethodInvocationsLoader extends TraceXMLFragmentLoader {
	protected static final String MIN_VALUE = "minValue";

	protected static final String MAX_VALUE = "maxValue";

	protected static final String TOTAL_TIME = "totalTime";

	protected static final String COUNT = "count";

	protected double minValue; // added to aggregated invocation
	
	protected double maxValue; // added to aggregated invocation

	protected double totalTime; // added to cumulative time

	protected int count; // added to calls

	protected TRCAggregatedMethodInvocation invocation;

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.loaders.trace.TraceXMLFragmentLoader#addAttribute(java.lang.String,
	 *      java.lang.String)
	 */
	public void addAttribute(String name, String value) {
		if (!loadToModel) {
			return;
		}
		switch (LoadersUtils.getHashCode(name)) {
		case TraceConstants.MIN_VALUE_int:
			minValue = Double.parseDouble(value);
			break;
		case TraceConstants.MAX_VALUE_int:
			maxValue = Double.parseDouble(value);
			break;
		case TraceConstants.TOTAL_TIME_int:
			totalTime = Double.parseDouble(value);
			break;
		case TraceConstants.COUNT_int:
			count = Integer.parseInt(value);
			break;
		default:
			super.addAttribute(name, value);
			break;
		}

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.loaders.hierarchy.IgnoredXMLFragmentLoader#addYourselfInContext()
	 */
	public void addYourselfInContext() {
		if (!loadToModel) {
			return;
		}
		theProcess = getProcess();
		Class clazz = TraceUtils.isBooleanOptionEnabled(context,
				Constants.LLDATA_ENABLED) ? TRCMethodWithLLDataImpl.class
				: TRCMethodImpl.class;
		theMethod = (TRCMethod) LookupServiceExtensions.getInstance().locate(
				context, clazz, LoadersUtils.getLookUpKey(methodIdRef));
		if (theMethod == null)
			return;
		
		if(maxValue!=0)
			getAggregatedInvocation().setMaxTime(maxValue);
		if(minValue!=0)
			getAggregatedInvocation().setMinTime(minValue);
		if(totalTime!=0)
		{
			theMethod.setCumulativeTime(theMethod.getCumulativeTime()+totalTime);
			theMethod.getDefiningClass().setCumulativeTime(theMethod.getDefiningClass().getCumulativeTime()+totalTime);
			theMethod.getDefiningClass().getPackage().setCumulativeTime(theMethod.getDefiningClass().getPackage().getCumulativeTime()+totalTime);
			theProcess.setCumulativeTime(theProcess.getCumulativeTime()+totalTime);
			if(invocation!=null)
				invocation.setCumulativeTime(totalTime);
		}
		if(count!=0)
		{
			if(invocation!=null)
			{	
				theMethod.setCalls(theMethod.getCalls()+count);
				theMethod.getDefiningClass().setCalls(theMethod.getDefiningClass().getCalls()+count);
				theMethod.getDefiningClass().getPackage().setCalls(theMethod.getDefiningClass().getPackage().getCalls()+count);
				theProcess.setCalls(theProcess.getCalls()+count);
				invocation.setCount(count);
			}
			else if(count > theMethod.getCalls())
			{
				theMethod.setCalls(count);
				theMethod.getDefiningClass().setCalls(count);
				theMethod.getDefiningClass().getPackage().setCalls(count);
				theProcess.setCalls(count);
			}
		}
	}

	protected TRCAggregatedMethodInvocation getAggregatedInvocation() {
		if(invocation != null)
		{
			return invocation;
		}
		for (Iterator iter = theMethod.getInvocations().iterator(); iter.hasNext();) {
			TRCMethodInvocation element = (TRCMethodInvocation) iter.next();
			if(element instanceof TRCAggregatedMethodInvocation)
			{
				invocation = (TRCAggregatedMethodInvocation)element;
				break;
			}
		}
		
		if(invocation == null)
		{
			invocation = TraceFactory.eINSTANCE.createTRCAggregatedMethodInvocation();
			theMethod.getInvocations().add(invocation);
			theProcess.getInvocations().add(invocation);
		}
		return invocation;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.loaders.trace.TraceXMLFragmentLoader#initialize(org.eclipse.hyades.loaders.util.HierarchyContext,
	 *      java.lang.String)
	 */
	public void initialize(HierarchyContext context, String name) {
		loadToModel = context.isLoadToModel();
		if (!loadToModel) {
			return;
		}
		super.initialize(context, name);
		minValue = 0;
		maxValue = 0;
		totalTime = 0;
		count = 0;
		invocation = null;
		
	}
}