/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 * 
 * $Id: XMLtraceStartLoader.java,v 1.8 2004/11/22 21:48:51 slavescu Exp $
 **********************************************************************/
package org.eclipse.hyades.loaders.trace;

import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.models.trace.TRCProcess;


/**
 * @author slavescu
 *
 */
public class XMLtraceStartLoader extends TraceXMLFragmentLoader {
    //~ Instance fields ----------------------------------------------------------------------------
	
    protected static final String TRACE_ID = "traceId";
    protected static final String CPU_SAMPLE_RESOLUTION = "cpuSampleResolution";
    protected String traceId;
    protected double cpuSampleResolution;

    //~ Methods ------------------------------------------------------------------------------------

    public void addAttribute(String name, String value) {
        switch (LoadersUtils.getHashCode(name)) {
            case TraceConstants.TRACE_ID_int:
                traceId = value;

                break;
            case TraceConstants.CPU_SAMPLE_RESOLUTION_int:
            	cpuSampleResolution = Double.parseDouble(value);

                break;

            default:
                super.addAttribute(name, value);

                break;
            }
    }

    public void addYourselfInContext() {
        //        zeroTime = time;
		if(context.getAgent()!=null)
		{
			context.getAgent().setStartTime(time);
			if(context.getAgent().getAgentProxy()!=null)
				context.getAgent().getAgentProxy().setStartTime(time);
		}

        TRCProcess p = getProcess();

        if (p.getStartTime() == 0) {
            p.setStartTime(createDeltaTime());
        }
        p.setId(traceId);
        p.setCpuSampleResolution(cpuSampleResolution);

        // cleanup the call stack for previous trace (if exists)
        LookupServiceExtensions.getInstance().deregister(context, CallStackPerThread.class);
    }

    public void initialize(HierarchyContext context, String name) {
        super.initialize(context, name);
        traceId = null;
        cpuSampleResolution=0;
    }
}
