/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TRCClass.java,v 1.13 2004/12/03 17:22:57 slavescu Exp $
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.trace;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>TRC Class</b></em>'.
 * @extends org.eclipse.hyades.loaders.trace.IDeltaManager
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This represents a complex type (a Java class for example)
 * 
 * - calls, baseTime, and cumulativeTime: these are aggregate measures of all the method invocations whose receiver object is of the given class (or package, or  process).  For cumulativeTime, time spent in any method invocations that call each other is not counted more than once for that class (or package, or process).
 * 
 * - inheritedCalls, inheritedBaseTime, and inheritedCumulativeTime: these are aggregate measures of all the method invocations whose receiver object is of the given class (or package, or process), but limited to those whose method is not implemented in the class of the receiver object (i.e. it is implemented in a class further up in the class hierarchy).
 * 
 * 
 * 
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCClass#getId <em>Id</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCClass#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCClass#getSize <em>Size</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCClass#getLoadTime <em>Load Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCClass#getUnloadTime <em>Unload Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCClass#isInterface <em>Interface</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCClass#getLineNo <em>Line No</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCClass#getBaseTime <em>Base Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCClass#getCumulativeTime <em>Cumulative Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCClass#getCalls <em>Calls</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCClass#getInheritedCalls <em>Inherited Calls</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCClass#getInheritedBaseTime <em>Inherited Base Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCClass#getInheritedCumulativeTime <em>Inherited Cumulative Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCClass#getTotalSize <em>Total Size</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCClass#getTotalInstances <em>Total Instances</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCClass#getCollectedSize <em>Collected Size</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCClass#getCollectedInstances <em>Collected Instances</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCClass#getTotalCpuTime <em>Total Cpu Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCClass#getObjects <em>Objects</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCClass#getLoadedBy <em>Loaded By</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCClass#getMethods <em>Methods</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCClass#getClassObjects <em>Class Objects</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCClass#getPackage <em>Package</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCClass#getClassLoader <em>Class Loader</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCClass#getSourceInfo <em>Source Info</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCClass#getEnclosedBy <em>Enclosed By</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCClass#getExtends <em>Extends</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCClass#getImplements <em>Implements</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCClass#getLocks <em>Locks</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCClass()
 * @model 
 * @generated
 */
public interface TRCClass extends EObject, org.eclipse.hyades.loaders.trace.IDeltaManager{
	/**
	 * Returns the value of the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Id</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * An unique ID for this class during a monitoring session. By persisting this we can have sessions with disconnected segments, e.g. attach, start monitoring, pause monitoring, shutdown client, restart client,  re-attach to same session and continue monitoring.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Id</em>' attribute.
	 * @see #setId(long)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCClass_Id()
	 * @model dataType="org.eclipse.hyades.models.trace.EClassID"
	 * @generated
	 */
	long getId();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCClass#getId <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Id</em>' attribute.
	 * @see #getId()
	 * @generated
	 */
	void setId(long value);

	/**
	 * Returns the value of the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Name</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The class name, without the package qualified part of the name. In the case of synthetic names they will be captured in the form that is meaningful to the synthesizer.
	 * Classes where the name is unknown will have a class name of _unknown.
	 * 
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Name</em>' attribute.
	 * @see #setName(String)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCClass_Name()
	 * @model 
	 * @generated
	 */
	String getName();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCClass#getName <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Name</em>' attribute.
	 * @see #getName()
	 * @generated
	 */
	void setName(String value);

	/**
	 * Returns the value of the '<em><b>Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Size</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The size of one instance of this class. If the class is an array, this field specifies the size of the type of the elements in the array and the size of array it is specified in the size field of TRCArrayObject. [Note: the representation of array types is undergoing design changes.]
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Size</em>' attribute.
	 * @see #setSize(int)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCClass_Size()
	 * @model 
	 * @generated
	 */
	int getSize();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCClass#getSize <em>Size</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Size</em>' attribute.
	 * @see #getSize()
	 * @generated
	 */
	void setSize(int value);

	/**
	 * Returns the value of the '<em><b>Load Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Load Time</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * When the class was loaded, relative to hierarchy.TRCAgent.startTime
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Load Time</em>' attribute.
	 * @see #setLoadTime(double)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCClass_LoadTime()
	 * @model 
	 * @generated
	 */
	double getLoadTime();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCClass#getLoadTime <em>Load Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Load Time</em>' attribute.
	 * @see #getLoadTime()
	 * @generated
	 */
	void setLoadTime(double value);

	/**
	 * Returns the value of the '<em><b>Unload Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Unload Time</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * When the class was unloaded, relative to hierarchy.TRCAgent.startTime
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Unload Time</em>' attribute.
	 * @see #setUnloadTime(double)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCClass_UnloadTime()
	 * @model 
	 * @generated
	 */
	double getUnloadTime();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCClass#getUnloadTime <em>Unload Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Unload Time</em>' attribute.
	 * @see #getUnloadTime()
	 * @generated
	 */
	void setUnloadTime(double value);

	/**
	 * Returns the value of the '<em><b>Interface</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Interface</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * True if the class is an interface
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Interface</em>' attribute.
	 * @see #setInterface(boolean)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCClass_Interface()
	 * @model 
	 * @generated
	 */
	boolean isInterface();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCClass#isInterface <em>Interface</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Interface</em>' attribute.
	 * @see #isInterface()
	 * @generated
	 */
	void setInterface(boolean value);

	/**
	 * Returns the value of the '<em><b>Line No</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Line No</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The line number in the source info where the declaration of this class starts.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Line No</em>' attribute.
	 * @see #setLineNo(int)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCClass_LineNo()
	 * @model 
	 * @generated
	 */
	int getLineNo();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCClass#getLineNo <em>Line No</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Line No</em>' attribute.
	 * @see #getLineNo()
	 * @generated
	 */
	void setLineNo(int value);

	/**
	 * Returns the value of the '<em><b>Base Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Base Time</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Time spent in methods of the owning element
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Base Time</em>' attribute.
	 * @see #setBaseTime(double)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCClass_BaseTime()
	 * @model 
	 * @generated
	 */
	double getBaseTime();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCClass#getBaseTime <em>Base Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Base Time</em>' attribute.
	 * @see #getBaseTime()
	 * @generated
	 */
	void setBaseTime(double value);

	/**
	 * Returns the value of the '<em><b>Cumulative Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Cumulative Time</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Time spent in methods of this owning element + all methods called from these methods (but owned by other elements)
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Cumulative Time</em>' attribute.
	 * @see #setCumulativeTime(double)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCClass_CumulativeTime()
	 * @model 
	 * @generated
	 */
	double getCumulativeTime();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCClass#getCumulativeTime <em>Cumulative Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Cumulative Time</em>' attribute.
	 * @see #getCumulativeTime()
	 * @generated
	 */
	void setCumulativeTime(double value);

	/**
	 * Returns the value of the '<em><b>Calls</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Calls</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * number of calls to the owning element
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Calls</em>' attribute.
	 * @see #setCalls(int)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCClass_Calls()
	 * @model 
	 * @generated
	 */
	int getCalls();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCClass#getCalls <em>Calls</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Calls</em>' attribute.
	 * @see #getCalls()
	 * @generated
	 */
	void setCalls(int value);

	/**
	 * Returns the value of the '<em><b>Inherited Calls</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Inherited Calls</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Number of calls to methods defined in superclasses of classes from the owning element
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Inherited Calls</em>' attribute.
	 * @see #setInheritedCalls(int)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCClass_InheritedCalls()
	 * @model 
	 * @generated
	 */
	int getInheritedCalls();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCClass#getInheritedCalls <em>Inherited Calls</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Inherited Calls</em>' attribute.
	 * @see #getInheritedCalls()
	 * @generated
	 */
	void setInheritedCalls(int value);

	/**
	 * Returns the value of the '<em><b>Inherited Base Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Inherited Base Time</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Time spent in methods defined in superclasses of this classes from the owning element
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Inherited Base Time</em>' attribute.
	 * @see #setInheritedBaseTime(double)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCClass_InheritedBaseTime()
	 * @model 
	 * @generated
	 */
	double getInheritedBaseTime();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCClass#getInheritedBaseTime <em>Inherited Base Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Inherited Base Time</em>' attribute.
	 * @see #getInheritedBaseTime()
	 * @generated
	 */
	void setInheritedBaseTime(double value);

	/**
	 * Returns the value of the '<em><b>Inherited Cumulative Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Inherited Cumulative Time</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Time spent in methods of classes from the owning element + all methods called from the methods defined in superclasses of classes from the owning element
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Inherited Cumulative Time</em>' attribute.
	 * @see #setInheritedCumulativeTime(double)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCClass_InheritedCumulativeTime()
	 * @model 
	 * @generated
	 */
	double getInheritedCumulativeTime();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCClass#getInheritedCumulativeTime <em>Inherited Cumulative Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Inherited Cumulative Time</em>' attribute.
	 * @see #getInheritedCumulativeTime()
	 * @generated
	 */
	void setInheritedCumulativeTime(double value);

	/**
	 * Returns the value of the '<em><b>Total Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Total Size</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The total size of memory allocated
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Total Size</em>' attribute.
	 * @see #setTotalSize(int)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCClass_TotalSize()
	 * @model 
	 * @generated
	 */
	int getTotalSize();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCClass#getTotalSize <em>Total Size</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Total Size</em>' attribute.
	 * @see #getTotalSize()
	 * @generated
	 */
	void setTotalSize(int value);

	/**
	 * Returns the value of the '<em><b>Total Instances</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Total Instances</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Number of instances created
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Total Instances</em>' attribute.
	 * @see #setTotalInstances(int)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCClass_TotalInstances()
	 * @model 
	 * @generated
	 */
	int getTotalInstances();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCClass#getTotalInstances <em>Total Instances</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Total Instances</em>' attribute.
	 * @see #getTotalInstances()
	 * @generated
	 */
	void setTotalInstances(int value);

	/**
	 * Returns the value of the '<em><b>Collected Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Collected Size</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The total size of memory garbage collected
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Collected Size</em>' attribute.
	 * @see #setCollectedSize(int)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCClass_CollectedSize()
	 * @model 
	 * @generated
	 */
	int getCollectedSize();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCClass#getCollectedSize <em>Collected Size</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Collected Size</em>' attribute.
	 * @see #getCollectedSize()
	 * @generated
	 */
	void setCollectedSize(int value);

	/**
	 * Returns the value of the '<em><b>Collected Instances</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Collected Instances</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Number of instances garbage collected
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Collected Instances</em>' attribute.
	 * @see #setCollectedInstances(int)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCClass_CollectedInstances()
	 * @model 
	 * @generated
	 */
	int getCollectedInstances();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCClass#getCollectedInstances <em>Collected Instances</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Collected Instances</em>' attribute.
	 * @see #getCollectedInstances()
	 * @generated
	 */
	void setCollectedInstances(int value);

	/**
	 * Returns the value of the '<em><b>Total Cpu Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Holds the thread CPU time consumed by all invocations of all methods in this class.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Total Cpu Time</em>' attribute.
	 * @see #setTotalCpuTime(double)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCClass_TotalCpuTime()
	 * @model 
	 * @generated
	 */
	double getTotalCpuTime();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCClass#getTotalCpuTime <em>Total Cpu Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Total Cpu Time</em>' attribute.
	 * @see #getTotalCpuTime()
	 * @generated
	 */
	void setTotalCpuTime(double value);

	/**
	 * Returns the value of the '<em><b>Objects</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.trace.TRCObject}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.trace.TRCObject#getIsA <em>Is A</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Objects</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * transient
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Objects</em>' reference list.
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCClass_Objects()
	 * @see org.eclipse.hyades.models.trace.TRCObject#getIsA
	 * @model type="org.eclipse.hyades.models.trace.TRCObject" opposite="isA" transient="true"
	 * @generated
	 */
	EList getObjects();

	/**
	 * Returns the value of the '<em><b>Loaded By</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Loaded By</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Loaded By</em>' reference.
	 * @see #setLoadedBy(TRCThread)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCClass_LoadedBy()
	 * @model required="true"
	 * @generated
	 */
	TRCThread getLoadedBy();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCClass#getLoadedBy <em>Loaded By</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Loaded By</em>' reference.
	 * @see #getLoadedBy()
	 * @generated
	 */
	void setLoadedBy(TRCThread value);

	/**
	 * Returns the value of the '<em><b>Methods</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.trace.TRCMethod}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.trace.TRCMethod#getDefiningClass <em>Defining Class</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Methods</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Methods</em>' containment reference list.
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCClass_Methods()
	 * @see org.eclipse.hyades.models.trace.TRCMethod#getDefiningClass
	 * @model type="org.eclipse.hyades.models.trace.TRCMethod" opposite="definingClass" containment="true"
	 * @generated
	 */
	EList getMethods();

	/**
	 * Returns the value of the '<em><b>Class Objects</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.trace.TRCObject}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Class Objects</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This should be resolved only for the resources that are in memory. Usualy there are only to entries in this collection (one for heap and one for execution).
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Class Objects</em>' reference list.
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCClass_ClassObjects()
	 * @model type="org.eclipse.hyades.models.trace.TRCObject"
	 * @generated
	 */
	EList getClassObjects();

	/**
	 * Returns the value of the '<em><b>Package</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.trace.TRCPackage#getClasses <em>Classes</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Package</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Package</em>' container reference.
	 * @see #setPackage(TRCPackage)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCClass_Package()
	 * @see org.eclipse.hyades.models.trace.TRCPackage#getClasses
	 * @model opposite="classes" required="true"
	 * @generated
	 */
	TRCPackage getPackage();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCClass#getPackage <em>Package</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Package</em>' container reference.
	 * @see #getPackage()
	 * @generated
	 */
	void setPackage(TRCPackage value);

	/**
	 * Returns the value of the '<em><b>Class Loader</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Class Loader</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Class Loader</em>' reference.
	 * @see #setClassLoader(TRCClassLoader)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCClass_ClassLoader()
	 * @model 
	 * @generated
	 */
	TRCClassLoader getClassLoader();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCClass#getClassLoader <em>Class Loader</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Class Loader</em>' reference.
	 * @see #getClassLoader()
	 * @generated
	 */
	void setClassLoader(TRCClassLoader value);

	/**
	 * Returns the value of the '<em><b>Source Info</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Source Info</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Source Info</em>' reference.
	 * @see #setSourceInfo(TRCSourceInfo)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCClass_SourceInfo()
	 * @model 
	 * @generated
	 */
	TRCSourceInfo getSourceInfo();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCClass#getSourceInfo <em>Source Info</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Source Info</em>' reference.
	 * @see #getSourceInfo()
	 * @generated
	 */
	void setSourceInfo(TRCSourceInfo value);

	/**
	 * Returns the value of the '<em><b>Enclosed By</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Enclosed By</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Enclosed By</em>' reference.
	 * @see #setEnclosedBy(TRCClass)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCClass_EnclosedBy()
	 * @model 
	 * @generated
	 */
	TRCClass getEnclosedBy();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCClass#getEnclosedBy <em>Enclosed By</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Enclosed By</em>' reference.
	 * @see #getEnclosedBy()
	 * @generated
	 */
	void setEnclosedBy(TRCClass value);

	/**
	 * Returns the value of the '<em><b>Extends</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.trace.TRCClass}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Extends</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Extends</em>' reference list.
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCClass_Extends()
	 * @model type="org.eclipse.hyades.models.trace.TRCClass"
	 * @generated
	 */
	EList getExtends();

	/**
	 * Returns the value of the '<em><b>Implements</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.trace.TRCClass}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Implements</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Implements</em>' reference list.
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCClass_Implements()
	 * @model type="org.eclipse.hyades.models.trace.TRCClass"
	 * @generated
	 */
	EList getImplements();

	/**
	 * Returns the value of the '<em><b>Locks</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.trace.TRCLockAccess}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Locks</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Locks</em>' reference list.
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCClass_Locks()
	 * @model type="org.eclipse.hyades.models.trace.TRCLockAccess"
	 * @generated
	 */
	EList getLocks();

} // TRCClass
