/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TRCObjectValueKind.java,v 1.6 2004/12/03 17:22:57 slavescu Exp $
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.trace;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.AbstractEnumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>TRC Object Value Kind</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCObjectValueKind()
 * @model
 * @generated
 */
public final class TRCObjectValueKind extends AbstractEnumerator {
	/**
	 * The '<em><b>This</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #THIS_LITERAL
	 * @model name="this"
	 * @generated
	 * @ordered
	 */
	public static final int THIS = 0;

	/**
	 * The '<em><b>Aggregated</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #AGGREGATED_LITERAL
	 * @model name="aggregated"
	 * @generated
	 * @ordered
	 */
	public static final int AGGREGATED = 1;

	/**
	 * The '<em><b>Query</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #QUERY_LITERAL
	 * @model name="query"
	 * @generated
	 * @ordered
	 */
	public static final int QUERY = 2;

	/**
	 * The '<em><b>Protocol</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PROTOCOL_LITERAL
	 * @model name="protocol"
	 * @generated
	 * @ordered
	 */
	public static final int PROTOCOL = 3;

	/**
	 * The '<em><b>Exception</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #EXCEPTION_LITERAL
	 * @model name="exception"
	 * @generated
	 * @ordered
	 */
	public static final int EXCEPTION = 4;

	/**
	 * The '<em><b>This</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Represents the value of "this" or "self"
	 * <!-- end-model-doc -->
	 * @see #THIS
	 * @generated
	 * @ordered
	 */
	public static final TRCObjectValueKind THIS_LITERAL = new TRCObjectValueKind(THIS, "this");

	/**
	 * The '<em><b>Aggregated</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Represents multiple or all parameters/return values in one object
	 * <!-- end-model-doc -->
	 * @see #AGGREGATED
	 * @generated
	 * @ordered
	 */
	public static final TRCObjectValueKind AGGREGATED_LITERAL = new TRCObjectValueKind(AGGREGATED, "aggregated");

	/**
	 * The '<em><b>Query</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Used for SQL query parameters, this will include data source + SQL statement
	 * <!-- end-model-doc -->
	 * @see #QUERY
	 * @generated
	 * @ordered
	 */
	public static final TRCObjectValueKind QUERY_LITERAL = new TRCObjectValueKind(QUERY, "query");

	/**
	 * The '<em><b>Protocol</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Represents protocol related parameters, for example for HTTP: request, response
	 * <!-- end-model-doc -->
	 * @see #PROTOCOL
	 * @generated
	 * @ordered
	 */
	public static final TRCObjectValueKind PROTOCOL_LITERAL = new TRCObjectValueKind(PROTOCOL, "protocol");

	/**
	 * The '<em><b>Exception</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * the method exited with an exception
	 * <!-- end-model-doc -->
	 * @see #EXCEPTION
	 * @generated
	 * @ordered
	 */
	public static final TRCObjectValueKind EXCEPTION_LITERAL = new TRCObjectValueKind(EXCEPTION, "exception");

	/**
	 * An array of all the '<em><b>TRC Object Value Kind</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final TRCObjectValueKind[] VALUES_ARRAY =
		new TRCObjectValueKind[] {
			THIS_LITERAL,
			AGGREGATED_LITERAL,
			QUERY_LITERAL,
			PROTOCOL_LITERAL,
			EXCEPTION_LITERAL,
		};

	/**
	 * A public read-only list of all the '<em><b>TRC Object Value Kind</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>TRC Object Value Kind</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static TRCObjectValueKind get(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			TRCObjectValueKind result = VALUES_ARRAY[i];
			if (result.toString().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>TRC Object Value Kind</b></em>' literal with the specified value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static TRCObjectValueKind get(int value) {
		switch (value) {
			case THIS: return THIS_LITERAL;
			case AGGREGATED: return AGGREGATED_LITERAL;
			case QUERY: return QUERY_LITERAL;
			case PROTOCOL: return PROTOCOL_LITERAL;
			case EXCEPTION: return EXCEPTION_LITERAL;
		}
		return null;	
	}

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private TRCObjectValueKind(int value, String name) {
		super(value, name);
	}

} //TRCObjectValueKind
