/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TRCThread.java,v 1.12 2004/12/03 17:22:57 slavescu Exp $
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.trace;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>TRC Thread</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * A monitored thread, scoped by its owning process.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCThread#getId <em>Id</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCThread#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCThread#getGroupName <em>Group Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCThread#getStartTime <em>Start Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCThread#getStopTime <em>Stop Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCThread#getMaxStackDepth <em>Max Stack Depth</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCThread#getTotalCpuTime <em>Total Cpu Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCThread#getProcess <em>Process</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCThread#getInitialInvocations <em>Initial Invocations</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCThread#getThreadObject <em>Thread Object</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCThread#getThreadEvents <em>Thread Events</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCThread()
 * @model 
 * @generated
 */
public interface TRCThread extends EObject{
	/**
	 * Returns the value of the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Id</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * A unique thread ID assigned by the agent. Even if the monitored environment can re-use thread IDs, this must be unique.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Id</em>' attribute.
	 * @see #setId(int)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCThread_Id()
	 * @model 
	 * @generated
	 */
	int getId();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCThread#getId <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Id</em>' attribute.
	 * @see #getId()
	 * @generated
	 */
	void setId(int value);

	/**
	 * Returns the value of the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Name</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The name of the thread, to the extent it is available from the monitored environment.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Name</em>' attribute.
	 * @see #setName(String)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCThread_Name()
	 * @model 
	 * @generated
	 */
	String getName();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCThread#getName <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Name</em>' attribute.
	 * @see #getName()
	 * @generated
	 */
	void setName(String value);

	/**
	 * Returns the value of the '<em><b>Group Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Group Name</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The thread's group name. This is Java specific
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Group Name</em>' attribute.
	 * @see #setGroupName(String)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCThread_GroupName()
	 * @model 
	 * @generated
	 */
	String getGroupName();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCThread#getGroupName <em>Group Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Group Name</em>' attribute.
	 * @see #getGroupName()
	 * @generated
	 */
	void setGroupName(String value);

	/**
	 * Returns the value of the '<em><b>Start Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Start Time</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The thread start time, relative to hierarchy.TRCAgent.startTime
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Start Time</em>' attribute.
	 * @see #setStartTime(double)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCThread_StartTime()
	 * @model 
	 * @generated
	 */
	double getStartTime();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCThread#getStartTime <em>Start Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Start Time</em>' attribute.
	 * @see #getStartTime()
	 * @generated
	 */
	void setStartTime(double value);

	/**
	 * Returns the value of the '<em><b>Stop Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Stop Time</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The thread stop time, relative to hierarchy.TRCAgent.startTime
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Stop Time</em>' attribute.
	 * @see #setStopTime(double)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCThread_StopTime()
	 * @model 
	 * @generated
	 */
	double getStopTime();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCThread#getStopTime <em>Stop Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Stop Time</em>' attribute.
	 * @see #getStopTime()
	 * @generated
	 */
	void setStopTime(double value);

	/**
	 * Returns the value of the '<em><b>Max Stack Depth</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Max Stack Depth</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The maximum stack depth reached in this thread during a specific monitoring session. A value of zero indicates the depth has not bee calculated, or there has been no observed activity on this thread.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Max Stack Depth</em>' attribute.
	 * @see #setMaxStackDepth(int)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCThread_MaxStackDepth()
	 * @model 
	 * @generated
	 */
	int getMaxStackDepth();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCThread#getMaxStackDepth <em>Max Stack Depth</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Max Stack Depth</em>' attribute.
	 * @see #getMaxStackDepth()
	 * @generated
	 */
	void setMaxStackDepth(int value);

	/**
	 * Returns the value of the '<em><b>Total Cpu Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Holds the thread CPU time consumed by all method invocations on this thread
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Total Cpu Time</em>' attribute.
	 * @see #setTotalCpuTime(double)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCThread_TotalCpuTime()
	 * @model 
	 * @generated
	 */
	double getTotalCpuTime();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCThread#getTotalCpuTime <em>Total Cpu Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Total Cpu Time</em>' attribute.
	 * @see #getTotalCpuTime()
	 * @generated
	 */
	void setTotalCpuTime(double value);

	/**
	 * Returns the value of the '<em><b>Process</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.trace.TRCProcess#getThreads <em>Threads</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Process</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Process</em>' container reference.
	 * @see #setProcess(TRCProcess)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCThread_Process()
	 * @see org.eclipse.hyades.models.trace.TRCProcess#getThreads
	 * @model opposite="threads" required="true"
	 * @generated
	 */
	TRCProcess getProcess();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCThread#getProcess <em>Process</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Process</em>' container reference.
	 * @see #getProcess()
	 * @generated
	 */
	void setProcess(TRCProcess value);

	/**
	 * Returns the value of the '<em><b>Thread Object</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Thread Object</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * transient
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Thread Object</em>' reference.
	 * @see #setThreadObject(TRCObject)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCThread_ThreadObject()
	 * @model 
	 * @generated
	 */
	TRCObject getThreadObject();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCThread#getThreadObject <em>Thread Object</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Thread Object</em>' reference.
	 * @see #getThreadObject()
	 * @generated
	 */
	void setThreadObject(TRCObject value);

	/**
	 * Returns the value of the '<em><b>Thread Events</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.trace.TRCThreadEvent}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.trace.TRCThreadEvent#getThread <em>Thread</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Thread Events</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Thread Events</em>' containment reference list.
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCThread_ThreadEvents()
	 * @see org.eclipse.hyades.models.trace.TRCThreadEvent#getThread
	 * @model type="org.eclipse.hyades.models.trace.TRCThreadEvent" opposite="thread" containment="true"
	 * @generated
	 */
	EList getThreadEvents();

	/**
	 * Returns the value of the '<em><b>Initial Invocations</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.trace.TRCMethodInvocation}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Initial Invocations</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * transient
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Initial Invocations</em>' reference list.
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCThread_InitialInvocations()
	 * @model type="org.eclipse.hyades.models.trace.TRCMethodInvocation"
	 * @generated
	 */
	EList getInitialInvocations();

} // TRCThread
