/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TRCFullMethodInvocationImpl.java,v 1.9 2004/12/03 17:22:57 slavescu Exp $
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.trace.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TRCTraceObject;
import org.eclipse.hyades.models.trace.TracePackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TRC Full Method Invocation</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCFullMethodInvocationImpl#getStackDepth <em>Stack Depth</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCFullMethodInvocationImpl#getEntryTime <em>Entry Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCFullMethodInvocationImpl#getExitTime <em>Exit Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCFullMethodInvocationImpl#getTicket <em>Ticket</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCFullMethodInvocationImpl#getOverhead <em>Overhead</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCFullMethodInvocationImpl#getCallerLineNo <em>Caller Line No</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCFullMethodInvocationImpl#getCpuTime <em>Cpu Time</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TRCFullMethodInvocationImpl extends TRCMethodInvocationImpl implements TRCFullMethodInvocation {
	/**
	 * The default value of the '{@link #getStackDepth() <em>Stack Depth</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStackDepth()
	 * @generated
	 * @ordered
	 */
	protected static final short STACK_DEPTH_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getStackDepth() <em>Stack Depth</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStackDepth()
	 * @generated
	 * @ordered
	 */
	protected short stackDepth = STACK_DEPTH_EDEFAULT;

	/**
	 * The default value of the '{@link #getEntryTime() <em>Entry Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEntryTime()
	 * @generated
	 * @ordered
	 */
	protected static final double ENTRY_TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getEntryTime() <em>Entry Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEntryTime()
	 * @generated
	 * @ordered
	 */
	protected double entryTime = ENTRY_TIME_EDEFAULT;

	/**
	 * The default value of the '{@link #getExitTime() <em>Exit Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getExitTime()
	 * @generated
	 * @ordered
	 */
	protected static final double EXIT_TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getExitTime() <em>Exit Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getExitTime()
	 * @generated
	 * @ordered
	 */
	protected double exitTime = EXIT_TIME_EDEFAULT;

	/**
	 * The default value of the '{@link #getTicket() <em>Ticket</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTicket()
	 * @generated
	 * @ordered
	 */
	protected static final long TICKET_EDEFAULT = 0L;

	/**
	 * The cached value of the '{@link #getTicket() <em>Ticket</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTicket()
	 * @generated
	 * @ordered
	 */
	protected long ticket = TICKET_EDEFAULT;

	/**
	 * The default value of the '{@link #getOverhead() <em>Overhead</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOverhead()
	 * @generated
	 * @ordered
	 */
	protected static final double OVERHEAD_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getOverhead() <em>Overhead</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOverhead()
	 * @generated
	 * @ordered
	 */
	protected double overhead = OVERHEAD_EDEFAULT;

	/**
	 * The default value of the '{@link #getCallerLineNo() <em>Caller Line No</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCallerLineNo()
	 * @generated
	 * @ordered
	 */
	protected static final int CALLER_LINE_NO_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getCallerLineNo() <em>Caller Line No</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCallerLineNo()
	 * @generated
	 * @ordered
	 */
	protected int callerLineNo = CALLER_LINE_NO_EDEFAULT;

	/**
	 * The default value of the '{@link #getCpuTime() <em>Cpu Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCpuTime()
	 * @generated
	 * @ordered
	 */
	protected static final double CPU_TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getCpuTime() <em>Cpu Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCpuTime()
	 * @generated
	 * @ordered
	 */
	protected double cpuTime = CPU_TIME_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TRCFullMethodInvocationImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return TracePackage.eINSTANCE.getTRCFullMethodInvocation();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public short getStackDepth() {
		return stackDepth;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setStackDepth(short newStackDepth) {
		short oldStackDepth = stackDepth;
		stackDepth = newStackDepth;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_FULL_METHOD_INVOCATION__STACK_DEPTH, oldStackDepth, stackDepth));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getEntryTime() {
		return entryTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setEntryTime(double newEntryTime) {
		double oldEntryTime = entryTime;
		entryTime = newEntryTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_FULL_METHOD_INVOCATION__ENTRY_TIME, oldEntryTime, entryTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getExitTime() {
		return exitTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setExitTime(double newExitTime) {
		double oldExitTime = exitTime;
		exitTime = newExitTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_FULL_METHOD_INVOCATION__EXIT_TIME, oldExitTime, exitTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public long getTicket() {
		return ticket;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTicket(long newTicket) {
		long oldTicket = ticket;
		ticket = newTicket;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_FULL_METHOD_INVOCATION__TICKET, oldTicket, ticket));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getOverhead() {
		return overhead;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOverhead(double newOverhead) {
		double oldOverhead = overhead;
		overhead = newOverhead;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_FULL_METHOD_INVOCATION__OVERHEAD, oldOverhead, overhead));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getCallerLineNo() {
		return callerLineNo;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCallerLineNo(int newCallerLineNo) {
		int oldCallerLineNo = callerLineNo;
		callerLineNo = newCallerLineNo;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_FULL_METHOD_INVOCATION__CALLER_LINE_NO, oldCallerLineNo, callerLineNo));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getCpuTime() {
		return cpuTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCpuTime(double newCpuTime) {
		double oldCpuTime = cpuTime;
		cpuTime = newCpuTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_FULL_METHOD_INVOCATION__CPU_TIME, oldCpuTime, cpuTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case TracePackage.TRC_FULL_METHOD_INVOCATION__METHOD:
					if (method != null)
						msgs = ((InternalEObject)method).eInverseRemove(this, TracePackage.TRC_METHOD__INVOCATIONS, TRCMethod.class, msgs);
					return basicSetMethod((TRCMethod)otherEnd, msgs);
				case TracePackage.TRC_FULL_METHOD_INVOCATION__INVOKED_BY:
					if (invokedBy != null)
						msgs = ((InternalEObject)invokedBy).eInverseRemove(this, TracePackage.TRC_METHOD_INVOCATION__INVOKES, TRCMethodInvocation.class, msgs);
					return basicSetInvokedBy((TRCMethodInvocation)otherEnd, msgs);
				case TracePackage.TRC_FULL_METHOD_INVOCATION__INVOKES:
					return ((InternalEList)getInvokes()).basicAdd(otherEnd, msgs);
				case TracePackage.TRC_FULL_METHOD_INVOCATION__PROCESS:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, TracePackage.TRC_FULL_METHOD_INVOCATION__PROCESS, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case TracePackage.TRC_FULL_METHOD_INVOCATION__METHOD:
					return basicSetMethod(null, msgs);
				case TracePackage.TRC_FULL_METHOD_INVOCATION__INVOKED_BY:
					return basicSetInvokedBy(null, msgs);
				case TracePackage.TRC_FULL_METHOD_INVOCATION__INVOKES:
					return ((InternalEList)getInvokes()).basicRemove(otherEnd, msgs);
				case TracePackage.TRC_FULL_METHOD_INVOCATION__PROCESS:
					return eBasicSetContainer(null, TracePackage.TRC_FULL_METHOD_INVOCATION__PROCESS, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case TracePackage.TRC_FULL_METHOD_INVOCATION__PROCESS:
					return ((InternalEObject)eContainer).eInverseRemove(this, TracePackage.TRC_PROCESS__INVOCATIONS, TRCProcess.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_FULL_METHOD_INVOCATION__METHOD:
				if (resolve) return getMethod();
				return basicGetMethod();
			case TracePackage.TRC_FULL_METHOD_INVOCATION__INVOKED_BY:
				if (resolve) return getInvokedBy();
				return basicGetInvokedBy();
			case TracePackage.TRC_FULL_METHOD_INVOCATION__INVOKES:
				return getInvokes();
			case TracePackage.TRC_FULL_METHOD_INVOCATION__THREAD:
				if (resolve) return getThread();
				return basicGetThread();
			case TracePackage.TRC_FULL_METHOD_INVOCATION__PROCESS:
				return getProcess();
			case TracePackage.TRC_FULL_METHOD_INVOCATION__OWNING_OBJECT:
				if (resolve) return getOwningObject();
				return basicGetOwningObject();
			case TracePackage.TRC_FULL_METHOD_INVOCATION__STACK_DEPTH:
				return new Short(getStackDepth());
			case TracePackage.TRC_FULL_METHOD_INVOCATION__ENTRY_TIME:
				return new Double(getEntryTime());
			case TracePackage.TRC_FULL_METHOD_INVOCATION__EXIT_TIME:
				return new Double(getExitTime());
			case TracePackage.TRC_FULL_METHOD_INVOCATION__TICKET:
				return new Long(getTicket());
			case TracePackage.TRC_FULL_METHOD_INVOCATION__OVERHEAD:
				return new Double(getOverhead());
			case TracePackage.TRC_FULL_METHOD_INVOCATION__CALLER_LINE_NO:
				return new Integer(getCallerLineNo());
			case TracePackage.TRC_FULL_METHOD_INVOCATION__CPU_TIME:
				return new Double(getCpuTime());
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_FULL_METHOD_INVOCATION__METHOD:
				setMethod((TRCMethod)newValue);
				return;
			case TracePackage.TRC_FULL_METHOD_INVOCATION__INVOKED_BY:
				setInvokedBy((TRCMethodInvocation)newValue);
				return;
			case TracePackage.TRC_FULL_METHOD_INVOCATION__INVOKES:
				getInvokes().clear();
				getInvokes().addAll((Collection)newValue);
				return;
			case TracePackage.TRC_FULL_METHOD_INVOCATION__THREAD:
				setThread((TRCThread)newValue);
				return;
			case TracePackage.TRC_FULL_METHOD_INVOCATION__PROCESS:
				setProcess((TRCProcess)newValue);
				return;
			case TracePackage.TRC_FULL_METHOD_INVOCATION__OWNING_OBJECT:
				setOwningObject((TRCTraceObject)newValue);
				return;
			case TracePackage.TRC_FULL_METHOD_INVOCATION__STACK_DEPTH:
				setStackDepth(((Short)newValue).shortValue());
				return;
			case TracePackage.TRC_FULL_METHOD_INVOCATION__ENTRY_TIME:
				setEntryTime(((Double)newValue).doubleValue());
				return;
			case TracePackage.TRC_FULL_METHOD_INVOCATION__EXIT_TIME:
				setExitTime(((Double)newValue).doubleValue());
				return;
			case TracePackage.TRC_FULL_METHOD_INVOCATION__TICKET:
				setTicket(((Long)newValue).longValue());
				return;
			case TracePackage.TRC_FULL_METHOD_INVOCATION__OVERHEAD:
				setOverhead(((Double)newValue).doubleValue());
				return;
			case TracePackage.TRC_FULL_METHOD_INVOCATION__CALLER_LINE_NO:
				setCallerLineNo(((Integer)newValue).intValue());
				return;
			case TracePackage.TRC_FULL_METHOD_INVOCATION__CPU_TIME:
				setCpuTime(((Double)newValue).doubleValue());
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_FULL_METHOD_INVOCATION__METHOD:
				setMethod((TRCMethod)null);
				return;
			case TracePackage.TRC_FULL_METHOD_INVOCATION__INVOKED_BY:
				setInvokedBy((TRCMethodInvocation)null);
				return;
			case TracePackage.TRC_FULL_METHOD_INVOCATION__INVOKES:
				getInvokes().clear();
				return;
			case TracePackage.TRC_FULL_METHOD_INVOCATION__THREAD:
				setThread((TRCThread)null);
				return;
			case TracePackage.TRC_FULL_METHOD_INVOCATION__PROCESS:
				setProcess((TRCProcess)null);
				return;
			case TracePackage.TRC_FULL_METHOD_INVOCATION__OWNING_OBJECT:
				setOwningObject((TRCTraceObject)null);
				return;
			case TracePackage.TRC_FULL_METHOD_INVOCATION__STACK_DEPTH:
				setStackDepth(STACK_DEPTH_EDEFAULT);
				return;
			case TracePackage.TRC_FULL_METHOD_INVOCATION__ENTRY_TIME:
				setEntryTime(ENTRY_TIME_EDEFAULT);
				return;
			case TracePackage.TRC_FULL_METHOD_INVOCATION__EXIT_TIME:
				setExitTime(EXIT_TIME_EDEFAULT);
				return;
			case TracePackage.TRC_FULL_METHOD_INVOCATION__TICKET:
				setTicket(TICKET_EDEFAULT);
				return;
			case TracePackage.TRC_FULL_METHOD_INVOCATION__OVERHEAD:
				setOverhead(OVERHEAD_EDEFAULT);
				return;
			case TracePackage.TRC_FULL_METHOD_INVOCATION__CALLER_LINE_NO:
				setCallerLineNo(CALLER_LINE_NO_EDEFAULT);
				return;
			case TracePackage.TRC_FULL_METHOD_INVOCATION__CPU_TIME:
				setCpuTime(CPU_TIME_EDEFAULT);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_FULL_METHOD_INVOCATION__METHOD:
				return method != null;
			case TracePackage.TRC_FULL_METHOD_INVOCATION__INVOKED_BY:
				return invokedBy != null;
			case TracePackage.TRC_FULL_METHOD_INVOCATION__INVOKES:
				return invokes != null && !invokes.isEmpty();
			case TracePackage.TRC_FULL_METHOD_INVOCATION__THREAD:
				return thread != null;
			case TracePackage.TRC_FULL_METHOD_INVOCATION__PROCESS:
				return getProcess() != null;
			case TracePackage.TRC_FULL_METHOD_INVOCATION__OWNING_OBJECT:
				return owningObject != null;
			case TracePackage.TRC_FULL_METHOD_INVOCATION__STACK_DEPTH:
				return stackDepth != STACK_DEPTH_EDEFAULT;
			case TracePackage.TRC_FULL_METHOD_INVOCATION__ENTRY_TIME:
				return entryTime != ENTRY_TIME_EDEFAULT;
			case TracePackage.TRC_FULL_METHOD_INVOCATION__EXIT_TIME:
				return exitTime != EXIT_TIME_EDEFAULT;
			case TracePackage.TRC_FULL_METHOD_INVOCATION__TICKET:
				return ticket != TICKET_EDEFAULT;
			case TracePackage.TRC_FULL_METHOD_INVOCATION__OVERHEAD:
				return overhead != OVERHEAD_EDEFAULT;
			case TracePackage.TRC_FULL_METHOD_INVOCATION__CALLER_LINE_NO:
				return callerLineNo != CALLER_LINE_NO_EDEFAULT;
			case TracePackage.TRC_FULL_METHOD_INVOCATION__CPU_TIME:
				return cpuTime != CPU_TIME_EDEFAULT;
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (stackDepth: ");
		result.append(stackDepth);
		result.append(", entryTime: ");
		result.append(entryTime);
		result.append(", exitTime: ");
		result.append(exitTime);
		result.append(", ticket: ");
		result.append(ticket);
		result.append(", overhead: ");
		result.append(overhead);
		result.append(", callerLineNo: ");
		result.append(callerLineNo);
		result.append(", cpuTime: ");
		result.append(cpuTime);
		result.append(')');
		return result.toString();
	}

} //TRCFullMethodInvocationImpl
