/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TRCLinePerformanceDataImpl.java,v 1.7 2004/12/03 17:22:56 slavescu Exp $
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.trace.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.hyades.models.trace.TRCLinePerformanceData;
import org.eclipse.hyades.models.trace.TRCMethodWithLLData;
import org.eclipse.hyades.models.trace.TRCSourceInfoWithLLData;
import org.eclipse.hyades.models.trace.TracePackage;

import org.eclipse.hyades.models.trace.util.LLUnitData;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TRC Line Performance Data</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCLinePerformanceDataImpl#getAccumulatedTimeTable <em>Accumulated Time Table</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TRCLinePerformanceDataImpl extends TRCLineCoverageDataImpl implements TRCLinePerformanceData {
	/**
	 * The default value of the '{@link #getAccumulatedTimeTable() <em>Accumulated Time Table</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAccumulatedTimeTable()
	 * @generated
	 * @ordered
	 */
	protected static final double[] ACCUMULATED_TIME_TABLE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getAccumulatedTimeTable() <em>Accumulated Time Table</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAccumulatedTimeTable()
	 * @generated
	 * @ordered
	 */
	protected double[] accumulatedTimeTable = ACCUMULATED_TIME_TABLE_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TRCLinePerformanceDataImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return TracePackage.eINSTANCE.getTRCLinePerformanceData();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double[] getAccumulatedTimeTable() {
		return accumulatedTimeTable;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAccumulatedTimeTable(double[] newAccumulatedTimeTable) {
		double[] oldAccumulatedTimeTable = accumulatedTimeTable;
		accumulatedTimeTable = newAccumulatedTimeTable;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_LINE_PERFORMANCE_DATA__ACCUMULATED_TIME_TABLE, oldAccumulatedTimeTable, accumulatedTimeTable));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public LLUnitData getUnitData(int unitNumber, LLUnitData instance) {
		LLUnitData ret = super.getUnitData(unitNumber, instance);
		if (ret == null) {
			return null;
		}
		ret.setAccumulatedTime(accumulatedTimeTable[unitNumber]);
		return ret;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public boolean hasCountInfo() {
		return super.hasCountInfo();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public boolean hasAccumulatedTimeInfo() {
		return accumulatedTimeTable != null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case TracePackage.TRC_LINE_PERFORMANCE_DATA__METHOD:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, TracePackage.TRC_LINE_PERFORMANCE_DATA__METHOD, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case TracePackage.TRC_LINE_PERFORMANCE_DATA__METHOD:
					return eBasicSetContainer(null, TracePackage.TRC_LINE_PERFORMANCE_DATA__METHOD, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case TracePackage.TRC_LINE_PERFORMANCE_DATA__METHOD:
					return ((InternalEObject)eContainer).eInverseRemove(this, TracePackage.TRC_METHOD_WITH_LL_DATA__LL_DATA, TRCMethodWithLLData.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_LINE_PERFORMANCE_DATA__SUMMARY_UNITS:
				return new Integer(getSummaryUnits());
			case TracePackage.TRC_LINE_PERFORMANCE_DATA__SUMMARY_NONZERO:
				return new Integer(getSummaryNonzero());
			case TracePackage.TRC_LINE_PERFORMANCE_DATA__TYPE_ID:
				return getTypeId();
			case TracePackage.TRC_LINE_PERFORMANCE_DATA__HEADINGS:
				return getHeadings();
			case TracePackage.TRC_LINE_PERFORMANCE_DATA__METHOD:
				return getMethod();
			case TracePackage.TRC_LINE_PERFORMANCE_DATA__LINE_TABLE:
				return getLineTable();
			case TracePackage.TRC_LINE_PERFORMANCE_DATA__HIT_TABLE:
				return getHitTable();
			case TracePackage.TRC_LINE_PERFORMANCE_DATA__COUNT_TABLE:
				return getCountTable();
			case TracePackage.TRC_LINE_PERFORMANCE_DATA__SOURCE_INFO:
				if (resolve) return getSourceInfo();
				return basicGetSourceInfo();
			case TracePackage.TRC_LINE_PERFORMANCE_DATA__ACCUMULATED_TIME_TABLE:
				return getAccumulatedTimeTable();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_LINE_PERFORMANCE_DATA__SUMMARY_UNITS:
				setSummaryUnits(((Integer)newValue).intValue());
				return;
			case TracePackage.TRC_LINE_PERFORMANCE_DATA__SUMMARY_NONZERO:
				setSummaryNonzero(((Integer)newValue).intValue());
				return;
			case TracePackage.TRC_LINE_PERFORMANCE_DATA__TYPE_ID:
				setTypeId((String)newValue);
				return;
			case TracePackage.TRC_LINE_PERFORMANCE_DATA__HEADINGS:
				setHeadings((String)newValue);
				return;
			case TracePackage.TRC_LINE_PERFORMANCE_DATA__METHOD:
				setMethod((TRCMethodWithLLData)newValue);
				return;
			case TracePackage.TRC_LINE_PERFORMANCE_DATA__LINE_TABLE:
				setLineTable((int[])newValue);
				return;
			case TracePackage.TRC_LINE_PERFORMANCE_DATA__HIT_TABLE:
				setHitTable((boolean[])newValue);
				return;
			case TracePackage.TRC_LINE_PERFORMANCE_DATA__COUNT_TABLE:
				setCountTable((int[])newValue);
				return;
			case TracePackage.TRC_LINE_PERFORMANCE_DATA__SOURCE_INFO:
				setSourceInfo((TRCSourceInfoWithLLData)newValue);
				return;
			case TracePackage.TRC_LINE_PERFORMANCE_DATA__ACCUMULATED_TIME_TABLE:
				setAccumulatedTimeTable((double[])newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_LINE_PERFORMANCE_DATA__SUMMARY_UNITS:
				setSummaryUnits(SUMMARY_UNITS_EDEFAULT);
				return;
			case TracePackage.TRC_LINE_PERFORMANCE_DATA__SUMMARY_NONZERO:
				setSummaryNonzero(SUMMARY_NONZERO_EDEFAULT);
				return;
			case TracePackage.TRC_LINE_PERFORMANCE_DATA__TYPE_ID:
				setTypeId(TYPE_ID_EDEFAULT);
				return;
			case TracePackage.TRC_LINE_PERFORMANCE_DATA__HEADINGS:
				setHeadings(HEADINGS_EDEFAULT);
				return;
			case TracePackage.TRC_LINE_PERFORMANCE_DATA__METHOD:
				setMethod((TRCMethodWithLLData)null);
				return;
			case TracePackage.TRC_LINE_PERFORMANCE_DATA__LINE_TABLE:
				setLineTable(LINE_TABLE_EDEFAULT);
				return;
			case TracePackage.TRC_LINE_PERFORMANCE_DATA__HIT_TABLE:
				setHitTable(HIT_TABLE_EDEFAULT);
				return;
			case TracePackage.TRC_LINE_PERFORMANCE_DATA__COUNT_TABLE:
				setCountTable(COUNT_TABLE_EDEFAULT);
				return;
			case TracePackage.TRC_LINE_PERFORMANCE_DATA__SOURCE_INFO:
				setSourceInfo((TRCSourceInfoWithLLData)null);
				return;
			case TracePackage.TRC_LINE_PERFORMANCE_DATA__ACCUMULATED_TIME_TABLE:
				setAccumulatedTimeTable(ACCUMULATED_TIME_TABLE_EDEFAULT);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_LINE_PERFORMANCE_DATA__SUMMARY_UNITS:
				return summaryUnits != SUMMARY_UNITS_EDEFAULT;
			case TracePackage.TRC_LINE_PERFORMANCE_DATA__SUMMARY_NONZERO:
				return summaryNonzero != SUMMARY_NONZERO_EDEFAULT;
			case TracePackage.TRC_LINE_PERFORMANCE_DATA__TYPE_ID:
				return TYPE_ID_EDEFAULT == null ? typeId != null : !TYPE_ID_EDEFAULT.equals(typeId);
			case TracePackage.TRC_LINE_PERFORMANCE_DATA__HEADINGS:
				return HEADINGS_EDEFAULT == null ? headings != null : !HEADINGS_EDEFAULT.equals(headings);
			case TracePackage.TRC_LINE_PERFORMANCE_DATA__METHOD:
				return getMethod() != null;
			case TracePackage.TRC_LINE_PERFORMANCE_DATA__LINE_TABLE:
				return LINE_TABLE_EDEFAULT == null ? lineTable != null : !LINE_TABLE_EDEFAULT.equals(lineTable);
			case TracePackage.TRC_LINE_PERFORMANCE_DATA__HIT_TABLE:
				return HIT_TABLE_EDEFAULT == null ? hitTable != null : !HIT_TABLE_EDEFAULT.equals(hitTable);
			case TracePackage.TRC_LINE_PERFORMANCE_DATA__COUNT_TABLE:
				return COUNT_TABLE_EDEFAULT == null ? countTable != null : !COUNT_TABLE_EDEFAULT.equals(countTable);
			case TracePackage.TRC_LINE_PERFORMANCE_DATA__SOURCE_INFO:
				return sourceInfo != null;
			case TracePackage.TRC_LINE_PERFORMANCE_DATA__ACCUMULATED_TIME_TABLE:
				return ACCUMULATED_TIME_TABLE_EDEFAULT == null ? accumulatedTimeTable != null : !ACCUMULATED_TIME_TABLE_EDEFAULT.equals(accumulatedTimeTable);
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (accumulatedTimeTable: ");
		result.append(accumulatedTimeTable);
		result.append(')');
		return result.toString();
	}

} //TRCLinePerformanceDataImpl
