/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TRCMethodInvocationImpl.java,v 1.12 2004/12/03 17:22:57 slavescu Exp $
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.trace.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TRCTraceObject;
import org.eclipse.hyades.models.trace.TracePackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TRC Method Invocation</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCMethodInvocationImpl#getMethod <em>Method</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCMethodInvocationImpl#getInvokedBy <em>Invoked By</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCMethodInvocationImpl#getInvokes <em>Invokes</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCMethodInvocationImpl#getThread <em>Thread</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCMethodInvocationImpl#getProcess <em>Process</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCMethodInvocationImpl#getOwningObject <em>Owning Object</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TRCMethodInvocationImpl extends EObjectImpl implements TRCMethodInvocation {
	/**
	 * The cached value of the '{@link #getMethod() <em>Method</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMethod()
	 * @generated
	 * @ordered
	 */
	protected TRCMethod method = null;

	/**
	 * The cached value of the '{@link #getInvokedBy() <em>Invoked By</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInvokedBy()
	 * @generated
	 * @ordered
	 */
	protected TRCMethodInvocation invokedBy = null;

	/**
	 * The cached value of the '{@link #getInvokes() <em>Invokes</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInvokes()
	 * @generated
	 * @ordered
	 */
	protected EList invokes = null;

	/**
	 * The cached value of the '{@link #getThread() <em>Thread</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getThread()
	 * @generated
	 * @ordered
	 */
	protected TRCThread thread = null;

	/**
	 * The cached value of the '{@link #getOwningObject() <em>Owning Object</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOwningObject()
	 * @generated
	 * @ordered
	 */
	protected TRCTraceObject owningObject = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TRCMethodInvocationImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return TracePackage.eINSTANCE.getTRCMethodInvocation();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCTraceObject getOwningObject() {
		if (owningObject != null && owningObject.eIsProxy()) {
			TRCTraceObject oldOwningObject = owningObject;
			owningObject = (TRCTraceObject)eResolveProxy((InternalEObject)owningObject);
			if (owningObject != oldOwningObject) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TracePackage.TRC_METHOD_INVOCATION__OWNING_OBJECT, oldOwningObject, owningObject));
			}
		}
		return owningObject;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCTraceObject basicGetOwningObject() {
		return owningObject;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOwningObject(TRCTraceObject newOwningObject) {
		TRCTraceObject oldOwningObject = owningObject;
		owningObject = newOwningObject;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_METHOD_INVOCATION__OWNING_OBJECT, oldOwningObject, owningObject));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCMethod getMethod() {
		if (method != null && method.eIsProxy()) {
			TRCMethod oldMethod = method;
			method = (TRCMethod)eResolveProxy((InternalEObject)method);
			if (method != oldMethod) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TracePackage.TRC_METHOD_INVOCATION__METHOD, oldMethod, method));
			}
		}
		return method;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCMethod basicGetMethod() {
		return method;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetMethod(TRCMethod newMethod, NotificationChain msgs) {
		TRCMethod oldMethod = method;
		method = newMethod;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, TracePackage.TRC_METHOD_INVOCATION__METHOD, oldMethod, newMethod);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setMethod(TRCMethod newMethod) {
		if (newMethod != method) {
			NotificationChain msgs = null;
			if (method != null)
				msgs = ((InternalEObject)method).eInverseRemove(this, TracePackage.TRC_METHOD__INVOCATIONS, TRCMethod.class, msgs);
			if (newMethod != null)
				msgs = ((InternalEObject)newMethod).eInverseAdd(this, TracePackage.TRC_METHOD__INVOCATIONS, TRCMethod.class, msgs);
			msgs = basicSetMethod(newMethod, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_METHOD_INVOCATION__METHOD, newMethod, newMethod));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCMethodInvocation getInvokedBy() {
		if (invokedBy != null && invokedBy.eIsProxy()) {
			TRCMethodInvocation oldInvokedBy = invokedBy;
			invokedBy = (TRCMethodInvocation)eResolveProxy((InternalEObject)invokedBy);
			if (invokedBy != oldInvokedBy) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TracePackage.TRC_METHOD_INVOCATION__INVOKED_BY, oldInvokedBy, invokedBy));
			}
		}
		return invokedBy;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCMethodInvocation basicGetInvokedBy() {
		return invokedBy;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetInvokedBy(TRCMethodInvocation newInvokedBy, NotificationChain msgs) {
		TRCMethodInvocation oldInvokedBy = invokedBy;
		invokedBy = newInvokedBy;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, TracePackage.TRC_METHOD_INVOCATION__INVOKED_BY, oldInvokedBy, newInvokedBy);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInvokedBy(TRCMethodInvocation newInvokedBy) {
		if (newInvokedBy != invokedBy) {
			NotificationChain msgs = null;
			if (invokedBy != null)
				msgs = ((InternalEObject)invokedBy).eInverseRemove(this, TracePackage.TRC_METHOD_INVOCATION__INVOKES, TRCMethodInvocation.class, msgs);
			if (newInvokedBy != null)
				msgs = ((InternalEObject)newInvokedBy).eInverseAdd(this, TracePackage.TRC_METHOD_INVOCATION__INVOKES, TRCMethodInvocation.class, msgs);
			msgs = basicSetInvokedBy(newInvokedBy, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_METHOD_INVOCATION__INVOKED_BY, newInvokedBy, newInvokedBy));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getInvokes() {
		if (invokes == null) {
			invokes = new EObjectWithInverseResolvingEList(TRCMethodInvocation.class, this, TracePackage.TRC_METHOD_INVOCATION__INVOKES, TracePackage.TRC_METHOD_INVOCATION__INVOKED_BY);
		}
		return invokes;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCThread getThread() {
		if (thread != null && thread.eIsProxy()) {
			TRCThread oldThread = thread;
			thread = (TRCThread)eResolveProxy((InternalEObject)thread);
			if (thread != oldThread) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TracePackage.TRC_METHOD_INVOCATION__THREAD, oldThread, thread));
			}
		}
		return thread;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCThread basicGetThread() {
		return thread;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setThread(TRCThread newThread) {
		TRCThread oldThread = thread;
		thread = newThread;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_METHOD_INVOCATION__THREAD, oldThread, thread));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCProcess getProcess() {
		if (eContainerFeatureID != TracePackage.TRC_METHOD_INVOCATION__PROCESS) return null;
		return (TRCProcess)eContainer;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setProcess(TRCProcess newProcess) {
		if (newProcess != eContainer || (eContainerFeatureID != TracePackage.TRC_METHOD_INVOCATION__PROCESS && newProcess != null)) {
			if (EcoreUtil.isAncestor(this, newProcess))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eContainer != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newProcess != null)
				msgs = ((InternalEObject)newProcess).eInverseAdd(this, TracePackage.TRC_PROCESS__INVOCATIONS, TRCProcess.class, msgs);
			msgs = eBasicSetContainer((InternalEObject)newProcess, TracePackage.TRC_METHOD_INVOCATION__PROCESS, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_METHOD_INVOCATION__PROCESS, newProcess, newProcess));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case TracePackage.TRC_METHOD_INVOCATION__METHOD:
					if (method != null)
						msgs = ((InternalEObject)method).eInverseRemove(this, TracePackage.TRC_METHOD__INVOCATIONS, TRCMethod.class, msgs);
					return basicSetMethod((TRCMethod)otherEnd, msgs);
				case TracePackage.TRC_METHOD_INVOCATION__INVOKED_BY:
					if (invokedBy != null)
						msgs = ((InternalEObject)invokedBy).eInverseRemove(this, TracePackage.TRC_METHOD_INVOCATION__INVOKES, TRCMethodInvocation.class, msgs);
					return basicSetInvokedBy((TRCMethodInvocation)otherEnd, msgs);
				case TracePackage.TRC_METHOD_INVOCATION__INVOKES:
					return ((InternalEList)getInvokes()).basicAdd(otherEnd, msgs);
				case TracePackage.TRC_METHOD_INVOCATION__PROCESS:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, TracePackage.TRC_METHOD_INVOCATION__PROCESS, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case TracePackage.TRC_METHOD_INVOCATION__METHOD:
					return basicSetMethod(null, msgs);
				case TracePackage.TRC_METHOD_INVOCATION__INVOKED_BY:
					return basicSetInvokedBy(null, msgs);
				case TracePackage.TRC_METHOD_INVOCATION__INVOKES:
					return ((InternalEList)getInvokes()).basicRemove(otherEnd, msgs);
				case TracePackage.TRC_METHOD_INVOCATION__PROCESS:
					return eBasicSetContainer(null, TracePackage.TRC_METHOD_INVOCATION__PROCESS, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case TracePackage.TRC_METHOD_INVOCATION__PROCESS:
					return ((InternalEObject)eContainer).eInverseRemove(this, TracePackage.TRC_PROCESS__INVOCATIONS, TRCProcess.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_METHOD_INVOCATION__METHOD:
				if (resolve) return getMethod();
				return basicGetMethod();
			case TracePackage.TRC_METHOD_INVOCATION__INVOKED_BY:
				if (resolve) return getInvokedBy();
				return basicGetInvokedBy();
			case TracePackage.TRC_METHOD_INVOCATION__INVOKES:
				return getInvokes();
			case TracePackage.TRC_METHOD_INVOCATION__THREAD:
				if (resolve) return getThread();
				return basicGetThread();
			case TracePackage.TRC_METHOD_INVOCATION__PROCESS:
				return getProcess();
			case TracePackage.TRC_METHOD_INVOCATION__OWNING_OBJECT:
				if (resolve) return getOwningObject();
				return basicGetOwningObject();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_METHOD_INVOCATION__METHOD:
				setMethod((TRCMethod)newValue);
				return;
			case TracePackage.TRC_METHOD_INVOCATION__INVOKED_BY:
				setInvokedBy((TRCMethodInvocation)newValue);
				return;
			case TracePackage.TRC_METHOD_INVOCATION__INVOKES:
				getInvokes().clear();
				getInvokes().addAll((Collection)newValue);
				return;
			case TracePackage.TRC_METHOD_INVOCATION__THREAD:
				setThread((TRCThread)newValue);
				return;
			case TracePackage.TRC_METHOD_INVOCATION__PROCESS:
				setProcess((TRCProcess)newValue);
				return;
			case TracePackage.TRC_METHOD_INVOCATION__OWNING_OBJECT:
				setOwningObject((TRCTraceObject)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_METHOD_INVOCATION__METHOD:
				setMethod((TRCMethod)null);
				return;
			case TracePackage.TRC_METHOD_INVOCATION__INVOKED_BY:
				setInvokedBy((TRCMethodInvocation)null);
				return;
			case TracePackage.TRC_METHOD_INVOCATION__INVOKES:
				getInvokes().clear();
				return;
			case TracePackage.TRC_METHOD_INVOCATION__THREAD:
				setThread((TRCThread)null);
				return;
			case TracePackage.TRC_METHOD_INVOCATION__PROCESS:
				setProcess((TRCProcess)null);
				return;
			case TracePackage.TRC_METHOD_INVOCATION__OWNING_OBJECT:
				setOwningObject((TRCTraceObject)null);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_METHOD_INVOCATION__METHOD:
				return method != null;
			case TracePackage.TRC_METHOD_INVOCATION__INVOKED_BY:
				return invokedBy != null;
			case TracePackage.TRC_METHOD_INVOCATION__INVOKES:
				return invokes != null && !invokes.isEmpty();
			case TracePackage.TRC_METHOD_INVOCATION__THREAD:
				return thread != null;
			case TracePackage.TRC_METHOD_INVOCATION__PROCESS:
				return getProcess() != null;
			case TracePackage.TRC_METHOD_INVOCATION__OWNING_OBJECT:
				return owningObject != null;
		}
		return eDynamicIsSet(eFeature);
	}

} //TRCMethodInvocationImpl
