/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TRCPackageImpl.java,v 1.13 2004/12/03 17:22:57 slavescu Exp $
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.trace.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.loaders.trace.IDelta;
import org.eclipse.hyades.loaders.trace.ISnapshot;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TracePackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TRC Package</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCPackageImpl#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCPackageImpl#getBaseTime <em>Base Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCPackageImpl#getCumulativeTime <em>Cumulative Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCPackageImpl#getCalls <em>Calls</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCPackageImpl#getInheritedCalls <em>Inherited Calls</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCPackageImpl#getInheritedBaseTime <em>Inherited Base Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCPackageImpl#getInheritedCumulativeTime <em>Inherited Cumulative Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCPackageImpl#getTotalSize <em>Total Size</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCPackageImpl#getTotalInstances <em>Total Instances</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCPackageImpl#getCollectedSize <em>Collected Size</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCPackageImpl#getCollectedInstances <em>Collected Instances</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCPackageImpl#getTotalCpuTime <em>Total Cpu Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCPackageImpl#getProcess <em>Process</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCPackageImpl#getClasses <em>Classes</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCPackageImpl#getSubPackages <em>Sub Packages</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCPackageImpl#getParent <em>Parent</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TRCPackageImpl extends EObjectImpl implements TRCPackage {
	private TRCPackageSnapshot _currentSnapshot;
	private TRCPackageSnapshot _previousSnapshot;
	/**
	 *
	 */
	public int computeDelta(IDelta delta) {
		TRCPackageSnapshot delta1 = (TRCPackageSnapshot) delta;
	
		if ((_currentSnapshot == null) || (_previousSnapshot == null)) {
			delta1.baseTime = 0;
			delta1.calls = 0;
			delta1.collectedInstances = 0;
			delta1.collectedSize = 0;
			delta1.cumulativeTime = 0;
			delta1.inheritedBaseTime = 0;
			delta1.inheritedCalls = 0;
			delta1.inheritedCumulativeTime = 0;
			delta1.totalInstances = 0;
			delta1.totalSize = 0;
	
			return -1;
		}
	
		delta1.baseTime = _currentSnapshot.baseTime - _previousSnapshot.baseTime;
		delta1.calls = _currentSnapshot.calls - _previousSnapshot.calls;
		delta1.collectedInstances =
			_currentSnapshot.collectedInstances
				- _previousSnapshot.collectedInstances;
		delta1.collectedSize =
			_currentSnapshot.collectedSize - _previousSnapshot.collectedSize;
		delta1.cumulativeTime =
			_currentSnapshot.cumulativeTime - _previousSnapshot.cumulativeTime;
		delta1.inheritedBaseTime =
			_currentSnapshot.inheritedBaseTime
				- _previousSnapshot.inheritedBaseTime;
		delta1.inheritedCalls =
			_currentSnapshot.inheritedCalls - _previousSnapshot.inheritedCalls;
		delta1.inheritedCumulativeTime =
			_currentSnapshot.inheritedCumulativeTime
				- _previousSnapshot.inheritedCumulativeTime;
		delta1.totalInstances =
			_currentSnapshot.totalInstances - _previousSnapshot.totalInstances;
		delta1.totalSize =
			_currentSnapshot.totalSize - _previousSnapshot.totalSize;
	
		return 1;
	}
	public int computeDelta(IDelta delta, int featureID) {
		TRCPackageSnapshot delta1 = (TRCPackageSnapshot) delta;
	
		if ((_currentSnapshot == null) || (_previousSnapshot == null)) {
			switch (featureID) {
				case TracePackage.TRC_PACKAGE__BASE_TIME :
					delta1.baseTime = 0;
	
					break;
	
				case TracePackage.TRC_PACKAGE__CUMULATIVE_TIME :
					delta1.cumulativeTime = 0;
	
					break;
	
				case TracePackage.TRC_PACKAGE__CALLS :
					delta1.calls = 0;
	
					break;
	
				case TracePackage.TRC_PACKAGE__INHERITED_CALLS :
					delta1.inheritedCalls = 0;
	
					break;
	
				case TracePackage.TRC_PACKAGE__INHERITED_BASE_TIME :
					delta1.inheritedBaseTime = 0;
	
					break;
	
				case TracePackage.TRC_PACKAGE__INHERITED_CUMULATIVE_TIME :
					delta1.inheritedCumulativeTime = 0;
	
					break;
	
				case TracePackage.TRC_PACKAGE__TOTAL_SIZE :
					delta1.totalSize = 0;
	
					break;
	
				case TracePackage.TRC_PACKAGE__TOTAL_INSTANCES :
					delta1.totalInstances = 0;
	
					break;
	
				case TracePackage.TRC_PACKAGE__COLLECTED_SIZE :
					delta1.collectedSize = 0;
	
					break;
	
				case TracePackage.TRC_PACKAGE__COLLECTED_INSTANCES :
					delta1.collectedInstances = 0;
	
					break;
			}
	
			return -1;
		}
	
		switch (featureID) {
			case TracePackage.TRC_PACKAGE__BASE_TIME :
				delta1.baseTime =
					_currentSnapshot.baseTime - _previousSnapshot.baseTime;
	
				break;
	
			case TracePackage.TRC_PACKAGE__CUMULATIVE_TIME :
				delta1.cumulativeTime =
					_currentSnapshot.cumulativeTime
						- _previousSnapshot.cumulativeTime;
	
				break;
	
			case TracePackage.TRC_PACKAGE__CALLS :
				delta1.calls = _currentSnapshot.calls - _previousSnapshot.calls;
	
				break;
	
			case TracePackage.TRC_PACKAGE__INHERITED_CALLS :
				delta1.inheritedCalls =
					_currentSnapshot.inheritedCalls
						- _previousSnapshot.inheritedCalls;
	
				break;
	
			case TracePackage.TRC_PACKAGE__INHERITED_BASE_TIME :
				delta1.inheritedBaseTime =
					_currentSnapshot.inheritedBaseTime
						- _previousSnapshot.inheritedBaseTime;
	
				break;
	
			case TracePackage.TRC_PACKAGE__INHERITED_CUMULATIVE_TIME :
				delta1.inheritedCumulativeTime =
					_currentSnapshot.inheritedCumulativeTime
						- _previousSnapshot.inheritedCumulativeTime;
	
				break;
	
			case TracePackage.TRC_PACKAGE__TOTAL_SIZE :
				delta1.totalSize =
					_currentSnapshot.totalSize - _previousSnapshot.totalSize;
	
				break;
	
			case TracePackage.TRC_PACKAGE__TOTAL_INSTANCES :
				delta1.totalInstances =
					_currentSnapshot.totalInstances
						- _previousSnapshot.totalInstances;
	
				break;
	
			case TracePackage.TRC_PACKAGE__COLLECTED_SIZE :
				delta1.collectedSize =
					_currentSnapshot.collectedSize
						- _previousSnapshot.collectedSize;
	
				break;
	
			case TracePackage.TRC_PACKAGE__COLLECTED_INSTANCES :
				delta1.collectedInstances =
					_currentSnapshot.collectedInstances
						- _previousSnapshot.collectedInstances;
	
				break;
		}
	
		return 1;
	}
	/**
	 *
	 */
	public void removeSnapshot() {
		_currentSnapshot = null;
		_previousSnapshot = null;
	}
	/**
	 *
	 */
	public ISnapshot retrieveSnapshot() {
		if(_currentSnapshot==null)
		{
			takeSnapshot();
		}
		return _currentSnapshot;
	}
	/**
	 *
	 */
	public void takeSnapshot() {
		TRCPackageSnapshot temp = _previousSnapshot;
	
		_previousSnapshot = _currentSnapshot;
		_currentSnapshot = temp;
	
		if (_currentSnapshot == null) {
			_currentSnapshot = new TRCPackageSnapshot();
		}
	
		_currentSnapshot.baseTime = baseTime;
		_currentSnapshot.calls = calls;
		_currentSnapshot.collectedInstances = collectedInstances;
		_currentSnapshot.collectedSize = collectedSize;
		_currentSnapshot.cumulativeTime = cumulativeTime;
		_currentSnapshot.inheritedBaseTime = inheritedBaseTime;
		_currentSnapshot.inheritedCalls = inheritedCalls;
		_currentSnapshot.inheritedCumulativeTime = inheritedCumulativeTime;
		_currentSnapshot.totalInstances = totalInstances;
		_currentSnapshot.totalSize = totalSize;
		_currentSnapshot.totalCpuTime = totalCpuTime;
	}

	/**
	 * @author slavescu
	 */
	public static class TRCPackageSnapshot implements IDelta,ISnapshot {
		protected double baseTime = BASE_TIME_EDEFAULT;
		protected int calls = CALLS_EDEFAULT;
		protected int collectedInstances = COLLECTED_INSTANCES_EDEFAULT;
		protected int collectedSize = COLLECTED_SIZE_EDEFAULT;
		protected double cumulativeTime = CUMULATIVE_TIME_EDEFAULT;
		protected double inheritedBaseTime = INHERITED_BASE_TIME_EDEFAULT;
		protected int inheritedCalls = INHERITED_CALLS_EDEFAULT;
		protected double inheritedCumulativeTime = INHERITED_CUMULATIVE_TIME_EDEFAULT;
		protected int totalInstances = TOTAL_INSTANCES_EDEFAULT;
		protected int totalSize = TOTAL_SIZE_EDEFAULT;
		protected double totalCpuTime = TOTAL_CPU_TIME_EDEFAULT;


		public Object get(int featureID) {
			switch (featureID) {
				case TracePackage.TRC_PACKAGE__BASE_TIME:
					return new Double(getBaseTime());
				case TracePackage.TRC_PACKAGE__CUMULATIVE_TIME:
					return new Double(getCumulativeTime());
				case TracePackage.TRC_PACKAGE__CALLS:
					return new Integer(getCalls());
				case TracePackage.TRC_PACKAGE__INHERITED_CALLS:
					return new Integer(getInheritedCalls());
				case TracePackage.TRC_PACKAGE__INHERITED_BASE_TIME:
					return new Double(getInheritedBaseTime());
				case TracePackage.TRC_PACKAGE__INHERITED_CUMULATIVE_TIME:
					return new Double(getInheritedCumulativeTime());
				case TracePackage.TRC_PACKAGE__TOTAL_SIZE:
					return new Integer(getTotalSize());
				case TracePackage.TRC_PACKAGE__TOTAL_INSTANCES:
					return new Integer(getTotalInstances());
				case TracePackage.TRC_PACKAGE__COLLECTED_SIZE:
					return new Integer(getCollectedSize());
				case TracePackage.TRC_PACKAGE__COLLECTED_INSTANCES:
					return new Integer(getCollectedInstances());
			}
			return null;
		}

		public double getBaseTime() {
			return baseTime;
		}

		public int getCalls() {
			return calls;
		}

		public int getCollectedInstances() {
			return collectedInstances;
		}

		public int getCollectedSize() {
			return collectedSize;
		}

		public double getCumulativeTime() {
			return cumulativeTime;
		}

		public double getInheritedBaseTime() {
			return inheritedBaseTime;
		}

		public int getInheritedCalls() {
			return inheritedCalls;
		}

		public int getTotalInstances() {
			return totalInstances;
		}

		public int getTotalSize() {
			return totalSize;
		}

		public double getInheritedCumulativeTime() {
			return inheritedCumulativeTime;
		}

		/**
		 * @return Returns the totalCpuTime.
		 */
		public double getTotalCpuTime() {
			return totalCpuTime;
		}
	}
	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = "Default";

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getBaseTime() <em>Base Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getBaseTime()
	 * @generated
	 * @ordered
	 */
	protected static final double BASE_TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getBaseTime() <em>Base Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getBaseTime()
	 * @generated
	 * @ordered
	 */
	protected double baseTime = BASE_TIME_EDEFAULT;

	/**
	 * The default value of the '{@link #getCumulativeTime() <em>Cumulative Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCumulativeTime()
	 * @generated
	 * @ordered
	 */
	protected static final double CUMULATIVE_TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getCumulativeTime() <em>Cumulative Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCumulativeTime()
	 * @generated
	 * @ordered
	 */
	protected double cumulativeTime = CUMULATIVE_TIME_EDEFAULT;

	/**
	 * The default value of the '{@link #getCalls() <em>Calls</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCalls()
	 * @generated
	 * @ordered
	 */
	protected static final int CALLS_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getCalls() <em>Calls</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCalls()
	 * @generated
	 * @ordered
	 */
	protected int calls = CALLS_EDEFAULT;

	/**
	 * The default value of the '{@link #getInheritedCalls() <em>Inherited Calls</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInheritedCalls()
	 * @generated
	 * @ordered
	 */
	protected static final int INHERITED_CALLS_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getInheritedCalls() <em>Inherited Calls</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInheritedCalls()
	 * @generated
	 * @ordered
	 */
	protected int inheritedCalls = INHERITED_CALLS_EDEFAULT;

	/**
	 * The default value of the '{@link #getInheritedBaseTime() <em>Inherited Base Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInheritedBaseTime()
	 * @generated
	 * @ordered
	 */
	protected static final double INHERITED_BASE_TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getInheritedBaseTime() <em>Inherited Base Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInheritedBaseTime()
	 * @generated
	 * @ordered
	 */
	protected double inheritedBaseTime = INHERITED_BASE_TIME_EDEFAULT;

	/**
	 * The default value of the '{@link #getInheritedCumulativeTime() <em>Inherited Cumulative Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInheritedCumulativeTime()
	 * @generated
	 * @ordered
	 */
	protected static final double INHERITED_CUMULATIVE_TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getInheritedCumulativeTime() <em>Inherited Cumulative Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInheritedCumulativeTime()
	 * @generated
	 * @ordered
	 */
	protected double inheritedCumulativeTime = INHERITED_CUMULATIVE_TIME_EDEFAULT;

	/**
	 * The default value of the '{@link #getTotalSize() <em>Total Size</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTotalSize()
	 * @generated
	 * @ordered
	 */
	protected static final int TOTAL_SIZE_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getTotalSize() <em>Total Size</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTotalSize()
	 * @generated
	 * @ordered
	 */
	protected int totalSize = TOTAL_SIZE_EDEFAULT;

	/**
	 * The default value of the '{@link #getTotalInstances() <em>Total Instances</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTotalInstances()
	 * @generated
	 * @ordered
	 */
	protected static final int TOTAL_INSTANCES_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getTotalInstances() <em>Total Instances</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTotalInstances()
	 * @generated
	 * @ordered
	 */
	protected int totalInstances = TOTAL_INSTANCES_EDEFAULT;

	/**
	 * The default value of the '{@link #getCollectedSize() <em>Collected Size</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCollectedSize()
	 * @generated
	 * @ordered
	 */
	protected static final int COLLECTED_SIZE_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getCollectedSize() <em>Collected Size</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCollectedSize()
	 * @generated
	 * @ordered
	 */
	protected int collectedSize = COLLECTED_SIZE_EDEFAULT;

	/**
	 * The default value of the '{@link #getCollectedInstances() <em>Collected Instances</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCollectedInstances()
	 * @generated
	 * @ordered
	 */
	protected static final int COLLECTED_INSTANCES_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getCollectedInstances() <em>Collected Instances</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCollectedInstances()
	 * @generated
	 * @ordered
	 */
	protected int collectedInstances = COLLECTED_INSTANCES_EDEFAULT;

	/**
	 * The default value of the '{@link #getTotalCpuTime() <em>Total Cpu Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTotalCpuTime()
	 * @generated
	 * @ordered
	 */
	protected static final double TOTAL_CPU_TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getTotalCpuTime() <em>Total Cpu Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTotalCpuTime()
	 * @generated
	 * @ordered
	 */
	protected double totalCpuTime = TOTAL_CPU_TIME_EDEFAULT;

	/**
	 * The cached value of the '{@link #getClasses() <em>Classes</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getClasses()
	 * @generated
	 * @ordered
	 */
	protected EList classes = null;

	/**
	 * The cached value of the '{@link #getSubPackages() <em>Sub Packages</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSubPackages()
	 * @generated
	 * @ordered
	 */
	protected EList subPackages = null;

	/**
	 * The cached value of the '{@link #getParent() <em>Parent</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getParent()
	 * @generated
	 * @ordered
	 */
	protected TRCPackage parent = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TRCPackageImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return TracePackage.eINSTANCE.getTRCPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setName(String newName) {
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_PACKAGE__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getBaseTime() {
		return baseTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setBaseTime(double newBaseTime) {
		double oldBaseTime = baseTime;
		baseTime = newBaseTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_PACKAGE__BASE_TIME, oldBaseTime, baseTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getCumulativeTime() {
		return cumulativeTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCumulativeTime(double newCumulativeTime) {
		double oldCumulativeTime = cumulativeTime;
		cumulativeTime = newCumulativeTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_PACKAGE__CUMULATIVE_TIME, oldCumulativeTime, cumulativeTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getCalls() {
		return calls;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCalls(int newCalls) {
		int oldCalls = calls;
		calls = newCalls;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_PACKAGE__CALLS, oldCalls, calls));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getInheritedCalls() {
		return inheritedCalls;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInheritedCalls(int newInheritedCalls) {
		int oldInheritedCalls = inheritedCalls;
		inheritedCalls = newInheritedCalls;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_PACKAGE__INHERITED_CALLS, oldInheritedCalls, inheritedCalls));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getInheritedBaseTime() {
		return inheritedBaseTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInheritedBaseTime(double newInheritedBaseTime) {
		double oldInheritedBaseTime = inheritedBaseTime;
		inheritedBaseTime = newInheritedBaseTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_PACKAGE__INHERITED_BASE_TIME, oldInheritedBaseTime, inheritedBaseTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getInheritedCumulativeTime() {
		return inheritedCumulativeTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInheritedCumulativeTime(double newInheritedCumulativeTime) {
		double oldInheritedCumulativeTime = inheritedCumulativeTime;
		inheritedCumulativeTime = newInheritedCumulativeTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_PACKAGE__INHERITED_CUMULATIVE_TIME, oldInheritedCumulativeTime, inheritedCumulativeTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getTotalSize() {
		return totalSize;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTotalSize(int newTotalSize) {
		int oldTotalSize = totalSize;
		totalSize = newTotalSize;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_PACKAGE__TOTAL_SIZE, oldTotalSize, totalSize));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getTotalInstances() {
		return totalInstances;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTotalInstances(int newTotalInstances) {
		int oldTotalInstances = totalInstances;
		totalInstances = newTotalInstances;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_PACKAGE__TOTAL_INSTANCES, oldTotalInstances, totalInstances));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getCollectedSize() {
		return collectedSize;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCollectedSize(int newCollectedSize) {
		int oldCollectedSize = collectedSize;
		collectedSize = newCollectedSize;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_PACKAGE__COLLECTED_SIZE, oldCollectedSize, collectedSize));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getCollectedInstances() {
		return collectedInstances;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCollectedInstances(int newCollectedInstances) {
		int oldCollectedInstances = collectedInstances;
		collectedInstances = newCollectedInstances;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_PACKAGE__COLLECTED_INSTANCES, oldCollectedInstances, collectedInstances));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getTotalCpuTime() {
		return totalCpuTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTotalCpuTime(double newTotalCpuTime) {
		double oldTotalCpuTime = totalCpuTime;
		totalCpuTime = newTotalCpuTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_PACKAGE__TOTAL_CPU_TIME, oldTotalCpuTime, totalCpuTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCProcess getProcess() {
		if (eContainerFeatureID != TracePackage.TRC_PACKAGE__PROCESS) return null;
		return (TRCProcess)eContainer;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setProcess(TRCProcess newProcess) {
		if (newProcess != eContainer || (eContainerFeatureID != TracePackage.TRC_PACKAGE__PROCESS && newProcess != null)) {
			if (EcoreUtil.isAncestor(this, newProcess))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eContainer != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newProcess != null)
				msgs = ((InternalEObject)newProcess).eInverseAdd(this, TracePackage.TRC_PROCESS__PACKAGES, TRCProcess.class, msgs);
			msgs = eBasicSetContainer((InternalEObject)newProcess, TracePackage.TRC_PACKAGE__PROCESS, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_PACKAGE__PROCESS, newProcess, newProcess));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getClasses() {
		if (classes == null) {
			classes = new EObjectContainmentWithInverseEList(TRCClass.class, this, TracePackage.TRC_PACKAGE__CLASSES, TracePackage.TRC_CLASS__PACKAGE);
		}
		return classes;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getSubPackages() {
		if (subPackages == null) {
			subPackages = new EObjectWithInverseResolvingEList(TRCPackage.class, this, TracePackage.TRC_PACKAGE__SUB_PACKAGES, TracePackage.TRC_PACKAGE__PARENT);
		}
		return subPackages;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCPackage getParent() {
		if (parent != null && parent.eIsProxy()) {
			TRCPackage oldParent = parent;
			parent = (TRCPackage)eResolveProxy((InternalEObject)parent);
			if (parent != oldParent) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TracePackage.TRC_PACKAGE__PARENT, oldParent, parent));
			}
		}
		return parent;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCPackage basicGetParent() {
		return parent;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetParent(TRCPackage newParent, NotificationChain msgs) {
		TRCPackage oldParent = parent;
		parent = newParent;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, TracePackage.TRC_PACKAGE__PARENT, oldParent, newParent);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParent(TRCPackage newParent) {
		if (newParent != parent) {
			NotificationChain msgs = null;
			if (parent != null)
				msgs = ((InternalEObject)parent).eInverseRemove(this, TracePackage.TRC_PACKAGE__SUB_PACKAGES, TRCPackage.class, msgs);
			if (newParent != null)
				msgs = ((InternalEObject)newParent).eInverseAdd(this, TracePackage.TRC_PACKAGE__SUB_PACKAGES, TRCPackage.class, msgs);
			msgs = basicSetParent(newParent, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_PACKAGE__PARENT, newParent, newParent));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case TracePackage.TRC_PACKAGE__PROCESS:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, TracePackage.TRC_PACKAGE__PROCESS, msgs);
				case TracePackage.TRC_PACKAGE__CLASSES:
					return ((InternalEList)getClasses()).basicAdd(otherEnd, msgs);
				case TracePackage.TRC_PACKAGE__SUB_PACKAGES:
					return ((InternalEList)getSubPackages()).basicAdd(otherEnd, msgs);
				case TracePackage.TRC_PACKAGE__PARENT:
					if (parent != null)
						msgs = ((InternalEObject)parent).eInverseRemove(this, TracePackage.TRC_PACKAGE__SUB_PACKAGES, TRCPackage.class, msgs);
					return basicSetParent((TRCPackage)otherEnd, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case TracePackage.TRC_PACKAGE__PROCESS:
					return eBasicSetContainer(null, TracePackage.TRC_PACKAGE__PROCESS, msgs);
				case TracePackage.TRC_PACKAGE__CLASSES:
					return ((InternalEList)getClasses()).basicRemove(otherEnd, msgs);
				case TracePackage.TRC_PACKAGE__SUB_PACKAGES:
					return ((InternalEList)getSubPackages()).basicRemove(otherEnd, msgs);
				case TracePackage.TRC_PACKAGE__PARENT:
					return basicSetParent(null, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case TracePackage.TRC_PACKAGE__PROCESS:
					return ((InternalEObject)eContainer).eInverseRemove(this, TracePackage.TRC_PROCESS__PACKAGES, TRCProcess.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_PACKAGE__NAME:
				return getName();
			case TracePackage.TRC_PACKAGE__BASE_TIME:
				return new Double(getBaseTime());
			case TracePackage.TRC_PACKAGE__CUMULATIVE_TIME:
				return new Double(getCumulativeTime());
			case TracePackage.TRC_PACKAGE__CALLS:
				return new Integer(getCalls());
			case TracePackage.TRC_PACKAGE__INHERITED_CALLS:
				return new Integer(getInheritedCalls());
			case TracePackage.TRC_PACKAGE__INHERITED_BASE_TIME:
				return new Double(getInheritedBaseTime());
			case TracePackage.TRC_PACKAGE__INHERITED_CUMULATIVE_TIME:
				return new Double(getInheritedCumulativeTime());
			case TracePackage.TRC_PACKAGE__TOTAL_SIZE:
				return new Integer(getTotalSize());
			case TracePackage.TRC_PACKAGE__TOTAL_INSTANCES:
				return new Integer(getTotalInstances());
			case TracePackage.TRC_PACKAGE__COLLECTED_SIZE:
				return new Integer(getCollectedSize());
			case TracePackage.TRC_PACKAGE__COLLECTED_INSTANCES:
				return new Integer(getCollectedInstances());
			case TracePackage.TRC_PACKAGE__TOTAL_CPU_TIME:
				return new Double(getTotalCpuTime());
			case TracePackage.TRC_PACKAGE__PROCESS:
				return getProcess();
			case TracePackage.TRC_PACKAGE__CLASSES:
				return getClasses();
			case TracePackage.TRC_PACKAGE__SUB_PACKAGES:
				return getSubPackages();
			case TracePackage.TRC_PACKAGE__PARENT:
				if (resolve) return getParent();
				return basicGetParent();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_PACKAGE__NAME:
				setName((String)newValue);
				return;
			case TracePackage.TRC_PACKAGE__BASE_TIME:
				setBaseTime(((Double)newValue).doubleValue());
				return;
			case TracePackage.TRC_PACKAGE__CUMULATIVE_TIME:
				setCumulativeTime(((Double)newValue).doubleValue());
				return;
			case TracePackage.TRC_PACKAGE__CALLS:
				setCalls(((Integer)newValue).intValue());
				return;
			case TracePackage.TRC_PACKAGE__INHERITED_CALLS:
				setInheritedCalls(((Integer)newValue).intValue());
				return;
			case TracePackage.TRC_PACKAGE__INHERITED_BASE_TIME:
				setInheritedBaseTime(((Double)newValue).doubleValue());
				return;
			case TracePackage.TRC_PACKAGE__INHERITED_CUMULATIVE_TIME:
				setInheritedCumulativeTime(((Double)newValue).doubleValue());
				return;
			case TracePackage.TRC_PACKAGE__TOTAL_SIZE:
				setTotalSize(((Integer)newValue).intValue());
				return;
			case TracePackage.TRC_PACKAGE__TOTAL_INSTANCES:
				setTotalInstances(((Integer)newValue).intValue());
				return;
			case TracePackage.TRC_PACKAGE__COLLECTED_SIZE:
				setCollectedSize(((Integer)newValue).intValue());
				return;
			case TracePackage.TRC_PACKAGE__COLLECTED_INSTANCES:
				setCollectedInstances(((Integer)newValue).intValue());
				return;
			case TracePackage.TRC_PACKAGE__TOTAL_CPU_TIME:
				setTotalCpuTime(((Double)newValue).doubleValue());
				return;
			case TracePackage.TRC_PACKAGE__PROCESS:
				setProcess((TRCProcess)newValue);
				return;
			case TracePackage.TRC_PACKAGE__CLASSES:
				getClasses().clear();
				getClasses().addAll((Collection)newValue);
				return;
			case TracePackage.TRC_PACKAGE__SUB_PACKAGES:
				getSubPackages().clear();
				getSubPackages().addAll((Collection)newValue);
				return;
			case TracePackage.TRC_PACKAGE__PARENT:
				setParent((TRCPackage)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_PACKAGE__NAME:
				setName(NAME_EDEFAULT);
				return;
			case TracePackage.TRC_PACKAGE__BASE_TIME:
				setBaseTime(BASE_TIME_EDEFAULT);
				return;
			case TracePackage.TRC_PACKAGE__CUMULATIVE_TIME:
				setCumulativeTime(CUMULATIVE_TIME_EDEFAULT);
				return;
			case TracePackage.TRC_PACKAGE__CALLS:
				setCalls(CALLS_EDEFAULT);
				return;
			case TracePackage.TRC_PACKAGE__INHERITED_CALLS:
				setInheritedCalls(INHERITED_CALLS_EDEFAULT);
				return;
			case TracePackage.TRC_PACKAGE__INHERITED_BASE_TIME:
				setInheritedBaseTime(INHERITED_BASE_TIME_EDEFAULT);
				return;
			case TracePackage.TRC_PACKAGE__INHERITED_CUMULATIVE_TIME:
				setInheritedCumulativeTime(INHERITED_CUMULATIVE_TIME_EDEFAULT);
				return;
			case TracePackage.TRC_PACKAGE__TOTAL_SIZE:
				setTotalSize(TOTAL_SIZE_EDEFAULT);
				return;
			case TracePackage.TRC_PACKAGE__TOTAL_INSTANCES:
				setTotalInstances(TOTAL_INSTANCES_EDEFAULT);
				return;
			case TracePackage.TRC_PACKAGE__COLLECTED_SIZE:
				setCollectedSize(COLLECTED_SIZE_EDEFAULT);
				return;
			case TracePackage.TRC_PACKAGE__COLLECTED_INSTANCES:
				setCollectedInstances(COLLECTED_INSTANCES_EDEFAULT);
				return;
			case TracePackage.TRC_PACKAGE__TOTAL_CPU_TIME:
				setTotalCpuTime(TOTAL_CPU_TIME_EDEFAULT);
				return;
			case TracePackage.TRC_PACKAGE__PROCESS:
				setProcess((TRCProcess)null);
				return;
			case TracePackage.TRC_PACKAGE__CLASSES:
				getClasses().clear();
				return;
			case TracePackage.TRC_PACKAGE__SUB_PACKAGES:
				getSubPackages().clear();
				return;
			case TracePackage.TRC_PACKAGE__PARENT:
				setParent((TRCPackage)null);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_PACKAGE__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case TracePackage.TRC_PACKAGE__BASE_TIME:
				return baseTime != BASE_TIME_EDEFAULT;
			case TracePackage.TRC_PACKAGE__CUMULATIVE_TIME:
				return cumulativeTime != CUMULATIVE_TIME_EDEFAULT;
			case TracePackage.TRC_PACKAGE__CALLS:
				return calls != CALLS_EDEFAULT;
			case TracePackage.TRC_PACKAGE__INHERITED_CALLS:
				return inheritedCalls != INHERITED_CALLS_EDEFAULT;
			case TracePackage.TRC_PACKAGE__INHERITED_BASE_TIME:
				return inheritedBaseTime != INHERITED_BASE_TIME_EDEFAULT;
			case TracePackage.TRC_PACKAGE__INHERITED_CUMULATIVE_TIME:
				return inheritedCumulativeTime != INHERITED_CUMULATIVE_TIME_EDEFAULT;
			case TracePackage.TRC_PACKAGE__TOTAL_SIZE:
				return totalSize != TOTAL_SIZE_EDEFAULT;
			case TracePackage.TRC_PACKAGE__TOTAL_INSTANCES:
				return totalInstances != TOTAL_INSTANCES_EDEFAULT;
			case TracePackage.TRC_PACKAGE__COLLECTED_SIZE:
				return collectedSize != COLLECTED_SIZE_EDEFAULT;
			case TracePackage.TRC_PACKAGE__COLLECTED_INSTANCES:
				return collectedInstances != COLLECTED_INSTANCES_EDEFAULT;
			case TracePackage.TRC_PACKAGE__TOTAL_CPU_TIME:
				return totalCpuTime != TOTAL_CPU_TIME_EDEFAULT;
			case TracePackage.TRC_PACKAGE__PROCESS:
				return getProcess() != null;
			case TracePackage.TRC_PACKAGE__CLASSES:
				return classes != null && !classes.isEmpty();
			case TracePackage.TRC_PACKAGE__SUB_PACKAGES:
				return subPackages != null && !subPackages.isEmpty();
			case TracePackage.TRC_PACKAGE__PARENT:
				return parent != null;
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (name: ");
		result.append(name);
		result.append(", baseTime: ");
		result.append(baseTime);
		result.append(", cumulativeTime: ");
		result.append(cumulativeTime);
		result.append(", calls: ");
		result.append(calls);
		result.append(", inheritedCalls: ");
		result.append(inheritedCalls);
		result.append(", inheritedBaseTime: ");
		result.append(inheritedBaseTime);
		result.append(", inheritedCumulativeTime: ");
		result.append(inheritedCumulativeTime);
		result.append(", totalSize: ");
		result.append(totalSize);
		result.append(", totalInstances: ");
		result.append(totalInstances);
		result.append(", collectedSize: ");
		result.append(collectedSize);
		result.append(", collectedInstances: ");
		result.append(collectedInstances);
		result.append(", totalCpuTime: ");
		result.append(totalCpuTime);
		result.append(')');
		return result.toString();
	}

} //TRCPackageImpl
