/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TRCThreadDeadLockEventImpl.java,v 1.2 2004/12/03 17:22:57 slavescu Exp $
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.trace.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TRCThreadDeadLockEvent;
import org.eclipse.hyades.models.trace.TracePackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TRC Thread Dead Lock Event</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCThreadDeadLockEventImpl#getNextDeadLockEvent <em>Next Dead Lock Event</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TRCThreadDeadLockEventImpl extends TRCThreadWaitingForLockEventImpl implements TRCThreadDeadLockEvent {
	/**
	 * The cached value of the '{@link #getNextDeadLockEvent() <em>Next Dead Lock Event</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getNextDeadLockEvent()
	 * @generated
	 * @ordered
	 */
	protected TRCThreadDeadLockEvent nextDeadLockEvent = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TRCThreadDeadLockEventImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return TracePackage.eINSTANCE.getTRCThreadDeadLockEvent();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCThreadDeadLockEvent getNextDeadLockEvent() {
		if (nextDeadLockEvent != null && nextDeadLockEvent.eIsProxy()) {
			TRCThreadDeadLockEvent oldNextDeadLockEvent = nextDeadLockEvent;
			nextDeadLockEvent = (TRCThreadDeadLockEvent)eResolveProxy((InternalEObject)nextDeadLockEvent);
			if (nextDeadLockEvent != oldNextDeadLockEvent) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TracePackage.TRC_THREAD_DEAD_LOCK_EVENT__NEXT_DEAD_LOCK_EVENT, oldNextDeadLockEvent, nextDeadLockEvent));
			}
		}
		return nextDeadLockEvent;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCThreadDeadLockEvent basicGetNextDeadLockEvent() {
		return nextDeadLockEvent;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setNextDeadLockEvent(TRCThreadDeadLockEvent newNextDeadLockEvent) {
		TRCThreadDeadLockEvent oldNextDeadLockEvent = nextDeadLockEvent;
		nextDeadLockEvent = newNextDeadLockEvent;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_THREAD_DEAD_LOCK_EVENT__NEXT_DEAD_LOCK_EVENT, oldNextDeadLockEvent, nextDeadLockEvent));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case TracePackage.TRC_THREAD_DEAD_LOCK_EVENT__THREAD:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, TracePackage.TRC_THREAD_DEAD_LOCK_EVENT__THREAD, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case TracePackage.TRC_THREAD_DEAD_LOCK_EVENT__THREAD:
					return eBasicSetContainer(null, TracePackage.TRC_THREAD_DEAD_LOCK_EVENT__THREAD, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case TracePackage.TRC_THREAD_DEAD_LOCK_EVENT__THREAD:
					return ((InternalEObject)eContainer).eInverseRemove(this, TracePackage.TRC_THREAD__THREAD_EVENTS, TRCThread.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_THREAD_DEAD_LOCK_EVENT__TIME:
				return new Double(getTime());
			case TracePackage.TRC_THREAD_DEAD_LOCK_EVENT__THREAD:
				return getThread();
			case TracePackage.TRC_THREAD_DEAD_LOCK_EVENT__LOCKED_OBJECT:
				if (resolve) return getLockedObject();
				return basicGetLockedObject();
			case TracePackage.TRC_THREAD_DEAD_LOCK_EVENT__LOCKING_THREAD:
				if (resolve) return getLockingThread();
				return basicGetLockingThread();
			case TracePackage.TRC_THREAD_DEAD_LOCK_EVENT__NEXT_DEAD_LOCK_EVENT:
				if (resolve) return getNextDeadLockEvent();
				return basicGetNextDeadLockEvent();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_THREAD_DEAD_LOCK_EVENT__TIME:
				setTime(((Double)newValue).doubleValue());
				return;
			case TracePackage.TRC_THREAD_DEAD_LOCK_EVENT__THREAD:
				setThread((TRCThread)newValue);
				return;
			case TracePackage.TRC_THREAD_DEAD_LOCK_EVENT__LOCKED_OBJECT:
				setLockedObject((TRCObject)newValue);
				return;
			case TracePackage.TRC_THREAD_DEAD_LOCK_EVENT__LOCKING_THREAD:
				setLockingThread((TRCThread)newValue);
				return;
			case TracePackage.TRC_THREAD_DEAD_LOCK_EVENT__NEXT_DEAD_LOCK_EVENT:
				setNextDeadLockEvent((TRCThreadDeadLockEvent)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_THREAD_DEAD_LOCK_EVENT__TIME:
				setTime(TIME_EDEFAULT);
				return;
			case TracePackage.TRC_THREAD_DEAD_LOCK_EVENT__THREAD:
				setThread((TRCThread)null);
				return;
			case TracePackage.TRC_THREAD_DEAD_LOCK_EVENT__LOCKED_OBJECT:
				setLockedObject((TRCObject)null);
				return;
			case TracePackage.TRC_THREAD_DEAD_LOCK_EVENT__LOCKING_THREAD:
				setLockingThread((TRCThread)null);
				return;
			case TracePackage.TRC_THREAD_DEAD_LOCK_EVENT__NEXT_DEAD_LOCK_EVENT:
				setNextDeadLockEvent((TRCThreadDeadLockEvent)null);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_THREAD_DEAD_LOCK_EVENT__TIME:
				return time != TIME_EDEFAULT;
			case TracePackage.TRC_THREAD_DEAD_LOCK_EVENT__THREAD:
				return getThread() != null;
			case TracePackage.TRC_THREAD_DEAD_LOCK_EVENT__LOCKED_OBJECT:
				return lockedObject != null;
			case TracePackage.TRC_THREAD_DEAD_LOCK_EVENT__LOCKING_THREAD:
				return lockingThread != null;
			case TracePackage.TRC_THREAD_DEAD_LOCK_EVENT__NEXT_DEAD_LOCK_EVENT:
				return nextDeadLockEvent != null;
		}
		return eDynamicIsSet(eFeature);
	}

} //TRCThreadDeadLockEventImpl
