/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.cbe;

import java.util.Iterator;
import java.util.Stack;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.loaders.util.XMLFragmentLoader;
import org.eclipse.hyades.models.hierarchy.CorrelationSourceInfo;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.UnresolvedCorrelation;
import org.eclipse.hyades.models.hierarchy.impl.UnresolvedCorrelationImpl;


/**
 * @author slavescu
 *
 */
abstract class CBEBaseXMLFragmentLoader extends Stack implements XMLFragmentLoader {
    //~ Instance fields ----------------------------------------------------------------------------

    protected EObject newCurrentChild;
    protected HierarchyContext context;
    protected String name;

    //~ Methods ------------------------------------------------------------------------------------

    public void addCharacters(char[] data, int offset, int length) {
    }

    /* (non-Javadoc)
     * @see org.eclipse.hyades.loaders.util.XMLFragmentLoader#cleanUp()
     */
    public void cleanUp() {
        processForwardReferences(context);
        context = null;
        clear();
    }

    public void endChild(String name) {
    }

    /* (non-Javadoc)
     * @see org.eclipse.hyades.loaders.util.XMLFragmentLoader#initialize(org.eclipse.hyades.loaders.util.HierarchyContext, java.lang.String)
     */
    public void initialize(HierarchyContext context, String name) {
        this.context = context;
        this.name = name;
        newCurrentChild = null;
        if (context.getAgent() == null) {
        	LoadersUtils.createAgent(context);
        }
    }

    public void startChild(String name) {
    }

    protected void addForwardReference(EObject owner, EReference feature, String value) {
        UnresolvedCorrelation unresolvedCorrelation = HierarchyFactory.eINSTANCE.createUnresolvedCorrelation();

        unresolvedCorrelation.setContextId(value);

        CorrelationSourceInfo correlationSourceInfo = HierarchyFactory.eINSTANCE.createCorrelationSourceInfo();

        correlationSourceInfo.setOwner(owner);
        correlationSourceInfo.setReference(feature);

        unresolvedCorrelation.getSourceInfos().add(correlationSourceInfo);

        // add the unrezolved reference to the current agent
        unresolvedCorrelation.setAgent(context.getAgent());
    }

    protected void processForwardReferences(HierarchyContext context) {
        for (Iterator iter = context.getAgent().getUnresolvedCorrelations().iterator();
                 iter.hasNext();) {
            UnresolvedCorrelation unresolvedCorrelation = (UnresolvedCorrelation) iter.next();

            for (Iterator iterator = unresolvedCorrelation.getSourceInfos().iterator();
                     iterator.hasNext();) {
                CorrelationSourceInfo correlationSourceInfo = (CorrelationSourceInfo) iterator.next();

                EReference reference = correlationSourceInfo.getReference();
                EObject owner = correlationSourceInfo.getOwner();
                EObject o = (EObject) LookupServiceExtensions.getInstance().locate(context, reference.getEReferenceType().getInstanceClass(), unresolvedCorrelation.getContextId());

                if ((o != null)) {// && reference.getEReferenceType().getInstanceClass().isAssignableFrom(o.getClass())) {
                    if (reference.isMany()) {
                        ((EList) owner.eGet(reference)).add(o);
                    } else {
                        owner.eSet(reference, o);
                    }

                    iterator.remove();
                }
            }

            if (unresolvedCorrelation.getSourceInfos().size() == 0) {
                iter.remove();
            }
        }
    }

	protected void processForwardReferences(String contextId,EObject o) {
			UnresolvedCorrelation unresolvedCorrelation = (UnresolvedCorrelation) LookupServiceExtensions.getInstance().locate(null,UnresolvedCorrelationImpl.class,contextId);
			if(o!=null && unresolvedCorrelation!=null)
			{
				for (Iterator iterator = unresolvedCorrelation.getSourceInfos().iterator();
						 iterator.hasNext();) {
					CorrelationSourceInfo correlationSourceInfo = (CorrelationSourceInfo) iterator.next();
	
					EReference reference = correlationSourceInfo.getReference();
					EObject owner = correlationSourceInfo.getOwner();
	
//					if ((o != null)) {// && reference.getEReferenceType().getInstanceClass().isAssignableFrom(o.getClass())) {
						if (reference.isMany()) {
							((EList) owner.eGet(reference)).add(o);
						} else {
							owner.eSet(reference, o);
						}
						iterator.remove();
//					}
				}
				if (unresolvedCorrelation.getSourceInfos().size() == 0) {
					unresolvedCorrelation.setAgent(null);
				}
			}

	}
}
