/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.cbe;

import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.XMLFragmentLoader;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;


/**
 * @author slavescu
 */
public class XMLCollector implements XMLFragmentLoader {
    //~ Instance fields ----------------------------------------------------------------------------

    private Element currentElement;
    private Element rootElement;
    private int level;

    //~ Methods ------------------------------------------------------------------------------------

    /**
     * @return
     */
    public String getTargetFeatureName() {
        return rootElement.getName();
    }

    /**
     * @return
     */
    public String getTargetFeatureValue() {
        return printContent();
    }

    /* (non-Javadoc)
     * @see org.eclipse.hyades.loaders.util.XMLFragmentLoader#addAttribute(java.lang.String, java.lang.String)
     */
    public void addAttribute(String name, String value) {
        currentElement.addAttribute(name, value);
    }

    /**
     * @param data
     * @param offset
     * @param length
     */
    public void addCharacters(char[] data, int offset, int length) {
        currentElement.addCharacters(data, offset, length);
    }

    /* (non-Javadoc)
     * @see org.eclipse.hyades.loaders.util.XMLFragmentLoader#addYourselfInContext()
     */
    public void addYourselfInContext() {
    }

    /* (non-Javadoc)
     * @see org.eclipse.hyades.loaders.util.XMLFragmentLoader#cleanUp()
     */
    public void cleanUp() {
    }

    /**
     * @return
     */
    public boolean done() {
        if (level == 0) {
            return true;
        }

        return false;
    }

    /**
     * @param name
     */
    public void endChild(String name) {
        currentElement = currentElement.getParent();
        level--;
    }

    /* (non-Javadoc)
     * @see org.eclipse.hyades.loaders.util.XMLFragmentLoader#initialize(org.eclipse.hyades.loaders.util.HierarchyContext, java.lang.String)
     */
    public void initialize(HierarchyContext context, String name) {
        rootElement = new Element(name, null);
        currentElement = rootElement;
        level = 0;
    }

    /**
     * @param name
     */
    public void startChild(String name) {
        addChild(name);
        level++;
    }

    /**
     * @param name
     */
    private void addChild(String name) {
        List children = currentElement.getChildren();

        currentElement = new Element(name, currentElement);
        children.add(currentElement);
    }

    /**
     * @param attributes
     * @param buffer
     */
    private void printAttributes(Attributes attributes, StringBuffer buffer) {
        if (attributes == null) {
            return;
        }

        for (Iterator iter = attributes.entrySet().iterator(); iter.hasNext();) {
            Map.Entry entry = (Map.Entry) iter.next();

            buffer.append(' ');
            buffer.append(entry.getKey());
            buffer.append('=');
            buffer.append('"');
            buffer.append(entry.getValue());
            buffer.append('"');
        }
    }

    /**
     * @return
     */
    private String printContent() {
        if ((rootElement == null) || (rootElement.getChildren() == null)) {
            return null;
        }

        StringBuffer buffer = new StringBuffer();

        for (Iterator iter = rootElement.getChildren().iterator(); iter.hasNext();) {
            Element childElement = (Element) iter.next();

            printElement(childElement, buffer);
        }

        return buffer.toString();
    }

    /**
     * @param rootElement2
     */
    private void printElement(Element element, StringBuffer buffer) {
        buffer.append('<');
        buffer.append(element.getName());
        printAttributes(element.getAttributes(), buffer);

        if (element.getChildren() != null) {
            buffer.append(">\n");

            for (Iterator iter = element.getChildren().iterator(); iter.hasNext();) {
                Element childElement = (Element) iter.next();

                printElement(childElement, buffer);
            }

            if (element.getCdata() != null) {
                buffer.append(element.getCdata().toString());
            }

            buffer.append("</");
            buffer.append(element.getName());
            buffer.append(">\n");
        } else {
            if (element.getCdata() != null) {
                buffer.append(element.getCdata().toString());
                buffer.append("</");
                buffer.append(element.getName());
                buffer.append(">\n");
            } else {
                buffer.append("/>\n");
            }
        }
    }

    //~ Inner Classes ------------------------------------------------------------------------------

    /**
     * @author slavescu
     */
    public class Attributes extends HashMap {
        private Element parent;

        /**
         * @param element
         */
        public Attributes(Element parent) {
            this.parent = parent;
        }

        /**
         * @param name
         * @param value
         */
        public void append(String name, String value) {
            String newValue = (String) get(name);

            if (newValue != null) {
                newValue += value;
            } else {
                newValue = value;
            }

            put(name, newValue);
        }
    }

    /**
     * @author slavescu
     */
    public class Element extends ArrayList {
        private Attributes attributes;
        private Element parent;
        private String name;
        private StringBuffer cdata;

        /**
         * @param name
         * @param currentElement
         */
        public Element(String name, Element parent) {
            this.name = name;
            this.parent = parent;
        }

        /**
         * @return Returns the attributes.
         */
        public Attributes getAttributes() {
            return attributes;
        }

        /**
         * @return Returns the cdata.
         */
        public StringBuffer getCdata() {
            return cdata;
        }

        /**
         * @return
         */
        public List getChildren() {
            return this;
        }

        /**
         * @return
         */
        public String getName() {
            return name;
        }

        /**
         * @return
         */
        public Element getParent() {
            return parent;
        }

        /**
         * @param name
         * @param value
         */
        public void addAttribute(String name, String value) {
            if (attributes == null) {
                attributes = new Attributes(this);
            }

            attributes.append(name, value);
        }

        /**
         * @param data
         * @param offset
         * @param length
         */
        public void addCharacters(char[] data, int offset, int length) {
            if (cdata == null) {
                cdata = new StringBuffer();
            }

            cdata.append(data, offset, length);
        }
    }
}
