package org.eclipse.hyades.logging.events;
/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

import org.eclipse.hyades.logging.events.exceptions.InvalidXMLAnyElementException;

/**
 * @author Jason Cornpropst
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 * @deprecated This class is deprecated as of 2004-05-17. Use the corresponding class available in org.eclipse.hyades.logging.events.cbe*
 */
public class CommonBaseEventAnyElementImpl implements ICommonBaseEventAnyElement, Cloneable {
    //~ Instance variables ...............................................................

    private String nameSpace = null;
    private String nameSpaceIdentifier = null;
    private String elementName = null;
    private String anyElement = null;

    //~ Constructors .....................................................................

    protected CommonBaseEventAnyElementImpl() {
    	super();
    }

    //~ Methods ..........................................................................

    /**
     * @see org.eclipse.hyades.logging.events.ICommonBaseEventAnyElement#getNameSpace()
     */
    public String getNameSpace() {
        return nameSpace;
    }

    /**
     * Method to set the name space URI
     *
     * @param String the URI representing the name space
     */
    private void setNameSpace(String nameSpace) {
        this.nameSpace = nameSpace;
    }

    /**
     * @see org.eclipse.hyades.logging.events.ICommonBaseEventAnyElement#getNameSpaceIdentifier()
     */
    public String getNameSpaceIdentifier() {
        return nameSpaceIdentifier;
    }

    /**
     * Method to set the name space identifier
     *
     * @param String the identifier used to repesent the name space within the any element
     */
    private void setNameSpaceIdentifier(String nameSpaceIdentifier) {
        this.nameSpaceIdentifier = nameSpaceIdentifier;
    }

    /**
     * @see org.eclipse.hyades.logging.events.ICommonBaseEventAnyElement#getElementName()
     */
    public String getElementName() {
        return elementName;
    }

    /**
     * Method to set the name of the element
     *
     * @param String the name of the element
     */
    private void setElementName(String elementName) {
        this.elementName = elementName;
    }

    /**
     * @see org.eclipse.hyades.logging.events.ICommonBaseEventAnyElement#getXmlAnyElement()
     */
    public String getXmlAnyElement() {
        return anyElement;
    }

    /**
     * @see org.eclipse.hyades.logging.events.ICommonBaseEventAnyElement#setXmlAnyElement(String)
     */
    public void setXmlAnyElement(String anyElement) throws InvalidXMLAnyElementException {
        String elementName = null;
        String nameSpaceIdentifier = null;
        String nameSpace = null;

        // the header of the any element should be of form
        //< nameSpaceIdentifier:elementName xmlns:nameSpaceIdentifier="nameSpace" >
        // first do a subString to return the element header
        // strip off the beginning < and ending >
        String elementHeader = anyElement.substring(1, anyElement.indexOf(">")).trim();

        // make sure we got a string. And the length is greater than 0. 
        if ((elementHeader != null) && (elementHeader.length() > 0)) {
            // now search for the first :
            int colonPosition = elementHeader.indexOf(":");

            if (colonPosition > 0) {
                nameSpaceIdentifier = elementHeader.substring(0, colonPosition).trim();

                // now move to the end of the colon
                if (elementHeader.length() > (colonPosition + 1)) {
                    elementHeader = elementHeader.substring(colonPosition + 1).trim();

                    int spacePosition = elementHeader.indexOf(" ");

                    if (spacePosition > 0) {
                        // now grab the element name 
                        elementName = nameSpaceIdentifier + ":" + elementHeader.substring(0, spacePosition);

                        // now move the the uri
                        int doubleQuotePosition = elementHeader.indexOf("\"");

                        if (doubleQuotePosition > 0) {
                            elementHeader = elementHeader.substring(doubleQuotePosition + 1).trim();
                            doubleQuotePosition = elementHeader.indexOf("\"");

                            if (doubleQuotePosition > 0) {
                                nameSpace = elementHeader.substring(0, (doubleQuotePosition - 1)).trim();
                            }
                            else {
                                throw new InvalidXMLAnyElementException("Unable to parse XML name space. Missing ending quote. \n" + anyElement);
                            }
                        }
                        else {
                            throw new InvalidXMLAnyElementException("Unable to parse XML name space. Missing beginning quote. \n" + anyElement);
                        }
                    }
                    else {
                        throw new InvalidXMLAnyElementException("Unable to parse element name. \n" + anyElement);
                    }
                }
                else {
                    throw new InvalidXMLAnyElementException("Unable to parse element name. Colon at end of header. \n" + anyElement);
                }
            }
            else {
                throw new InvalidXMLAnyElementException("Unable to parse XML name space identifier. Missing colon. \n" + anyElement);
            }

            setNameSpace(nameSpace);
            setElementName(elementName);
            setNameSpaceIdentifier(nameSpaceIdentifier);
            this.anyElement = anyElement;
        }
        else {
            throw new InvalidXMLAnyElementException("Unable to parse XML any element header. Missing greater and less than symbols. \n" + anyElement);
        }
    }

    /**
     * Determines is two different event instance are equal.
     */
    public boolean equals(Object obj) {
        boolean result = false;

        //It's the same object reference, so it HAS to be equal
        if (this == obj) {
            result = true;
        }
        else {
            //If the object is null or is not the correct type of object, it can't be
            //equal
            if ((obj != null) && (obj instanceof CommonBaseEventAnyElementImpl) && (getClass() == obj.getClass())) {
                CommonBaseEventAnyElementImpl element = (CommonBaseEventAnyElementImpl) obj;
                if (anyElement.equals(element.anyElement)) {
                    result = true;
                }
            }
        }
        return result;
    }

    /**
     * return a cloned (copy by value) object. This is a deep copy version, in which all the
     * objects within this object will be copied by value.
     *  
     * @return Object
     */
    public Object clone() throws CloneNotSupportedException {
        return (super.clone());
    }
}