/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.trace.actions.internal;

import org.eclipse.hyades.uml2sd.trace.loaders.TraceInteractions;

/**
 * Action to highlight the call stack of the selected message by selecting the chain of caller messages
 */
public class LifelineFilterInAction extends TraceGraphNodeAction {

	/**
	 * @see org.eclipse.hyades.uml2sd.trace.actions.internal.TraceGraphNodeAction#run(org.eclipse.hyades.uml2sd.trace.loaders.TraceInteractions)
	 */
	public void run() {
		TraceInteractions.getInstance().drillDown(graphNodes);
	}
	
}
