/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.trace.loaders;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.uml2sd.trace.TraceSDPlugin;

/**
 * This class aims to populate an Agent Interaction UML2 Sequence Diagram.
 */
public class AgentInteractions extends BaseLifelineLoader {
	
	/**
	 * Constructor
	 */
	public AgentInteractions() {
		parent = new ProcessInteractions();
	}

	/**
	 * @see org.eclipse.hyades.uml2sd.trace.loaders.ILifelineLoader#getLifelineEObjectFromMethodInvocation(org.eclipse.hyades.models.trace.TRCFullMethodInvocation)
	 */
	public EObject getLifelineEObjectFromMethodInvocation(
			TRCFullMethodInvocation mi) {
		return mi.getProcess().getAgent(); // TRCAgent
	}
	
	/**
	 * @see org.eclipse.hyades.uml2sd.trace.loaders.ILifelineLoader#getLifeLineCategory(org.eclipse.emf.ecore.EObject)
	 */
	public int getLifeLineCategory(EObject to) {
		return TraceInteractions.CATEGORY_AGENT;
	}
	
	/**
	 * @see org.eclipse.hyades.uml2sd.trace.loaders.ILifelineLoader#getLifeLineTitle(org.eclipse.emf.ecore.EObject, boolean)
	 */
	public String getLifeLineTitle(EObject to, boolean long_) {
		TRCAgent agent = (TRCAgent)to;
		return agent.getRuntimeId(); //$NON-NLS-1$
	}

	/**
	 * The runtimeId of agentProxy and the lifeline title
	 */
	public String getLifeLineId(EObject eo) {
		TRCAgentProxy ap;
		ap = ((TRCAgent)eo).getAgentProxy();
		return ap.getRuntimeId()+"#"+getLifeLineTitle(eo, true); //$NON-NLS-1$
	}
	
	/**
	 * @see org.eclipse.hyades.uml2sd.trace.loaders.ILifelineLoader#getTitleString()
	 */
	public String getFinalTitleString() {
		return TraceSDPlugin.getResourceString("STR_UML2SD_AGENT_INTERACTION"); //$NON-NLS-1$
	}

	/**
	 * @see org.eclipse.hyades.uml2sd.trace.loaders.ILifelineLoader#getLifelineType(org.eclipse.emf.ecore.EObject)
	 */
	public String getLifelineType(EObject eObject) {
		return TraceSDPlugin.getResourceString("STR_AGENT"); //$NON-NLS-1$;
	}

}
