/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.trace.loaders;

import org.eclipse.hyades.uml2sd.ui.load.IUml2SDLoader;
import org.eclipse.hyades.uml2sd.ui.view.SDView;


/**
 * Base class for all the lifeline loaders (see ILifelineLoader) for Trace Interactions features.
 */
abstract public class BaseLifelineLoader implements ILifelineLoader, IUml2SDLoader {
	
	protected ILifelineLoader parent;
	
	/**
	 * @see org.eclipse.hyades.uml2sd.trace.loaders.ILifelineLoader#getParent()
	 */
	public ILifelineLoader getParent() {
		return parent;
	}
	
	/**
	 * @see org.eclipse.hyades.uml2sd.ui.load.IUml2SDLoader#setViewer(org.eclipse.hyades.uml2sd.ui.view.SDView)
	 */
	public void setViewer(SDView viewer) {
		TraceInteractions.getInstance().setLifelineLoader(this);
		TraceInteractions.getInstance().setViewer(viewer);
	}

	/**
	 * @see org.eclipse.hyades.uml2sd.ui.load.IUml2SDLoader#getTitleString()
	 */
	public String getTitleString() {
		return TraceInteractions.getInstance().getTitleString();
	}

	/**
	 * @see org.eclipse.hyades.uml2sd.ui.load.IUml2SDLoader#aboutToBeReplaced()
	 */
	public void aboutToBeReplaced() {
		TraceInteractions.getInstance().aboutToBeReplaced();
	}
	
	/**
	 * Default implementation for the lifeline loaders that does allow drill down
	 */
	public boolean drillDownEnabled(String value) {
		return "true".equalsIgnoreCase(value);  //$NON-NLS-1$
	}

}
