/*``````````````````````````````````````````````````````````````/**********************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/

/*
 * NONE OF THE QUOTED STRINGS IN THIS FILE ARE TO BE LOCALIZED
 * THEY ARE ALL FOR XML TAGS, DEBUGGING SUPPORT, THEY ARE NOT FOR USER INTERFACES
 */

package org.eclipse.hyades.execution.recorder.http.remote;

import java.io.*;
import java.net.*;

/**
 * @author dmorris
 * modified by:  mddunn 11/17/2003 for Hyades-O 1.2
 *
 * To change this generated comment go to 
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
abstract public class ClientSideReader extends Thread{
	
	public static final String ERROR_SSL_REQUEST_MADE = "-1"; //this is an error until SSL is supported
	public static final String ERROR_NO_TESTKEYS = "-2"; //this is an error until SSL is supported
	static final String STR_KEEP_ALIVE = "Proxy-Connection: Keep-Alive\r\n";
	static int iConn = 0;
	static final String ClientSideReaderException = HttpRecResourceBundle.getInstance().getString("RECORDER_CLIENTSIDE_READER_EXCEPTION");
	String defaultCipherSuite = "SSL_RSA_WITH_RC4_128_MD5";
	String defaultProtocol = "TLSv1";
	
	InputStream from_client;
	OutputStream to_client;
	InputStream from_server;
	OutputStream to_server;
	//Socket client = null;
	PeekSocket client = null;
	Socket httpServer = null;
	ServerSideReader serverReader = null;
	// this flag indicates whether we are operating an SSL connection
	boolean bSecure = false;
	boolean bNoPrintToServer = false;
	PacketWriter packetWriter = null;
	boolean secureConnectionOK = false;

	String destServer = null;
	String keyFile = null;
	int serverPort = 80;
	int iConnection = 0;
	ConnectionObj connectionNumber = new ConnectionObj();
	static int isSSLClassAvailable = -1;
	static boolean foundTestKeys = false;
	// new SSL info
	String sslCipherSuite = "";
	String sslProtocol = "";
	InetAddress newAddr = null;
	int destPort = 0;
	

	/**
	 * Old constructor to keep old support.  Not intended for new readers.  Use ClientSideReader(PeekSocket, PacketWriter, String)
	 * @param client
	 * @param packetWriter
	 * @deprecated
	 */
	ClientSideReader(PeekSocket client, PacketWriter packetWriter)
	{
		this(client, packetWriter, "C:\\testkeys");
	}
	
	ClientSideReader(PeekSocket client, PacketWriter packetWriter, String keyFile){
		try{
			this.from_client = client.getInputStream();
			this.to_client = client.getOutputStream();
			this.client = client;
			this.iConnection = getNextConnection();
			this.connectionNumber.setConnectionNumber(iConnection);
			this.packetWriter = packetWriter;
			this.keyFile = keyFile;
			packetWriter.writeRecorderMessage(1, "Client Connected, connection " + iConnection );
					
		}
		catch (Exception e){
			packetWriter.writeRecorderMessage(2, "exception in ClientSideReader: " + e);
			packetWriter.getAgentController().reportException(ClientSideReaderException,e);
		}
	
	}
	ClientSideReader(){
		
	}
	synchronized static int getNextConnection(){
		iConn++;
		return iConn;
	}
	
	abstract public void run();
	


	private static String IP4ByteToString (byte myvar[]) {
		String strResult = "";		
		for (int i = 0; i < 4; i++) {
			if ((int)myvar[i] >= 0) {
				strResult += String.valueOf((int)myvar[i]);
			} else {
				strResult += String.valueOf(256 + (int)myvar[i]);
			}
			if (i < 3) {
				strResult += ".";
			}		
		}
		return strResult;
	}

	public int findSSLClass() {
		int gotSSL = -1;

		try{
				Class cl = Class.forName("javax.net.ssl.SSLSocket");
				gotSSL = 1;
			}
			catch (ClassNotFoundException cnf){
				gotSSL = 0;			
			}
		return gotSSL;
	}

	public boolean checkForTestKeys() {
		if (keyFile == null || keyFile.length() == 0)
			keyFile = "C:\\testkeys";
		boolean foundIt = false;
		File keysFile = new File(keyFile);
		foundIt = keysFile.exists();
		return foundIt;
	}
}