/**********************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/

/*
 * NONE OF THE QUOTED STRINGS IN THIS FILE ARE TO BE LOCALIZED
 * THEY ARE ALL FOR XML TAGS, DEBUGGING SUPPORT, THEY ARE NOT FOR USER INTERFACES
 */

package org.eclipse.hyades.execution.recorder.http.remote;

import java.io.IOException;
import java.net.Socket;
import java.util.Date;
import java.util.Properties;
import javax.net.ssl.*;
import java.net.InetAddress;
import java.text.SimpleDateFormat;


import org.eclipse.hyades.internal.execution.recorder.remote.RecorderAgent;

/**
 * @author morris
 *
 * To change this generated comment go to 
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class PacketWriter 
{
	static final int ENCODING_TYPE_NONE = 0;
	static final int ENCODING_TYPE_BASE64 = 1;
	static final int ENCODING_TYPE_ASCIIFY = 2;
	
	static final String PACKET_TAG = "<TRCPacket>\r\n";
	static final String XML_IDENT = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n\r\n<TRACE>\r\n\r\n";
	
	static final String DATA_TAGEND = "]]></data>\r\n";
	static final String PACKET_TAGEND = "</TRCPacket>\r\n\r\n";
	
	static int iTicket = 0;
	static long lTimeRef = 0;
	
	Date date;
	static int encodedLength = -1;
	
	static boolean bStopRecording = false;
	
	private RecorderAgent agent;
	
	protected GlobalPacketQueue packetQueue;
	
	public PacketWriter(RecorderAgent theAgentController){
		super();
		date = new Date();
		agent = theAgentController;
		bStopRecording = false;
		
		packetQueue = new GlobalPacketQueue (this);
		packetQueue.setPriority(Thread.MIN_PRIORITY);
		packetQueue.start();
	}
	
	public synchronized boolean writePacket(boolean bSecure,
			boolean bFromClient,
			ConnectionObj iConnection,
			byte [] buffer,
			int bufLength){
		
		boolean bRet = false;
		
		String dirString = null; 
		String typeString = null;
		int encodingType = ENCODING_TYPE_NONE, messageEncoding = ENCODING_TYPE_NONE;
		String str = new String(buffer, 0, bufLength);
		int iMessageLoc, iMessageEnd = -1, iContentLoc = -1, iBinaryCount = 0;
		String strEncoded = null;
		byte [] byteEncodedArray = null;
		// mdd CRATLC00853785
		String messageEncoded = null;
		int encodedMessageLength = 0;
		byte[] byteEncodedMessage = null;
		
		int thisConn = iConnection.getConnectionNumber();
		if (thisConn == 0) {
			writeRecorderMessage(1, "REJECTED writePacket - connection number is 0");
			return false;
		}
		
		
		iTicket = TicketDispatcher.getTicket();
		
		try{
			
			encodedLength = -1;
			
			iMessageLoc = getHTTPMessageLocation(bFromClient, str);
			
			if (iMessageLoc < 0){
				// if there is no HTTP message, this must be a content only packet
				iContentLoc = 0;
			}else{
				
				iContentLoc = getContentLocation(iMessageLoc, bFromClient, str);
				
				iMessageEnd = iContentLoc - 1;
				if (iContentLoc >= bufLength)  {
					iContentLoc = -1;
				}
				//	 RATLC00853785 bug mdd
				if (bFromClient) {
					int mBinaryCount = getBinaryCountMESSAGE(0, bFromClient, buffer, iMessageEnd);
					if (mBinaryCount > 0) {
						byteEncodedMessage = getASCIIFYEncodedByteArray(0, buffer, iMessageEnd);
						if (byteEncodedMessage != null) {
							messageEncoding = ENCODING_TYPE_ASCIIFY;
							encodedMessageLength = encodedLength;
						}
					}
				}
			}
			if (iContentLoc >= 0){
				iBinaryCount = getBinaryCount(iContentLoc, bFromClient, buffer, bufLength);
				if (iBinaryCount > 0){
					
					if (iBinaryCount >= 5){
						strEncoded = getBase64EncodedString(iContentLoc, buffer, bufLength);
						if (strEncoded != null)
							encodingType = ENCODING_TYPE_BASE64;
						encodedLength = strEncoded.length();
					}
					else{
						byteEncodedArray = getASCIIFYEncodedByteArray(iContentLoc, buffer, bufLength);
						if (byteEncodedArray != null)
							encodingType = ENCODING_TYPE_ASCIIFY;					
					}
				}
			}
			
			if (bFromClient == true){
				dirString = "CLIENT\" ";
			}else{
				dirString = "SERVER\" ";
			}
			
			if (bSecure == true)
				typeString = "HTTPS";
			else
				typeString = "HTTP";
			
			
			writeString("<TRCPacket ticket=\"" +
					Integer.toString(iTicket) +
					"\" connectionNumber=\"" +
					//Integer.toString(iConnection) +
					iConnection.getConnectionNumber() +
					"\" timestamp=\"" +
					Long.toString(TimeStampDispatcher.getTimeStamp())+
					"\" from=\"" + 
					dirString +
					" type=\"" +
					typeString +
			"\">\r\n");
			
			if (iMessageLoc >= 0){
				int iBytesToWrite = bufLength;
				
				if(iMessageEnd >= 0) {
					iBytesToWrite = bufLength - (bufLength - iMessageEnd);
				}
				
				if (messageEncoding == ENCODING_TYPE_NONE) {
					writeString("<data length=\"" +
							Integer.toString(iBytesToWrite)+
							"\" encoding=\"" +
							"none\" type=\"HTTPMESSAGE\" " +
					"><![CDATA[");
				}
				
				else {
					writeString("<data length=\"" +
							Integer.toString(iBytesToWrite)+
							"\" encoding=\"" +
							"ASCIIFY\" " + " encodedLength=\"" + Integer.toString(encodedMessageLength) + "\" " +
							"type=\"HTTPMESSAGE\" " +
					"><![CDATA[");
				}
				
				/*writeString("<data length=\"" +
				 Integer.toString(iBytesToWrite)+
				 "\" encoding=\"" +
				 "none\" type=\"HTTPMESSAGE\" " +
				 "><![CDATA["); */
				
				flushStreamWriter();
				if (messageEncoding == ENCODING_TYPE_NONE)
					writeBytes(buffer, 0, iBytesToWrite);
				else
					writeBytes(byteEncodedMessage,0,encodedMessageLength);
				
				//flushOutputStream();
				writeString(DATA_TAGEND);
			}	
			if (iContentLoc >= 0){
				StringBuffer strData;
				int iBytesToWrite = bufLength - iContentLoc;
				strData = new StringBuffer("<data length=\"" +
						Integer.toString(iBytesToWrite)+
				"\" encoding=\"");
				
				switch (encodingType){
				case ENCODING_TYPE_BASE64:
					strData.append("BASE64\"");
					break;	
				case ENCODING_TYPE_ASCIIFY:
					strData.append("ASCIIFY\"");
					break;	
				case ENCODING_TYPE_NONE:
				default:
					strData.append("NONE\"");
				break;
				};
				if (encodingType > ENCODING_TYPE_NONE){
					strData.append(" encodedLength=\"" + Integer.toString(encodedLength) + "\" ");
				}
				strData.append(" type=\"HTTPCONTENT\" ><![CDATA[");
				String strTemp = new String(strData);
				writeString(strTemp);
				
				if (encodingType != ENCODING_TYPE_BASE64){
					flushStreamWriter();
					if (encodingType == ENCODING_TYPE_ASCIIFY)
						writeBytes(byteEncodedArray, 0, encodedLength);
					else
						writeBytes(buffer, iContentLoc, iBytesToWrite);
					//flushOutputStream();
				}else{
					writeString(strEncoded);
				}
				writeString(DATA_TAGEND);
			}	 
			writeString(PACKET_TAGEND);
			//flushOutputStream();
		}
		catch (Exception e){											 	
			
			e.printStackTrace();	
		}
		return bRet;
	}
	
	
	public synchronized boolean writeOpenConnectionInfo(boolean bSecure,
			int iConnection,
			String strServer,
			int port,	
			Socket client,
			Socket server,
			SSLSocket sslClient,
			SSLSocket sslServer){
		
		try{
			
			
			long timeStamp = TimeStampDispatcher.getTimeStamp();
			iTicket = TicketDispatcher.getTicket();
			InetAddress tempaddr = client.getInetAddress();
			String tempStr = tempaddr.toString();
			String prtString = "";
			
			prtString = removeLeadingSlash(tempStr);
			
			writeString("<TRCConnection type=\"OPEN\" ticket=\"" +
					Integer.toString(iTicket) +
					"\" connectionNumber=\"" +
					Integer.toString(iConnection) +
					"\" timestamp=\"" +
					Long.toString(TimeStampDispatcher.getTimeStamp())+
					"\">\r\n<servername>\r\n" + strServer +
					"</servername>\r\n<port>" + Integer.toString(port) +
					"</port>\r\n" +
					// "<clientInetAddress>" + client.getInetAddress() + "</clientInetAddress>\r\n" +	
					"<clientInetAddress>" + prtString + "</clientInetAddress>\r\n" +	
					"<clientPort>" + Integer.toString(client.getPort()) + "</clientPort>\r\n" +			
			"</TRCConnection>\r\n\r\n"); 
			//flushOutputStream();
			String thisconn = Integer.toString(iConnection);
			CleanupObj clean = new CleanupObj();
			clean.setThisSocket(server);
			clean.setThisWriter(this);
			clean.setThisConnection(thisconn);
			GlobalSocketList.add(thisconn,clean);
		}
		catch (Exception e){											 	
		}
		
		return true;	
	}
	
	public synchronized boolean writeOpenSecureConnectionInfo(boolean bSecure,
			int iConnection,
			String strServer,
			int port,	
			Socket client,
			Socket server,
			SSLSocket sslClient,
			SSLSocket sslServer,
			String cipherSuite,
			String sslProtocol){
		
		try{
			
			
			long timeStamp = TimeStampDispatcher.getTimeStamp();
			iTicket = TicketDispatcher.getTicket();
			InetAddress tempaddr = client.getInetAddress();
			String tempStr = tempaddr.toString();
			
			String prtString = "";
			
			prtString = removeLeadingSlash(tempStr);
			
			writeString("<TRCConnection type=\"OPEN\" ticket=\"" +
					Integer.toString(iTicket) +
					"\" connectionNumber=\"" +
					Integer.toString(iConnection) +
					"\" timestamp=\"" +
					Long.toString(TimeStampDispatcher.getTimeStamp())+
					"\">\r\n<servername>\r\n" + strServer +
					"</servername>\r\n<port>" + Integer.toString(port) +
					"</port>\r\n" +
					"<clientInetAddress>" + prtString + "</clientInetAddress>\r\n" +
					"<clientPort>" + Integer.toString(client.getPort()) + "</clientPort>\r\n" +	
					"<cipherSuite>" + cipherSuite + "</cipherSuite>\r\n" +
					"<protocol>" + sslProtocol + "</protocol>\r\n" +
			"</TRCConnection>\r\n\r\n"); 
			//flushOutputStream();
			
		}
		catch (Exception e){											 	
		}
		String tmpConn = "";
		
		tmpConn = Integer.toString(iConnection);
		CleanupObj tmpCleanup = new CleanupObj();
		tmpCleanup.setThisSocket(server);
		tmpCleanup.setThisWriter(this);
		tmpCleanup.setThisConnection(tmpConn);
		
		GlobalSocketList.add(tmpConn,tmpCleanup);
		
		
		return true;	
	}
	
	
	public synchronized boolean writeCloseConnectionInfo(ConnectionObj iConnection){
		
		String originalConnectionNumber = Integer.toString(iConnection.getConnectionNumber());											 	
		try{
			
			
			long timeStamp = TimeStampDispatcher.getTimeStamp();
			iTicket = TicketDispatcher.getTicket();
			
			
			writeString("<TRCConnection type=\"CLOSE\" ticket=\"" +
					Integer.toString(iTicket) +
					"\" connectionNumber=\"" +
					//Integer.toString(iConnection) +
					iConnection.getConnectionNumber() +
					"\" timestamp=\"" +
					Long.toString(TimeStampDispatcher.getTimeStamp())+
			"\"/>\r\n"); 
			//flushOutputStream();
			//writeRecorderMessage(1, "WRITECLOSECONNECTION - NOW RESET to 0");
			iConnection.setConnectionNumber(0);
		}
		catch (Exception e){											 	
			e.printStackTrace();
		}
		GlobalSocketList.remove(originalConnectionNumber,this);
		return true;	
	}
	
	public synchronized boolean writeRecorderStartInfo(int iProxyRecorderPort, 
			String iProxyAddr, int iProxyPort){
		
		try{
			long timeStamp = TimeStampDispatcher.getTimeStamp();
			iTicket = TicketDispatcher.getTicket();
			Properties prop = System.getProperties();
			writeString(XML_IDENT);
			String recorderInfo = "";
			Date now = new Date();
			SimpleDateFormat militaryTime = new SimpleDateFormat("MM/dd/yyyy kk:mm:ss");
			
			
			
			
			recorderInfo = "<TRCRecorderInfo type=\"start\" ticket=\"" +
			Integer.toString(iTicket) +
			"\" timestamp=\"" +
			Long.toString(TimeStampDispatcher.getTimeStamp())+
			"\">\r\n<recorderport>" +  Integer.toString(iProxyRecorderPort) +
			// "</recorderport>\r\n<date>" + date.toLocaleString() + "</date>\r\n" +
			"</recorderport>\r\n<date>" + militaryTime.format(now) + "</date>\r\n" +
			"<recorderversion>3.0.2.1</recorderversion>\r\n" +
			"<javavmversion>" + prop.getProperty("java.vm.version") + "</javavmversion>\r\n" + 
			"<javavmvendor>" + prop.getProperty("java.vm.vendor") + "</javavmvendor>\r\n" +
			"<javahome>" + prop.getProperty("java.home") + "</javahome>\r\n" + 
			"<osname>" + prop.getProperty("os.name") + "</osname>\r\n" +
			"<osversion>" + prop.getProperty("os.version") + "</osversion>\r\n";
			if (iProxyAddr.length() > 0) {
				recorderInfo = recorderInfo + "<proxyaddress>" + iProxyAddr + "</proxyaddress>\r\n"+
				"<proxyport>" + iProxyPort + "</proxyport>\r\n";
			}
			
			
			writeString(recorderInfo);
			writeString("</TRCRecorderInfo>\r\n\r\n");
			
			//flushOutputStream();
		}
		catch (Exception e){											 	
		}
		
		return true;	
	}
	
	public synchronized boolean writeRecorderStopInfo(){
		
		try{
			
			
			long timeStamp = TimeStampDispatcher.getTimeStamp();
			iTicket = TicketDispatcher.getTicket();
			
			writeString("<TRCRecorderInfo type=\"STOP\" ticket=\"" +
					Integer.toString(iTicket) +
					"\" timestamp=\"" +
					Long.toString(TimeStampDispatcher.getTimeStamp())+
			"\">\r\n");
			writeString("</TRCRecorderInfo>\r\n\r\n</TRACE>\r\n");
			//flushOutputStream();
			bStopRecording = true;
		}
		catch (Exception e){											 	
		}
		
		return true;	
	}
	
	public synchronized boolean writeRecorderMessage(int type, String strMessage){
		
		try{
			
			
			long timeStamp = TimeStampDispatcher.getTimeStamp();
			iTicket = TicketDispatcher.getTicket();
			String strType = null;
			
			switch (type){
			case 2:
				strType = "ERROR";
				break;
			default:
				strType = "INFORMATION";
			break;
			};
			
			writeString("<TRCRecorderInfo type=\"" + strType + "\" ticket=\"" +
					Integer.toString(iTicket) +
					"\" timestamp=\"" +
					Long.toString(TimeStampDispatcher.getTimeStamp())+
					"\">\r\n<message>" + strMessage + "</message>\r\n");
			writeString("</TRCRecorderInfo>\r\n\r\n");
			//flushOutputStream();
		}
		catch (Exception e){											 	
		}
		
		return true;	
	}
	
	
	private int getHTTPMessageLocation(boolean bFromClient, String str) 
	//byte[] buffer, int bufLength)
	{
		int iRet = -1;
		int iLineFeed = str.indexOf("\r\n");
		
		
		if (!bFromClient){
			iRet = str.indexOf("HTTP/");
			if (iRet > 1)
				iRet = -1;
		}
		else
		{
			iRet  = str.indexOf("HTTP/1.");
		}
		// the above must be in the first line
		// AND there must be a double carriage return - line feed somewhere in the data
		if (iRet > iLineFeed || str.indexOf("\r\n\r\n") < 0)
			iRet = -1;
		
		return iRet;
		
	}
	
	private int getContentLocation(int iBodyStart, boolean bFromClient, String str)
	{
		int iRet = -1;
		
		iRet = str.indexOf("\r\n\r\n");
		
		iRet += 4;
		
		return iRet;
		
	}
	
	private int getBinaryCount(int iContentStart, boolean bFromClient, byte[] buffer, int length)
	{
		byte bInspect;
		int iBinCount = 0;
		int iLoop;
		int iStop = 50 + iContentStart; // look at the first 50 characters is default
		
		if (iStop > length)
			iStop = length;
		
		
		for (iLoop = iContentStart; iLoop < iStop; iLoop++){
			if ((isByteBinary(buffer[iLoop])) == true) {
				// bugzilla 69171 - don't count '`' 
				if (buffer[iLoop] != '`')
					iBinCount++;
			}
			if (iBinCount > 4)
				break;
		}
		if (iBinCount == 0 && iStop < length){
			for (iLoop = iStop; iLoop < length; iLoop++){
				if (((isByteBinary(buffer[iLoop])) == true)
						&& (buffer[iLoop] != '`')){
					iBinCount++;
					break;				
				}
			}
		}
		
		
		return iBinCount;
	}
	private int getBinaryCountMESSAGE(int iContentStart, boolean bFromClient, byte[] buffer, int length)
	{
		byte bInspect;
		int iBinCount = 0;
		int iLoop;
		int iStop = 50 + iContentStart; // look at the first 50 characters is default
		
		if (iStop > length)
			iStop = length;
		
		for (iLoop = iContentStart; iLoop < iStop; iLoop++){
			if ((isByteBinaryMESSAGE(buffer[iLoop])) == true) 
				iBinCount++;
			
			if (iBinCount > 4)
				break;
		}
		if (iBinCount == 0 && iStop < length){
			for (iLoop = iStop; iLoop < length; iLoop++){
				if ((isByteBinaryMESSAGE(buffer[iLoop])) == true){
					iBinCount++;
					break;				
				}
			}
		}
		
		
		return iBinCount;
	}
	
	/**
	 *	This utility method converts a passed byte array into a Base 64 encoded
	 *	String according to the specification in RFC1521 section 5.2
	 */
	private static final String mappings = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";//$NON-NLS-1$
	private static final String filler = "=";//$NON-NLS-1$
	/**
	 *	Answer a string representing the Base 64 encoded form of the passed
	 *	byte array
	 *
	 *	@return java.lang.String
	 *	@param contents byte[]
	 */
	
	private String getBase64EncodedString(int iContentStart, byte[] contents, int bufLength){
		
		//public static String encode(byte[] contents) {
		StringBuffer result = new StringBuffer();
		
		for (int i = iContentStart; i < bufLength; i = i + 3) {
			if (result.length() == 76)
				result.append("\n\r");//$NON-NLS-1$
			
			// output character 1
			result.append(mappings.charAt((contents[i] & 0xFC) >> 2));
			
			// output character 2
			int c2 = (contents[i] & 0x03) << 4;
			if (i + 1 >= contents.length) {
				result.append(mappings.charAt(c2));
				result.append(filler);
				result.append(filler);
				return result.toString();
			}
			
			c2 |= ((contents[i + 1] & 0xF0) >> 4);
			result.append(mappings.charAt(c2));
			
			// output character 3
			int c3 = (contents[i + 1] & 0x0F) << 2;
			if (i + 2 >= contents.length) {
				result.append(mappings.charAt(c3));
				result.append(filler);
				return result.toString();
			}
			
			c3 |= ((contents[i + 2] & 0xC0) >> 6);
			result.append(mappings.charAt(c3));
			
			// output character 4
			result.append(mappings.charAt(contents[i + 2] & 0x3F));
		}
		
		return result.toString();
	}
	
	
	private byte [] getASCIIFYEncodedByteArray(int iContentStart, byte[] buffer, int bufLength)
	{
		int iLoop, iLoc = 0, iLen;
		byte b1;
		boolean bEncoded = false, bNeedsEncoding = false;
		final byte [] asciiRef = {'0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F'};
		
		iLen = bufLength - iContentStart; 
		
		byte [] encodedBuf = new byte[iLen * 2 + 2];
		byte [] unencodedBuf = new byte[iLen];
		
		try{
			
			for (iLoop = iContentStart; iLoop < bufLength; iLoop++){
				b1 = buffer[iLoop];
				bNeedsEncoding = isByteBinary(b1);
				
				// two ascii characters in a row are needed to switch back to 
				// non-encoding mode
				if (bEncoded && !bNeedsEncoding){
					// obviously, check so we don't go past the end
					if ((iLoop + 1) < iLen){
						bNeedsEncoding = isByteBinary(buffer[iLoop + 1]);
					}
				}
				if (bNeedsEncoding){
					if (!bEncoded){
						encodedBuf[iLoc] = '`';
						iLoc++;
					}
					int i = (int)b1;
					if (i < 0)
						i += 256;
					i = i >> 4;
					if (i < 0 || i > 15){
						i = 0;
					}
					encodedBuf[iLoc] = asciiRef[i];
					iLoc++;
					i = (b1 & 0x0f);
					if (i < 0 || i > 15){
						
						i = 0;
					}
					encodedBuf[iLoc] = asciiRef[i];
					iLoc++;
					bEncoded = true;
				}
				else{
					if (bEncoded){
						encodedBuf[iLoc] = '`';
						iLoc++;
						bEncoded = false;
					}
					encodedBuf[iLoc] = buffer[iLoop];
					iLoc++;
				}	
				if (encodedBuf[iLoc - 1] < 0){
					int i =0;
				}
			}
			if (bEncoded){
				encodedBuf[iLoc] = '`';
				iLoc++;
			}
			encodedLength = iLoc;
		}
		catch (Exception e){
			e.printStackTrace();
		}
		
		
		return encodedBuf;
	}
	
	private boolean isByteBinary(byte b){
		boolean bRet = false;
		// the ']' character is included to guard against writing a "]]>" which
		// would terminate a CDATA tag
		
		if (b == ']')
			bRet = true;
		else if ((b < 32) || (b > 126 || (b == '`'))){
			//if ((b != '\r') && (b != '\n') && (b != '\t') && (b != '`') && (b != ']'))
			// bugzilla defect 69171
			if ((b != '\n') && (b != '\t') && (b != ']'))
				bRet = true;
		}
		return bRet;	
	}
	private boolean isByteBinaryMESSAGE(byte b){
		boolean bRet = false;
		// the ']' character is included to guard against writing a "]]>" which
		// would terminate a CDATA tag
		
		if (b == ']')
			bRet = true;
		else if ((b < 32) || (b > 126 )){
			if ((b != '\r') && (b != '\n') && (b != '\t') && (b != '`') && (b != ']'))
				bRet = true;
		}
		return bRet;	
	}
	protected void flushOutputStream() throws IOException
	{
		//if(agent==null)
		//	to_file.flush();
	}
	
	private void flushStreamWriter() throws IOException
	{
		//if(agent == null)
		//	to_fileXML.flush();
	}
	
	protected void writeString(String data) throws IOException
	{
		if (!bStopRecording)
			packetQueue.add(data);
		/*if(agent!=null && !bStopRecording)
			agent.sendByteDataToDataProcessor(data.getBytes(), 0, data.getBytes().length);
			*/
		//else
		//	to_fileXML.write(data);
	}
	
	private void writeBytes(byte[] buffer, int iOffset, int buflength) throws IOException
	{
		if (!bStopRecording)
			packetQueue.add( buffer,iOffset,buflength);
		/*if(agent!=null && !bStopRecording)
			agent.sendByteDataToDataProcessor(buffer, iOffset, buflength);
			*/
		
		//else
		//	to_file.write(buffer,0,buflength);
	}

	public void sendToDataProcessor(byte[] byteBuf) {
		if(agent!=null) {
			agent.sendByteDataToDataProcessor(byteBuf, 0, byteBuf.length);
		}
	}
	public void flushRemainingPackets () {
		//writeRecorderMessage(1, "IN flushRemainingPackets(), call Initiate Shutdown");
		packetQueue.initiateShutdown();
		try {
			packetQueue.join();
		} catch (Exception e) {
			//
		}
	}

	/**
	 * @return
	 */
	public RecorderAgent getAgentController()
	{
		return agent;
	}
	public String removeLeadingSlash(String originalString) {
		String prtString = "";
		if (originalString.startsWith("/")) {
			prtString = originalString.substring(1);
		}
		else 
			prtString = originalString;
		
		return prtString;
	}

	
	public synchronized boolean writeCloseConnectionInfo(String iConnection){
		
		try{
			
			long timeStamp = TimeStampDispatcher.getTimeStamp();
			iTicket = TicketDispatcher.getTicket();
			
			writeString("<TRCConnection type=\"CLOSE\" ticket=\"" +
					Integer.toString(iTicket) +
					"\" connectionNumber=\"" +
					//Integer.toString(iConnection) +
					iConnection +
					"\" timestamp=\"" +
					Long.toString(TimeStampDispatcher.getTimeStamp())+
			"\"/>\r\n"); 
			//flushOutputStream();
		}
		catch (Exception e){											 	
			e.printStackTrace();
		}
		return true;	
	}
	
}
