/**********************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/

/*
 * NONE OF THE QUOTED STRINGS IN THIS FILE ARE TO BE LOCALIZED
 * THEY ARE ALL FOR XML TAGS, DEBUGGING SUPPORT, THEY ARE NOT FOR USER INTERFACES
 */

package org.eclipse.hyades.execution.recorder.http.remote;

import java.io.*;
import java.net.*;

/**
 * @author morris
 *
 * To change this generated comment go to 
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class ServerSideReader extends Thread{
	InputStream from_server;
	OutputStream to_spySocket;
	InputStream from_sslPassThroughStream;
	OutputStream to_client;
	FileOutputStream to_file;
	PacketWriter packetWriter = null;
	boolean bSecure;
	boolean bClosedByClient = false;
	int iConnection = 0;
	int iReceiveBufSize = 0;
	Socket client;
	Socket server;
	ConnectionObj connectionNumber;
	byte[] ssrBuffer = null;
	
	ServerSideReader(Socket client,
					 Socket server,
					 InputStream from_server,
					 OutputStream to_client,
					 PacketWriter packetWriter,
					 //int iConnection,
					 ConnectionObj connectionNumber,
					 boolean bSecure,
					 int iReceiveBufSize){
		
		this.client = client;
		this.server = server;
		this.from_server = from_server;
		this.to_client = to_client;
		this.packetWriter = packetWriter;
		this.bSecure = bSecure;
		this.iConnection = connectionNumber.getConnectionNumber();
		this.connectionNumber = connectionNumber;
		this.iReceiveBufSize = iReceiveBufSize;
		
	}
	public void setClosedByClient(){
		bClosedByClient = true;
	}
	
	public void run(){
		
		//byte[] buffer = new byte[iReceiveBufSize];
		ssrBuffer = new byte[iReceiveBufSize];
		int bytes_read = 0;
		
		this.setName("ServerSideReader-Conn:"+iConnection);
		
		try{
			// Try new statement below mdd
			//packetWriter.writeRecorderMessage(1, "IN SERVERSIDEREADER BEGIN READING... for Connection: " + iConnection );
			while ((bytes_read = from_server.read(ssrBuffer)) >= 0){
				
				to_client.write(ssrBuffer,0, bytes_read);
				to_client.flush();
				packetWriter.writePacket(bSecure, false, this.connectionNumber, ssrBuffer, bytes_read);
			}
		}
		catch (NullPointerException npc) {
			packetWriter.writeRecorderMessage(1, "IN SERVERSIDEREADER CAUGHT NULLPOINTEREXCEPTION for Connection: " + iConnection );
		}
		catch (Exception e) {
			//packetWriter.writeRecorderMessage(1, "IN SERVERSIDEREADER GETMESSAGE() for Connection: " + iConnection );
			
			String mess = e.getMessage();
			// no record for the following exceptions, they are expected
			
			if (mess.indexOf("Stream closed") < 0 && mess.indexOf("Socket closed") < 0 &&
					mess.indexOf("JVM_recv in socket input") <0 && mess.indexOf("onnection closed")<0
					&& mess.indexOf("socket closed")<0 && mess.indexOf("onnection reset") < 0
					&& mess.indexOf("Socket is closed") <0) {
				packetWriter.writeRecorderMessage(2, "exception in ServerSideReader connection " + iConnection + " : " + e.getLocalizedMessage());
			}
			
		}
		finally {
			try {
				// if the server we are connected to terminated the connection, close the client side also
				// if the client closed the connection, just exit
				// New stuff 042204
			
				server.close();
				//packetWriter.writeRecorderMessage(1, "WRITE CLOSE CONNECTION for SERVERSIDEREADER Input Side " + iConnection );
				packetWriter.writeCloseConnectionInfo(connectionNumber);
				// MAY NEED if (!bClosedByClient)
				//	client.close();
				if (client != null) {
					if ((!client.isOutputShutdown()) && !client.isClosed() )
					{
						client.shutdownOutput();
						//packetWriter.writeRecorderMessage(1, "SHUTDOWN CLIENT OUTPUT IN SERVERSIDEREADER FOR Connection: " + iConnection );
					} else {
						//packetWriter.writeRecorderMessage(1, "CLIENT WAS ALREADY CLOSED IN SERVERSIDEREADER FOR Connection: " + iConnection );	
					}
				} else {
					//packetWriter.writeRecorderMessage(1, "CLIENT WAS NULL IN SERVERSIDEREADER FOR Connection: " + iConnection );
				}
			}
			catch (Exception e){
				packetWriter.writeRecorderMessage(2, "exception in ServerSideReader executing finally block connection " + iConnection + " : " + e.getLocalizedMessage());
				
			}
		}
		//packetWriter.writeRecorderMessage(1, "LEAVING SERVERSIDEREADER " + iConnection );
	}
}
