/**********************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.internal.execution.recorder.ui.actions;

import org.eclipse.hyades.execution.recorder.RecorderPlugin;
import org.eclipse.hyades.internal.execution.recorder.RecorderFactory;
import org.eclipse.hyades.internal.execution.recorder.ui.wizards.RecorderWizard;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

/**
 * @author jnevicos
 * 
 * Abstract class that implements launching the RecorderWizard (and its subclasses) as an action.
 *
 */
public abstract class AbstractNewRecordingAction
	extends Action
	implements IWorkbenchWindowActionDelegate, IRecorderAction {

	private IAction toolbarAction = null;

	/**
	 * 
	 */
	public AbstractNewRecordingAction()
	{
		super();
		RecorderFactory.getInstance().addListener(this);
	}

	/**
	 * @param text
	 */
	public AbstractNewRecordingAction(String text)
	{
		super(text);
		RecorderFactory.getInstance().addListener(this);
	}

	/**
	 * @param text
	 * @param image
	 */
	public AbstractNewRecordingAction(String text, ImageDescriptor image)
	{
		super(text, image);
		RecorderFactory.getInstance().addListener(this);
	}

	/**
	 * @param text
	 * @param style
	 */
	public AbstractNewRecordingAction(String text, int style)
	{
		super(text, style);
		RecorderFactory.getInstance().addListener(this);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IWorkbenchWindowActionDelegate#dispose()
	 */
	public void dispose() {
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IWorkbenchWindowActionDelegate#init(org.eclipse.ui.IWorkbenchWindow)
	 */
	public void init(IWorkbenchWindow window) {		
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 */
	public void run(IAction action) {

		action = toolbarAction;
		run();
	}

/* (non-Javadoc)
 * @see org.eclipse.jface.action.IAction#run()
 */
public void run()
{
	RecorderWizard wiz = loadWizard();
	wiz.init(getWorkbench(),getSelection());
	WizardDialog wizDlg = new WizardDialog(getWorkbench().getActiveWorkbenchWindow().getShell(),
		wiz);
	wizDlg.open();

}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction, org.eclipse.jface.viewers.ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
		toolbarAction = action;
	}

	public abstract RecorderWizard loadWizard();
	
	protected IWorkbench getWorkbench()
	{
		return RecorderPlugin.getDefault().getWorkbench();
	}
	
	protected IStructuredSelection getSelection()
	{
		IWorkbenchWindow window= RecorderPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
		if (window != null) {
			ISelection selection= window.getSelectionService().getSelection();
			if (selection instanceof IStructuredSelection) {
				return (IStructuredSelection) selection;
			}
			
		}
		return null;	
	}
	
	public void updateRecorderStatus(boolean active)
	{
		setEnabled(!active);  //this will not update anything on the main toolbar
		 
		//if any toolbar actions have used this class previously, set the enable state on them also
		
		//TODO: refactor to Eclipse standards (whatever that is...)
		if (toolbarAction != null)
			toolbarAction.setEnabled(!active);
	}
}
