/**********************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.internal.execution.recorder.ui.actions;

import org.eclipse.jface.action.IAction;

/**
 * RecorderAction interface.  Allows RecorderFactory to update the active state.
 * Action can update its enable state accordingly 
 * @author jnevicos
 *
 */
public interface IRecorderAction extends IAction
{
	/**
	 * Called by RecorderFactory, this allows registered actions to be notified of a change in 
	 * the state of the recorder.
	 * 
	 * @param active - boolean - the active state of the recorder
	 */
	public void updateRecorderStatus(boolean active);
}
