/**********************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.internal.execution.recorder.ui.actions;

import java.io.FileInputStream;
import java.io.IOException;

import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.execution.recorder.RecorderPlugin;
import org.eclipse.hyades.internal.execution.recorder.Recorder;
import org.eclipse.hyades.internal.execution.recorder.RecorderFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;

/**
 * Action for Stop recording button on Recorder Control View
 * @author Ernest Jessee
 */
public class StopRecordingAction extends Action implements IRecorderAction
{
	
	ImageDescriptor imgEnable, imgDisable;	
	/**
	 * 
	 */
	public StopRecordingAction()
	{
		super();
		RecorderFactory.getInstance().addListener(this);
	}

	/**
	 * @param text
	 */
	public StopRecordingAction(String text)
	{
		super(text);
		RecorderFactory.getInstance().addListener(this);
	}

	/**
	 * @param text
	 * @param image
	 */
	public StopRecordingAction(String text, ImageDescriptor image)
	{
		super(text, image);
		RecorderFactory.getInstance().addListener(this);
	}

	/**
	 * @param text
	 * @param style
	 */
	public StopRecordingAction(String text, int style)
	{
		super(text, style);
		RecorderFactory.getInstance().addListener(this);
	}

	/**
	 * run method
	 */
	public void run()
	{
		
		Recorder recorder = RecorderFactory.getInstance().getActiveRecorder();
		if(recorder!=null)	
			recorder.stopRecorder();
	}
	

	/**
	 * @see org.eclipse.jface.action.IAction#getImageDescriptor()
	 */
	public ImageDescriptor getImageDescriptor()
	{
		if (imgEnable == null)
			imgEnable = new ImageDescriptor()
		{	
			public ImageData getImageData()
			{
				try
				{
					String path = Platform.resolve(RecorderPlugin.getDefault().getDescriptor().getInstallURL()).toString()+"icons/clcl16/stoprecording.gif"; //$NON-NLS-1$
					path = path.substring(5,path.length());
					return new ImageData(new FileInputStream(path));
				}
				catch (IOException e)
				{
					e.printStackTrace();
				}
				return null;
			}
	
		};
		
		return imgEnable;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.action.IAction#getDisabledImageDescriptor()
	 */
	public ImageDescriptor getDisabledImageDescriptor() {
		if (imgDisable == null)
		imgDisable = new ImageDescriptor()
		{	
			public ImageData getImageData()
			{
				try
				{
					String path = Platform.resolve(RecorderPlugin.getDefault().getDescriptor().getInstallURL()).toString()+"icons/dlcl16/stoprecording.gif"; //$NON-NLS-1$
					path = path.substring(5,path.length());
					return new ImageData(new FileInputStream(path));
				}
				catch (IOException e)
				{
					e.printStackTrace();
				}
				return null;
			}
	
		};
		return imgDisable;
	}
	/**
	 * @see org.eclipse.jface.action.IAction#getToolTipText()
	 */
	public String getToolTipText()
	{
		return RecorderPlugin.getResourceString("StopRecordingAction.STOP_RECORDING_BUTTON_TOOLTIP"); //$NON-NLS-1$
	}
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.internal.execution.recorder.ui.actions.IRecorderAction#updateRecorderStatus(boolean)
	 */
	public void updateRecorderStatus(boolean active)
	{
		setEnabled(active);
	}

}
