/**********************************************************************
 * Copyright (c) 2003,2004 Scapa Technologies Limited and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.perfmon.common.internal;

import org.eclipse.emf.ecore.EObject;

import org.eclipse.hyades.model.statistical.*;

import org.eclipse.hyades.models.hierarchy.*;
import org.eclipse.hyades.perfmon.utils.internal.DCAgentGenericLoader;

import org.eclipse.swt.widgets.*;

import org.eclipse.hyades.statistical.ui.editor.internal.*;
import org.eclipse.hyades.statistical.ui.*;

import org.eclipse.hyades.perfmon.utils.internal.*;

public class CommonClickListener implements ClickListener {
	
DCAgentGenericLoader loader;
TRCAgent agent;
	public CommonClickListener(DCAgentGenericLoader loader, TRCAgent agent) {
		this.loader = loader;
		this.agent = agent;
	}
	public void doubleClick(StatConInterface statcon, TreeItem item, EObject relation, int button) {
		if (relation instanceof SDDescriptor) {
			SDDescriptor des = (SDDescriptor)relation;
			TRCAgent tmpagent = getAgent(des);
			if (tmpagent == agent) {
				if (button == 1) {
					//double left click
	
					if (relation instanceof SDMemberDescriptor) {
						//counter - start tracing it
						try {
							loader.getCommandUtil().startTracing(des);
						} catch (Exception e) {
							EditorPlugin.DBG.warning("double click listener failed to start tracing counter",e);
						}
						try {
							StatConImageApplier.applyBoth(statcon,des,StatConImageApplier.getStandardTracingImage());
						} catch (Exception e) {
							EditorPlugin.DBG.warning("double click listener failed to apply start tracing images",e);
						}
						
					} else if (relation instanceof SDDescriptor) {
						//tree structure - get its children
						try {
							loader.getCommandUtil().getUpdatedTree(des);
						} catch (Exception e) {
							EditorPlugin.DBG.warning("double click listener failed to get updated tree",e);
						}
					}
				}
			}
		}
	}
	private TRCAgent getAgent(SDDescriptor descriptor) {
		TRCAgent agent = descriptor.getAgent();
		if (agent != null) {
			return agent;
		} else {
			if (descriptor.getParent() != null) {
				return getAgent(descriptor.getParent());
			} else {
				return null;
			}
		}
	}
}