/**********************************************************************
 * Copyright (c) 2003,2004 Scapa Technologies Limited and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.perfmon.common.internal;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.hyades.statistical.ui.editor.internal.*;

public class CommonModuleTraceLaunchJob extends Job {
	String rac_host, reg_host;
	URI smodel_uri, monitor_uri;
	StatConInterface statcon;
	
	private CommonModuleTrace modtrace;
	
	public CommonModuleTrace getModuleTrace() {
		return modtrace;
	}

	public CommonModuleTraceLaunchJob(String description, CommonModuleTrace modtrace) {
		super(description);
		this.modtrace = modtrace;
	}
	public IStatus run(IProgressMonitor monitor) {
		
		modtrace.setProgressMonitor(monitor);
		modtrace.run();
		
		return new Status(IStatus.OK,"org.eclipse.hyades.perfmon",IStatus.OK,"",null);
	}
}
