/**********************************************************************
 * Copyright (c) 2003,2004 Scapa Technologies Limited and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/


package org.eclipse.hyades.perfmon.jonas.internal;

import org.eclipse.hyades.statistical.ui.widgets.internal.*;
import org.eclipse.hyades.perfmon.PerfmonPlugin;

import org.eclipse.swt.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.layout.*;

import org.eclipse.swt.graphics.*;
import org.eclipse.swt.events.*;

public class JonasHostDialog extends Dialog implements SelectionListener, KeyListener
{
	TabFolder tabFolder;	
	String rac_host = PerfmonPlugin.getString("JONAS_RAC_DEFAULT");
	String jonas_host = PerfmonPlugin.getString("JONAS_HOST_DEFAULT");
	int port= Integer.parseInt(JonasConstants.DEFAULT_JONAS_PORT);
	
	Composite host_panel;
	Label host_label;
	Text host_text;
	Label port_label;
	Text port_text;
	
	Label rac_label;
	Text rac_text;
		
	Composite buttonpanel;
	Button okbutton;
	Button cancelbutton;
			
	Shell parentshell;
	Shell thisshell;
	
	String return_rac_host;
	String return_jonas_host;
	String return_port;

	boolean success = false;
		
	public boolean isSuccessful()
	{
		return success;	
	}
	
	public JonasHostDialog (Shell parent) 
	{
		super (parent, 0);
		this.parentshell = parent;
	}

	public Object open () 
	{	
		Shell parent = getParent();
		Shell shell = new Shell(parent, SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);
		shell.setText(PerfmonPlugin.getString("CHOOSE_JONAS_HOST")); //$NON-NLS-1$
		shell.setBounds(0,0,300,270);
		shell.setLayout(new FillLayout());
		thisshell = shell;
		// Your code goes here (widget creation, set result, etc).

		PerfmonPlugin.DBG.info("initialising graphics");
		init(shell);
		shell.pack();

		Rectangle r = parentshell.getBounds();
		Rectangle z = shell.getBounds();
		if (z.width < 300) z.width = 300;
		if (z.height < 130) z.height = 130;

		shell.setBounds( r.x + (r.width/2) - (z.width/2),
						 r.y + (r.height/2) - (z.height/2),
						 z.width,
						 z.height
						 );
		

		PerfmonPlugin.DBG.info("opening dialog");
		shell.open();
		Display display = parent.getDisplay();
		while (!shell.isDisposed()) 
		{
			if (!display.readAndDispatch()) display.sleep();
		}

		return null;
	}
		
	public void init(Shell parent) 
	{
		GridLayout glayout = new GridLayout();
		glayout.numColumns = 1;
		
		Composite mainpanel = new Composite(parent, 0);
		mainpanel.setLayout(glayout);
		mainpanel.setLayoutData(GData.getGridData(true,false,-1,-1,1,1,GridData.FILL,GridData.FILL));		

		glayout = new GridLayout();
		glayout.numColumns = 4;							
							
		host_panel = new Composite(mainpanel,0);
		host_panel.setLayout(glayout);
		host_panel.setLayoutData(GData.getGridData(true,false,-1,-1,1,1,GridData.FILL,GridData.FILL));
				
		host_label = new Label(host_panel,SWT.LEFT);
		host_label.setLayoutData(GData.getGridData(false,false,-1,-1,1,1,GridData.FILL,GridData.CENTER));
		host_label.setText(PerfmonPlugin.getString("JONAS_HOST_TEXT"));				
		
		host_text = new Text(host_panel,SWT.SINGLE|SWT.LEFT|SWT.BORDER);
		host_text.setLayoutData(GData.getGridData(true,false,-1,-1,3,1,GridData.FILL,GridData.FILL));
		host_text.setText(jonas_host);
		
		port_label = new Label(host_panel,SWT.LEFT);
		port_label.setLayoutData(GData.getGridData(false,false,-1,-1,1,1,GridData.FILL,GridData.CENTER));
		port_label.setText(PerfmonPlugin.getString("JONAS_PORT_TEXT"));		
		
		port_text = new Text(host_panel,SWT.SINGLE|SWT.LEFT|SWT.BORDER);
		port_text.setLayoutData(GData.getGridData(true,false,-1,-1,3,1,GridData.FILL,GridData.FILL));
		port_text.setText(""+port);

		glayout = new GridLayout();
		glayout.numColumns = 1;
								
		rac_label = new Label(host_panel, SWT.LEFT);
		rac_label.setLayoutData(GData.getGridData(false,false,-1,-1,1,1,GridData.FILL,GridData.CENTER));
		rac_label.setText(PerfmonPlugin.getString("JONAS_RAC_TEXT"));
		
		rac_text = new Text(host_panel,SWT.SINGLE|SWT.LEFT|SWT.BORDER);
		rac_text.setLayoutData(GData.getGridData(true,false,-1,-1,3,1,GridData.FILL,GridData.FILL));
		rac_text.setText(rac_host);

		glayout = new GridLayout();
		glayout.numColumns = 2;
				
		buttonpanel = new Composite(mainpanel,0);
		buttonpanel.setLayout(glayout);
		buttonpanel.setLayoutData(GData.getGridData(true,false,-1,-1,1,1,GridData.CENTER,GridData.FILL));
		
		okbutton = new Button(buttonpanel,0);
		okbutton.setText(" "+PerfmonPlugin.getString("  OK  ")+" "); //$NON-NLS-1$
		okbutton.setLayoutData(GData.getGridData(false,false,-1,-1,1,1,GridData.CENTER,GridData.CENTER));

		cancelbutton = new Button(buttonpanel,0);
		cancelbutton.setText(PerfmonPlugin.getString("CANCEL")); //$NON-NLS-1$
		cancelbutton.setLayoutData(GData.getGridData(false,false,-1,-1,1,1,GridData.CENTER,GridData.CENTER));

		okbutton.addSelectionListener(this);
		cancelbutton.addSelectionListener(this);
		
		port_text.addKeyListener(this);
		host_text.addKeyListener(this);
		rac_text.addKeyListener(this);
		
		host_text.setFocus();		
	}
	
	public void widgetDefaultSelected(SelectionEvent e) 
	{
		widgetSelected(e);
	}
	 
	public void widgetSelected(SelectionEvent e) 
	{
	    widgetSelected(e.getSource());
	}
	    
	public void widgetSelected(Object o) 
	{
		if (o == okbutton) 
		{
			PerfmonPlugin.DBG.info("OK selected");
		    return_rac_host = rac_text.getText();
		    return_jonas_host = host_text.getText();
		    return_port = port_text.getText();			
			success = true;
			thisshell.close();
		} 
		else if (o == cancelbutton) 
		{
		    PerfmonPlugin.DBG.info("Cancel selected");
			success = false;
			thisshell.close();
		}		
	}  

	public void keyPressed(KeyEvent e)
	{
		if (e.keyCode == 13)
		{
		    widgetSelected(okbutton);
		}
		else if (e.keyCode == 27)
		{
		    widgetSelected(cancelbutton);
		}
	}

	public void keyReleased(KeyEvent e)
	{	
	}
	
	public String getPort()
	{
	    return return_port;
	}
	
	public String getRacHost()
	{
	    return return_rac_host;
	}
	
	public String getJonasHost()
	{
	    return return_jonas_host;
	}
}