/**********************************************************************
 * Copyright (c) 2003,2004 Scapa Technologies Limited and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.perfmon.utils.internal;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.hyades.trace.internal.ui.PDPerspective;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.swt.widgets.Display;

public class LauncherUtils {

	/**
	 * Open Profiling Monitor view
	 */
	public static void openProfilingView() {
		
        Display.getDefault().syncExec(new Runnable() {
        	public void run() {
        		try{
        			UIPlugin.getActivePage().showView(PDPerspective.ID_PD_NAVIGATOR_VIEW);
        		} catch (Exception exc) {
        			exc.printStackTrace();
        		}
        	}
        });
	}

	public static Resource createResource(URI uri) {

		ResourceSet resourceSet = new ResourceSetImpl();
		Resource resource = resourceSet.getResource(uri,false);
		if (resource == null) return resourceSet.createResource(uri);
		return resource;		
	}
	
}