/**********************************************************************
 * Copyright (c) 2003,2004 Scapa Technologies Limited and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.perfmon.utils.internal;

import java.io.IOException;
import java.util.Collections;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.models.hierarchy.*;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.trace.internal.ui.PDContentProvider;
import org.eclipse.hyades.trace.ui.UIPlugin;

import org.eclipse.hyades.statistical.ui.*;
import org.eclipse.swt.widgets.Display;
import org.eclipse.emf.common.util.URI;

import org.eclipse.hyades.perfmon.*;

import org.eclipse.emf.ecore.*;

public class TRCAgentUtil {

	/**
	 * Get the parent URI for a particular URI
	 * @param uri
	 * @return the URI representing the parent of the hierarchical URI
	 */
	public static URI getParentURI(URI uri) {
		return uri.trimSegments(1);
	}
	
	
	static HierarchyFactory hfactory = HierarchyFactory.eINSTANCE;
	
	private static void createHierarchyComponent(URI uri, EObject instance) {

		EditorPlugin.DBG.info("Creating new Hierarchy component at "+uri);

		ResourceSet resourceSet = HierarchyResourceSetImpl.getInstance();
		Resource monitorResource = null;

		monitorResource = resourceSet.createResource(uri);
		EditorPlugin.DBG.info("had to create new Hierachy resource");

//		monitorroot = hfactory.createTRCMonitor();
//		String mname = monitor_uri.toString();
//		mname = mname.substring(mname.lastIndexOf("/")+1);
//		mname = mname.substring(0,mname.length()-".trcmxmi".length());
//		monitorroot.setName(mname);

		try {
			monitorResource.getContents().add(instance);
		} catch (Exception x) {
			EditorPlugin.DBG.error("problem adding to monitor resource",x);
		}
	}
	
	private static Object getHierarchyComponent(URI uri, Class type) {
		
		EditorPlugin.DBG.info("Fetching Hierarchy at "+uri);

		ResourceSet resourceSet = HierarchyResourceSetImpl.getInstance();
		Resource monitorResource = null;

		try {
			monitorResource = resourceSet.getResource(uri,true);
			EditorPlugin.DBG.info("got Hierarchy resource OK");

			EList resources = monitorResource.getContents();
			for (int i = 0; i < resources.size(); i++) {
				Object o = resources.get(i);
				if (type.isAssignableFrom(o.getClass())) {
					EditorPlugin.DBG.info("got Hierarchy component OK ("+type.getName()+")");
					return o;
				}
			}
			
		} catch (Exception e) {
			EditorPlugin.DBG.info("Hierarchy not found at "+uri);
		}
		
		return null;
	}
	
	private static void createResources(TRCAgent agent, URI monitorURI, URI nodeURI, URI processURI, URI agentURI) throws IOException {

		ResourceSet resourceSet = HierarchyResourceSetImpl.getInstance();

		Resource monitorResource = null;
		Resource nodeResource = null;
		Resource processResource = null;
		Resource agentResource = null;

		try {
			monitorResource = resourceSet.getResource(monitorURI,true);
			EditorPlugin.DBG.info("got TRCMonitor resource OK");
		} catch (Exception e) {
			monitorResource = resourceSet.createResource(monitorURI);
			EditorPlugin.DBG.info("created TRCMonitor resource OK");
		}
		try {
			nodeResource = resourceSet.getResource(nodeURI,true);
			EditorPlugin.DBG.info("got TRCNode resource OK");
		} catch (Exception e) {
			nodeResource = resourceSet.createResource(nodeURI);
			EditorPlugin.DBG.info("created TRCNode resource OK");
		}
		try {
			processResource = resourceSet.getResource(processURI,true);
			EditorPlugin.DBG.info("got TRCProcessProxy resource OK");
		} catch (Exception e) {
			processResource = resourceSet.createResource(processURI);
			EditorPlugin.DBG.info("created TRCProcessProxy resource OK");
		}
		try {
			agentResource = resourceSet.getResource(agentURI,true);
			EditorPlugin.DBG.info("got TRCAgent resource OK");
		} catch (Exception e) {
			agentResource = resourceSet.createResource(agentURI);
			EditorPlugin.DBG.info("created TRCAgent resource OK");
		}

		try {
			monitorResource.getContents().add(agent.getAgentProxy().getProcessProxy().getNode().getMonitor());
		} catch (Exception e) {
			EditorPlugin.DBG.error("problem adding to monitor resource");
		}
		try {
			nodeResource.getContents().add(agent.getAgentProxy().getProcessProxy().getNode());
		} catch (Exception e) {
			EditorPlugin.DBG.error("problem adding to node resource");
		}
		try {
			processResource.getContents().add(agent.getAgentProxy().getProcessProxy());
		} catch (Exception e) {
			EditorPlugin.DBG.error("problem adding to process resource");
		}
		agentResource.getContents().add(agent);
		
/*
		ResourceSet resourceSet = HierarchyResourceSetImpl.getInstance();

		Resource monitorResource = resourceSet.createResource(monitorURI);
		Resource nodeResource = resourceSet.createResource(nodeURI);
		Resource processResource = resourceSet.createResource(processURI);
		Resource agentResource = resourceSet.createResource(agentURI);

		monitorResource.getContents().add(monitor);
		nodeResource.getContents().add(agent.getAgentProxy().getProcessProxy().getNode());
		processResource.getContents().add(agent.getAgentProxy().getProcessProxy());
		agentResource.getContents().add(agent);
*/		
	
	}
	
	public static void saveTRCAgent(TRCAgent agent) throws IOException {
		agent.getAgentProxy().getProcessProxy().getNode().getMonitor().eResource().save(Collections.EMPTY_MAP);
		agent.getAgentProxy().getProcessProxy().getNode().eResource().save(Collections.EMPTY_MAP);
		agent.getAgentProxy().getProcessProxy().eResource().save(Collections.EMPTY_MAP);
		agent.eResource().save(Collections.EMPTY_MAP);
	}

	/**
	 * Create (or get) a TRCAgent
	 * @param project_uri the URI of the project the TRCAgent is to be created in (will be created if necessary)
	 * @param monitor_uri the URI of the TRCMonitor (may be null in which case one will be created)
	 * @param node_uri the URI of the TRCNode (may be null in which case one will be created)
	 * @param process_uri the URI of the TRCProcessProxy (may be null in which case one will be created)
	 * @param agent_uri the URI of the TRCAgent (may be null in which case one will be created)
	 * @param filename the name of any newly created resources (e.g. 'MyAgent-<timestamp>')
	 * @param monitor_name the name of any newly created TRCMonitor
	 * @param node_name the name of any newly created TRCNode
	 * @param process_name the name of any newly created TRCProcessProxy
	 * @param agent_name the name of any newly created TRCAgent
	 * @param agent_type the type of any newly created TRCNode
	 * @return the newly created TRCAgent
	 */
	public static TRCAgent newAgent(URI project_uri, 
									URI monitor_uri, 
									URI node_uri, 
									URI process_uri, 
									URI agent_uri, 
									String filename,
									String monitor_name,
									String node_name,
									String process_name,
									String agent_name,
									String agent_type) throws IOException {

		createContainer(project_uri);
		
		if (agent_type == null) agent_type = "Profiler";
		
		TRCMonitor monitorroot;
		TRCNode noderoot;
		TRCProcessProxy pproxyroot;
		TRCAgentProxy aproxyroot;
		TRCAgent agentroot;
		
		boolean new_monitor = false;
		
		//
		// Create the URIs for the resources
		//
		IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();			
		IPath path = null;

		if (monitor_uri == null) {
			path = new Path(project_uri+"/"+filename+".trcmxmi"); 
			monitor_uri = URI.createPlatformResourceURI(workspaceRoot.getFile(path).getProjectRelativePath().toString());
		}

		if (node_uri == null) {
			path = new Path(project_uri+"/"+filename+".trcnxmi"); 
			node_uri = URI.createPlatformResourceURI(workspaceRoot.getFile(path).getProjectRelativePath().toString());
		}
		
		if (process_uri == null) {				
			path = new Path(project_uri+"/"+filename+".trcpxmi"); 
			process_uri = URI.createPlatformResourceURI(workspaceRoot.getFile(path).getProjectRelativePath().toString());
		}

		if (agent_uri == null) {
			path = new Path(project_uri+"/"+filename+".trcaxmi"); 
			agent_uri = URI.createPlatformResourceURI(workspaceRoot.getFile(path).getProjectRelativePath().toString());				
		}
		
		//TRCMonitor setup
		monitorroot = (TRCMonitor)getHierarchyComponent(monitor_uri,TRCMonitor.class);
		if (monitorroot == null) {
			new_monitor = true;
			monitorroot = hfactory.createTRCMonitor();
			monitorroot.setName(monitor_name);
			monitorroot.setStartTime(System.currentTimeMillis());
			createHierarchyComponent(monitor_uri,monitorroot);
		}
		
		//TRCNode setup
		noderoot = (TRCNode)getHierarchyComponent(node_uri,TRCNode.class);
		if (noderoot == null) {
			noderoot = hfactory.createTRCNode();
			noderoot.setMonitor(monitorroot);
			noderoot.setName(node_name);
			noderoot.setRuntimeId("unknown");
			noderoot.setTimezone(0);
			createHierarchyComponent(node_uri,noderoot);
		}
		
		//TRCProcessProxy setup			
		pproxyroot = (TRCProcessProxy)getHierarchyComponent(process_uri,TRCProcessProxy.class);
		if (pproxyroot == null) {
			pproxyroot = hfactory.createTRCProcessProxy();
			pproxyroot.setNode(noderoot);
			noderoot.getProcessProxies().add(pproxyroot);
			pproxyroot.setActive(true);
//setting the PID here creates a new process for some reason			
//			pproxyroot.setPid(-1);
			pproxyroot.setName(process_name);
			createHierarchyComponent(process_uri,pproxyroot);
		}
		
		//TRCAgent setup
		agentroot = (TRCAgent)getHierarchyComponent(agent_uri,TRCAgent.class);
		if (agentroot == null) {
			//TRCAgent
			agentroot = hfactory.createTRCAgent();
			agentroot.setName(agent_name);
			agentroot.setType(agent_type);
			createHierarchyComponent(agent_uri,agentroot);
			
			//TRCAgentProxy setup
			aproxyroot = hfactory.createTRCAgentProxy();
			aproxyroot.setProcessProxy(pproxyroot);
			pproxyroot.getAgentProxies().add(aproxyroot);
			aproxyroot.setActive(true);
			aproxyroot.setAttached(true);
			aproxyroot.setMonitored(true);
			aproxyroot.setType(agent_type);//should this be "Profiler"?
			aproxyroot.setName(agent_name);

			//TRCAgent
			agentroot.setAgentProxy(aproxyroot);
		} else {
			aproxyroot = agentroot.getAgentProxy();
		}
		

		HierarchyResourceSetImpl resourceSet = HierarchyResourceSetImpl.getInstance();

//		URI project_uri = statcon.getCurrentProjectURI();
		String project_path = project_uri.toString().replaceFirst("platform:/resource/", "");
		IPath temp = new Path(project_path.toString().replaceFirst("platform:/resource/", "")); 
		
		try {
			createResources(agentroot,monitor_uri,node_uri,process_uri,agent_uri);
		}catch (Exception e) {
			e.printStackTrace();
		}
	
		saveTRCAgent(agentroot);
		
		try {
			MonitorViewUpdate update = new MonitorViewUpdate(monitorroot,new_monitor,temp);
			Display.getDefault().syncExec(update);
		} catch (Exception e) {
			e.printStackTrace();
		}

		return agentroot;
	}
	
	private static class MonitorViewUpdate implements Runnable {
		IPath temp;
		boolean new_monitor = false;
		
		TRCMonitor monitor;
		
		public MonitorViewUpdate(TRCMonitor monitor, boolean new_monitor, IPath temp) {
			this.monitor = monitor;
			this.new_monitor = new_monitor;
			this.temp = temp;
		}
		
		public void run() {
			try {
				if (!new_monitor) {
					PDContentProvider.resetMonitors();
				} else {
					PDContentProvider.addMonitor(createContainer(temp), monitor);
				}
			} catch (Throwable e) {
				PerfmonPlugin.DBG.logVisibleError(e,PerfmonPlugin.getString("ERROR_UPDATE_PROFMON"),true);
//			} catch (Throwable e) {
//				EditorPlugin.DBG.error("ERROR UPDATING MONITOR VIEW",e);
			}
		}
	}
	
	private static final IContainer createContainer(URI uri) {
		String path = uri.toString().replaceFirst("platform:/resource/", "");
		IPath ipath = new Path(path.toString().replaceFirst("platform:/resource/", "")); 
		return createContainer(ipath);
	}

    private static final IContainer createContainer(IPath path) {
        IContainer container = null;
        IWorkspace workbench = UIPlugin.getPluginWorkbench();
        int segCount = path.segmentCount();

        for (int idx = 0; idx < segCount; idx++) {
            String seg = path.segment(idx);

            if (idx == 0) { //project

                IProject project = workbench.getRoot().getProject(path.uptoSegment(idx + 1).toString());

                if ((project == null) || !project.exists()) { //create the project
                	
                	//might be a case problem
	                IProject[] projects = workbench.getRoot().getProjects();
	                for (int k = 0; k < projects.length; k++) {
	                	if (projects[k].getName().equalsIgnoreCase(seg)) {
	                		project = projects[k];
	                	}
					}
                }
                
                if ((project == null) || !project.exists()) { //create the project

                    try {
                        project.create(null);
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                try {
                    project.open(null);
                } catch (Exception e) {
                }

                container = project;
            } else // (idx > 1)
             { //folder

                IFolder folder = workbench.getRoot().getFolder(path.uptoSegment(idx + 1));

                if ((folder == null) || !folder.exists()) { //create the folder

                    try {
                        folder.create(false, true, null);
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                container = folder;
            }
        }

        try {
            container.getProject().refreshLocal(IResource.DEPTH_INFINITE, null);
        } catch (CoreException exc) {
            exc.printStackTrace();
        }

        return container;
    }
}