/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.common.internal.wizard;

import java.util.Iterator;

import org.eclipse.core.resources.IFile;
import org.eclipse.ui.PartInitException;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.facades.behavioral.impl.HyadesFactory;
import org.eclipse.hyades.models.common.util.ICommonConstants;
import org.eclipse.hyades.test.ui.TestUI;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.ui.internal.util.JavaUtil;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.hyades.ui.internal.wizard.HyadesNewWizard;

/**
 * Extends the HyadesNewWizard to create a Test Suite.
 * 
 * @author marcelop
 * @since 1.0.2
 */
abstract public class TestSuiteNewWizard 
extends HyadesNewWizard
{
	/**
	 * Constructor for TestSuiteNewWizard
	 */
	public TestSuiteNewWizard()
	{
		super();
	}

	/**
	 * Returns the type for the test suite created by this wizard.
	 * @return String
	 */
	abstract protected String getType();
	
	/**
	 * @see org.eclipse.hyades.ui.internal.wizard.HyadesNewWizard#getFileExtension()
	 */
	protected String getFileExtension()
	{
		return ICommonConstants.TEST_SUITE_FILE_EXTENSION;
	}

	/**
	 * @see org.eclipse.jface.wizard.IWizard#addPages()
	 */
	public void addPages()
	{
		addPage(getLocationPage());
		addPage(getAttributeWizardPage());
	}
	
	/**
	 * @see org.eclipse.hyades.ui.test.internal.wizard.HyadesNewWizard#createObject(org.eclipse.core.resources.IFile)
	 */
	protected boolean createObject(IFile file)
	throws Exception
	{
		Resource resource = createResource(file);
		createObject(resource);
		for (Iterator i = resource.getResourceSet().getResources().iterator(); i.hasNext();)
			EMFUtil.save((Resource)i.next());
		return true;
	}
	
	/**
	 * Creates the Object setting the attributes based on the information
	 * the user has defined in this wizard's pages.
	 * @param resource
	 */
	protected void createObject(Resource resource)
	{
		ITestSuite testSuite = HyadesFactory.INSTANCE.createTestSuite(resource);
		testSuite.setType(getType());
		testSuite.setName(getAttributeWizardPage().getItemName());
		
		String description = getAttributeWizardPage().getItemDescription();
		if((description != null) && (description.trim().length() > 0))
			testSuite.setDescription(description);
			
		if(testSuite.getImplementor() == null)
			HyadesFactory.INSTANCE.createImplementor(testSuite, false);
		
		registerResource(testSuite);	
	}
	
	protected void registerResource(ITestSuite testSuite)
	{
		String clsName = JavaUtil.getValidClassName(testSuite.getName(), true);
		if(clsName == null)
			clsName = "Test";
		testSuite.getImplementor().setResource("test." + clsName);
	}
	
	/**
	 * Creates the EMF resource in which the object is added to.
	 * @return a not null Resource
	 */
	protected Resource createResource(IFile file)
	{
		ResourceSet resourceSet = new ResourceSetImpl();
		URI uri = URI.createPlatformResourceURI(file.getFullPath().toString());
		return resourceSet.createResource(uri);
	}

		
	/**
	 * @see org.eclipse.hyades.ui.internal.wizard.HyadesNewWizard#openEditor(org.eclipse.core.resources.IFile)
	 */
	protected void openEditor(IFile file) 
	throws PartInitException
	{
		if(TestUIPlugin.getInstance().getPreferenceStore().getBoolean(TestUI.OPEN_EDITOR))
			UIUtil.openEditor(file, TestUIExtension.GENERIC_TEST_SUITE_EDITOR_PART_ID, false);
	}	
}
