/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.execution.trace.util;


/**
 * This is the record for method definition.  For up-to-date descriptions of the tag attributes,
 * see Event Specification for the Java Profiler at <code>http://www.eclipse.org/hyades</code>.
 * 
 * @author Richard Duggan, Qiyan Li
 */
public class RecordMethodDef {

    /**
     * the number of records to provide a unique method ID
     */
    private static int _numberRecords = 0;

    private final String name;
    private final String signature;
    private String visibility = null;
    private String isNative = null;
    private String isAbstract = null;
    private String isStatic = null;
    private String isSynchronized = null;
    private String exceptions = null;
    private int startLineNumber = 0;
    private int endLineNumber = 0;
    private String signitureNotation = null;
    private int transcientClassIdRef = 0;
    private final int classIdRef;
    private final int methodId;
    private String collationValue = null;
    private String traceIdRef = null;


    /**
     * Creates a record for this method definition with a unique ID.
     * 
     * @param name          the name of the method
     * @param signature     the method signature in JNI notation
     * @param classIdRef    the unique identifier of the class to which this method belongs
     */
    public RecordMethodDef(String name, String signature, int classIdRef) {

        /* Obtain a unique ID for this object. */
        synchronized(this.getClass()) {
            methodId = ++_numberRecords;
        }

        /* Each method is uniquely identified by its name, signature, and class. */
        this.name = name;
        this.signature = signature;
        this.classIdRef = classIdRef;
    }

    /**
     * Converts this record into a string.
     * 
     * @return  this record as a string 
     */
    public String toString() {

        return "<methodDef name=\"" + name + "\" signature=\"" + signature +
               "\" classIdRef=\"" + classIdRef + "\" methodId=\"" + methodId + "\"" +
               (visibility == null ? "" : " visibility=\"" + visibility + "\"") +
               (isNative == null ? "" : " isNative=\"" + isNative + "\"") +
               (isAbstract == null ? "" : " isAbstract=\"" + isAbstract + "\"") +
               (isStatic == null ? "" : " isStatic=\"" + isStatic + "\"") +
               (isSynchronized == null ? "" : " isSynchronized=\"" + isSynchronized + "\"") +
               (exceptions == null ? "" : " exceptions=\"" + exceptions + "\"") +
               (startLineNumber == 0 ? "" : " startLineNumber=\"" + startLineNumber + "\"") +
               (endLineNumber == 0 ? "" : " endLineNumber=\"" + endLineNumber + "\"") +
               (signitureNotation == null ? "" : " signitureNotation=\"" + signitureNotation + "\"") +
               (transcientClassIdRef == 0 ? "" : " transcientClassIdRef=\"" + transcientClassIdRef + "\"") +
               (collationValue == null ? "" : " collationValue=\"" + collationValue + "\"") +
               (traceIdRef == null ? "" : " traceIdRef=\"" + traceIdRef + "\"") + "/>";
    }


    public int getClassIdRef() {
        return classIdRef;
    }


    public String getCollationValue() {
        return collationValue;
    }


    public int getEndLineNumber() {
        return endLineNumber;
    }



    public String getExceptions() {
        return exceptions;
    }


    public String getIsAbstract() {
        return isAbstract;
    }


    public String getIsNative() {
        return isNative;
    }


    public String getIsStatic() {
        return isStatic;
    }


    public String getIsSynchronized() {
        return isSynchronized;
    }


    public int getMethodId() {
        return methodId;
    }


    public String getName() {
        return name;
    }


    public String getSignature() {
        return signature;
    }


    public String getSignitureNotation() {
        return signitureNotation;
    }


    public int getStartLineNumber() {
        return startLineNumber;
    }


    public String getTraceIdRef() {
        return traceIdRef;
    }


    public int getTranscientClassIdRef() {
        return transcientClassIdRef;
    }


    public String getVisibility() {
        return visibility;
    }


    public void setCollationValue(String collationValue) {
        this.collationValue = collationValue;
    }


    public void setEndLineNumber(int endLineNumber) {
        this.endLineNumber = endLineNumber;
    }


    public void setExceptions(String exceptions) {
        this.exceptions = exceptions;
    }


    public void setIsAbstract(String isAbstract) {
        this.isAbstract = isAbstract;
    }


    public void setIsNative(String isNative) {
        this.isNative = isNative;
    }


    public void setIsStatic(String isStatic) {
        this.isStatic = isStatic;
    }


    public void setIsSynchronized(String isSynchronized) {
        this.isSynchronized = isSynchronized;
    }


    public void setSignitureNotation(String signitureNotation) {
        this.signitureNotation = signitureNotation;
    }


    public void setStartLineNumber(int startLineNumber) {
        this.startLineNumber = startLineNumber;
    }


    public void setTraceIdRef(String traceIdRef) {
        this.traceIdRef = traceIdRef;
    }


    public void setTranscientClassIdRef(int transcientClassIdRef) {
        this.transcientClassIdRef = transcientClassIdRef;
    }


    public void setVisibility(String visibility) {
        this.visibility = visibility;
    }
}
