/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.log.ui.internal.util;

import org.eclipse.emf.ecore.EObject;

/**
 * Wrapper class used to mark a containment by reference in the log tree viewer
 * 
 * @see LogContentProvider
 *  
 */
public class TerminalNode {

	private EObject parent;
	private Object treeParent;
	private String description;
	
	/**
	 * Constructor for TerminalNode.
	 */
	public TerminalNode(Object treeParent, EObject parent, String description) {
		this.parent = parent;
		this.treeParent = treeParent;
		this.description = description;
	}

	/**
	 * Returns the description used as label in the UI for the current TerminalNode
	 * @return String
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * Returns the parent, i.e. the association target
	 * @return EObject
	 */
	public EObject getParent() {
		return parent;
	}
	
	public Object getTreeParent() {
		return treeParent;
	}
	
	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object arg0) {

		if(arg0 instanceof TerminalNode){
			if(((TerminalNode)arg0).getTreeParent().equals(treeParent) &&((TerminalNode)arg0).getParent().equals(parent) && ((TerminalNode)arg0).getDescription().equals(description)){
				return true;	
			}
			else{
				return false;
			}
		
		}
		return super.equals(arg0);		
	}
	
	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	public int hashCode() {

		return description.hashCode();
	}
 
}
