/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.views;

import java.util.*;

import org.eclipse.core.runtime.*;
import org.eclipse.hyades.analysis.engine.ILogAnalyzer;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.models.cbe.CBEDefaultEvent;

public class ExtensionPointHandler {

	private static ExtensionPointHandler inst;
	private Hashtable analyzerList = new Hashtable();

	public ExtensionPointHandler() {
		inst = this;
		populateAnalyzerList();
	}
	public static ExtensionPointHandler getExtensionPointHandler() {
		
		if(inst == null)
		   inst = new ExtensionPointHandler();
		   
		return inst;
	}
	
	/**
	 * Returns a boolean which specifies if a log analyzer applying to @param record is defined.
	 */ 
	
	public boolean analyzerDefinedFor(Object record) {

		List list = null;
		if(record instanceof CBECommonBaseEvent){
			list = (List)analyzerList.get("CommonBaseEvent");			
			if(list!=null){
				return true;
			}else{
				list = (List)analyzerList.get("DefaultEvent");
				if(list!=null){
					return true;
				}
			}
			
		}else if(record instanceof CBEDefaultEvent){
			return analyzerList.get("DefaultEvent")!=null;
		}
		return false;
	}

	/**
	 * Returns the list of log analyzers contributed to the extension point org.eclipse.hyades.analysis.engine.logAnalyzer applying to @param record.
	 */ 
	
	public List getLogAnalyzer(Object record) {
		
		List list = null;
		if(record instanceof CBECommonBaseEvent){
			List cbeList = (List)analyzerList.get("CommonBaseEvent");
			List deList = (List)analyzerList.get("DefaultEvent");			
			if(cbeList==null){
				list = deList; 	
			}
			else if(deList!=null){
				list = new ArrayList();
				list.addAll(deList);				
				list.addAll(cbeList);
			}
			
		}else
		if(record instanceof CBEDefaultEvent){
			list = (List)analyzerList.get("DefaultEvent");
		}
		return list;
	}
	
	/**
	 * Returns the list of log analyzers contributed to the extension point org.eclipse.hyades.analysis.engine.logAnalyzer.
	 */ 
	
	public List getLogAnalyzers(){
		List list = null;
		List cbeList = (List)analyzerList.get("CommonBaseEvent");
		List deList = (List)analyzerList.get("DefaultEvent");			
		if(cbeList==null){
			list = deList; 	
		}
		else if(deList!=null){
			list = new ArrayList();
			list.addAll(deList);			
			list.addAll(cbeList);
		}
		return list!=null?list:Collections.EMPTY_LIST;
	}
	
	/**
	 * Populates the org.eclipse.hyades.analysis.engine.logAnalyzer extension point elements list.
	 */ 
	public void populateAnalyzerList() {
		try {
			//Get configured source generators
			ILogAnalyzer aLogAnalyzer = null;
			String type = null;
			String name = null;

	        IConfigurationElement[] extensionList = Platform.getExtensionRegistry()
			       .getConfigurationElementsFor("org.eclipse.hyades.analysis.engine", "logAnalyzer");			

			List list = null;
			//get all analyzers once here, and store them in a hashtable
			for (int i = 0; i < extensionList.length; i++) {
				type = extensionList[i].getAttribute("type");
				if(type==null)
					continue;

				Class clsType = Class.forName(type);
				aLogAnalyzer =
					(ILogAnalyzer) (extensionList[i].createExecutableExtension("class"));
				if(aLogAnalyzer==null)
					continue;
				name = extensionList[i].getAttribute("name");
				if(name==null)
					name = LogUIPlugin.getResourceBundle().getString("UNKNOWN_LABEL");
				list = (List) getList(clsType);
				if(list==null){	
					list = new ArrayList();
					list.add(new ConfigurationElement(name, aLogAnalyzer));	
					casheList(clsType, list);
				}
				else{
					list.add(new ConfigurationElement(name, aLogAnalyzer));
				}
			}
		} catch (Exception e) {
			LogUIPlugin.log(e);
			e.printStackTrace();
		}
	}
	
	private void casheList(Class clsType, List list){
		if(clsType==CBECommonBaseEvent.class)	
			analyzerList.put("CommonBaseEvent", list);				
		else if (clsType==CBEDefaultEvent.class){
			analyzerList.put("DefaultEvent", list);		
		}
	}
	
	private List getList(Class clsType){
		List list = null;
		if(clsType==CBECommonBaseEvent.class)	
			list = (List)analyzerList.get("CommonBaseEvent");				
		else if (clsType==CBEDefaultEvent.class){
			list = (List)analyzerList.get("DefaultEvent");		
		}
		
		return list;
	
	}
	
	public void dispose(){
		analyzerList.clear();		
		inst = null;
	}
	/*
	 * 
	 * Helper class used to cache an extension point element
	 * @author apnan
	 */
	public class ConfigurationElement{
		private String name;
		private ILogAnalyzer analyzer;
		public ConfigurationElement(String name, ILogAnalyzer analyzer){		
			this.name = name;
			this.analyzer = analyzer;
		}
		
		
		/**
		 * @return ILogAnalyzer element
		 */
		public ILogAnalyzer getAnalyzer() {
			return analyzer;
		}

		/**
		 * @return String name
		 */
		public String getName() {
			return name;
		}

	}
	
}