/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.views;

import java.lang.reflect.Method;
import java.util.List;

import org.eclipse.hyades.analysis.engine.IAnalysisMonitor;
import org.eclipse.hyades.analysis.engine.ILogAnalyzer;

/**
 * @author apnan
 *
 */
public class LogAnalyzerWrapper implements ILogAnalyzer{
	
	ILogAnalyzer analyzer;
	
	public LogAnalyzerWrapper(ILogAnalyzer analyzer){
		this.analyzer = analyzer;
	}
	
	public void analyze(Object object, List result, IAnalysisMonitor monitor){			
		if(analyzer!=null){	
			Method method = null;
			try{	
				method = analyzer.getClass().getMethod("analyze", new Class[]{Object.class, List.class, IAnalysisMonitor.class});
			}catch(Exception e){
			}
			if(method!=null){
				try{	
					method.invoke(analyzer, new Object[]{object,result,monitor});
				}catch(Exception e){					
				}
			}
			else{
				analyzer.analyze(object, monitor);
			}
		}
	}
		
	public String analyze(Object aObject, IAnalysisMonitor monitor) {
		if(analyzer!=null)
			return analyzer.analyze(aObject, monitor);
		return null;
	}

	public String errorMsg() {
		if(analyzer!=null)
			return analyzer.errorMsg();
		return null;
	}

	public void loadDatabase() {
		if(analyzer!=null)	
			analyzer.loadDatabase();

	}

	public void unloadDatabase() {
		if(analyzer!=null)
			analyzer.unloadDatabase();
	}
}
