/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.log.ui.internal.wizards;

import java.io.UnsupportedEncodingException;
import java.util.Hashtable;

import org.eclipse.hyades.internal.logging.core.XmlGenerator;
import org.eclipse.hyades.loaders.util.XMLLoader;
import org.apache.commons.logging.Log;
import org.eclipse.hyades.logging.parsers.LogParserException;
import org.eclipse.hyades.logging.parsers.Parser;

public class LocalLogParserLoader implements Log {
    //~ Instance fields ----------------------------------------------------------------------------

    private Hashtable parserParameters = null;
    private Parser parser = null;
    private XmlGenerator xmlGenerator = new XmlGenerator();

    //NOTE: Temporary XMLLoader to propagate logged raw objects to the model as XML strings:
    private XMLLoader xmlLoader = null;
    private boolean first = true;
    
	/**
	 * Trace logging level value.
	 */
	public static final int TRACE_LEVEL = 0;

	/**
	 * Debug logging level value.
	 */
	public static final int DEBUG_LEVEL = 1;

	/**
	 * Information logging level value.
	 */
	public static final int INFO_LEVEL = 2;

	/**
	 * Warning logging level value.
	 */
	public static final int WARN_LEVEL = 3;

	/**
	 * Error logging level value.
	 */
	public static final int ERROR_LEVEL = 4;

	/**
	 * Fatal logging level value.
	 */
	public static final int FATAL_LEVEL = 5;

	/**
	 * The logger's current logging level value.
	 */
	private int loggingLevel;

    //~ Constructors -------------------------------------------------------------------------------

    public LocalLogParserLoader(Parser parser, Hashtable parserParameters) {
        this.parser = parser;
        this.parserParameters = parserParameters;
        loggingLevel=0;
        xmlGenerator.reset(null, true, 8);
    }

    //~ Methods ------------------------------------------------------------------------------------

    //NOTE: Temporary API to propagate logged raw objects to the model as XML strings:
    public void setXMLLoader(XMLLoader xmlLoader) {
        this.xmlLoader = xmlLoader;
    }

    public void startParsing() throws LogParserException {
        parser.setUserInput(parserParameters);

        parser.parse(this);
    }


    //NOTE: Temporary API to propagate logged raw objects to the model as XML strings:
    private void logXMLToModel(String xml) {
        // Note:  The com.ibm.xml.b2b.level0.L0DocumentEventHandler (com.ibm.etools.perftrace.loader.XMLLoader) XML scanner MUST be passed UTF8 encoded byte array data:
        byte[] xmlLogEntryBytes = null;

        try {
            xmlLogEntryBytes = xml.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException u) {
            xmlLogEntryBytes = xml.getBytes();
        }

        //		System.err.println(xml);
        xmlLoader.loadEvent(xmlLogEntryBytes, xmlLogEntryBytes.length);
    }
    
	/**
	 * Logs the parameter <code>java.lang.Object</code> log record to the Logging Agent 
	 * with the same name as the logger if TRACE logging is currently enabled.  
	 * 
	 * The log record is first converted to XML and then sent to the Logging Agent.
	 * 
	 * @param record The log record to be logged to the Logging Agent.
	 */

	
    
	public boolean isTraceEnabled() {
		return (loggingLevel<=TRACE_LEVEL);
	}

	public boolean isDebugEnabled() {
		return (loggingLevel<=DEBUG_LEVEL);
	}


	public boolean isInfoEnabled() {
		return (loggingLevel<=INFO_LEVEL);
	}

	public boolean isWarnEnabled() {
		return (loggingLevel<=WARN_LEVEL);
	}

	public boolean isErrorEnabled() {
		return (loggingLevel<=ERROR_LEVEL);
	}

	public boolean isFatalEnabled() {
		return (loggingLevel<=FATAL_LEVEL);
	}

	public void trace(Object record) {
//		try {
			if (isTraceEnabled()) {
				logXMLToModel(xmlGenerator.objectToXML(record));
			}
//		}
//		catch (Throwable t) {
//		}

	}

	public void trace(Object record, Throwable throwable) {
//		try {
			if (isTraceEnabled()) {
				logXMLToModel(xmlGenerator.objectToXML(record));
			}
//		}
//		catch (Throwable t) {
//		}

	}

	public void debug(Object record) {
//		try {
			if (isDebugEnabled()) {
				logXMLToModel(xmlGenerator.objectToXML(record));
			}
//		}
//		catch (Throwable t) {
//		}

	}

	public void debug(Object record, Throwable throwable) {
//		try {
			if (isDebugEnabled()) {
				logXMLToModel(xmlGenerator.objectToXML(record));
			}
//		}
//		catch (Throwable t) {
//		}

	}

	public void info(Object record) {
//		try {
			if (isInfoEnabled()) {
				logXMLToModel(xmlGenerator.objectToXML(record));
			}
//		}
//		catch (Throwable t) {
//		}

	}

	public void info(Object record, Throwable throwable) {

//		try {
			if (isInfoEnabled()) {
				logXMLToModel(xmlGenerator.objectToXML(record));
			}
//		}
//		catch (Throwable t) {
//		}
	}


	public void warn(Object record) {
//		try {
			if (isWarnEnabled()) {
				logXMLToModel(xmlGenerator.objectToXML(record));
			}
//		}
//		catch (Throwable t) {
//		}
	}

	public void warn(Object record, Throwable throwable) {
//		try {
			if (isWarnEnabled()) {
				logXMLToModel(xmlGenerator.objectToXML(record));
			}
//		}
//		catch (Throwable t) {
//		}
	}

	public void error(Object record) {
//		try {
			if (isErrorEnabled()) {
				logXMLToModel(xmlGenerator.objectToXML(record));
			}
//		}
//		catch (Throwable t) {
//		}
	}

	public void error(Object record, Throwable throwable) {

//		try {
			if (isErrorEnabled()) {
				logXMLToModel(xmlGenerator.objectToXML(record));
			}
//		}
//		catch (Throwable t) {
//		}
	}


	public void fatal(Object record) {
//		try {
			if (isFatalEnabled()) {
				logXMLToModel(xmlGenerator.objectToXML(record));
			}
//		}
//		catch (Throwable t) {
//		}
	}


	public void fatal(Object record, Throwable throwable) {

//		try {
			if (isFatalEnabled()) {
				logXMLToModel(xmlGenerator.objectToXML(record));
			}
//		}
//		catch (Throwable t) {
//		}
	}


}
   

