/*******************************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.editor.form.util;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofileFactory;
import org.eclipse.hyades.models.common.testprofile.TPFTestObjective;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.editor.extension.BaseEditorExtension;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormSection;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;



/**
 * @author bcormier
 * @since 3.0.0
 */
public class TestObjectiveSection extends FormSection implements ModifyListener {
    protected WidgetFactory widgetFactory;
    protected BaseEditorExtension baseEditorExtension;
    protected String testObjectiveReference;
    protected StyledText testObjectiveDescription;
    protected TPFTestSuite testSuite;
    
    //  TODO : make extensible
    private String[] types = {
            TestUIPlugin.getString("L_STRING_TYPE"),  //$NON-NLS-1$
            TestUIPlugin.getString("L_FILE_TYPE")}; //$NON-NLS-1$
    
    protected Composite typeComposite;
    protected CCombo type;
    
    /**
     * 
     */
    public TestObjectiveSection(BaseEditorExtension baseEditorExtension, WidgetFactory widgetFactory) {
        super();
        setWidgetFactory(widgetFactory);
        setBaseEditorExtension(baseEditorExtension);
    }

    /* (non-Javadoc)
     * @see org.eclipse.hyades.test.ui.internal.editor.form.base.FormSection#createClient(org.eclipse.swt.widgets.Composite, org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory)
     */
    public Composite createClient(Composite parent, FormWidgetFactory factory) {
        Composite detailComposite = getWidgetFactory().createComposite(parent);
        detailComposite.setLayout(new GridLayout(3, false));
        parent.setLayoutData(GridDataUtil.createHorizontalFill());
        
        getWidgetFactory().createLabel(detailComposite, TestUIPlugin.getString("L_TYPE")); //$NON-NLS-1$
        type = getWidgetFactory().createCCombo(detailComposite, SWT.SINGLE);
        type.setLayoutData(GridDataUtil.createHorizontalFill());
        for (int i=0; i<types.length; i++)
            type.add(types[i]);
        type.setEditable(false);
        
        typeComposite = getWidgetFactory().createComposite(detailComposite);
        GridData gd2 = new GridData(GridData.FILL_HORIZONTAL);
        gd2.horizontalSpan = 3;
        gd2.heightHint = 100;
        gd2.grabExcessHorizontalSpace = true;
        typeComposite.setLayoutData(gd2);

        
        type.addSelectionListener(new SelectionListener() {
            public void widgetSelected(SelectionEvent e) {
                Control[] children = typeComposite.getChildren();
                for (int i=0; i<children.length; i++) {
                    children[i].dispose();
                }
                createObjectiveControl(typeComposite, type.getSelectionIndex(), ""); //$NON-NLS-1$
            }
            public void widgetDefaultSelected(SelectionEvent e) {}
        });

		getWidgetFactory().paintBordersFor(detailComposite);
        return detailComposite;
    }
    
    protected void createObjectiveControl(Composite typeComposite, int typeIndex, String testObjectiveReference) {
        setTestObjectiveReference(testObjectiveReference);
        Control[] children = typeComposite.getChildren();
        for (int i=0; i<children.length; i++) {
            children[i].dispose();
        }
        switch (typeIndex) {
            case 0 :
                createStringObjective(typeComposite);
                break;
            case 1 :
                createFileObjective(typeComposite);
                break;
        }
	    if (testObjectiveDescription != null)
	        testObjectiveDescription.addModifyListener(this);
    }

    protected void createStringObjective(Composite typeComposite) {
        typeComposite.setLayout(new GridLayout());
        testObjectiveDescription = getWidgetFactory().createStyledText(typeComposite, SWT.FULL_SELECTION | SWT.MULTI | SWT.WRAP | SWT.V_SCROLL);
		GridData gridData = GridDataUtil.createHorizontalFill();
		gridData.heightHint = 4*testObjectiveDescription.getLineHeight();
		testObjectiveDescription.setLayoutData(gridData);
		testObjectiveDescription.setEditable(true);
		testObjectiveDescription.setText(getTestObjectiveReference());
        typeComposite.redraw();
        typeComposite.layout();
		getWidgetFactory().paintBordersFor(typeComposite);
    }

    protected void createFileObjective(Composite typeComposite) {
        typeComposite.setLayout(new GridLayout());
        testObjectiveDescription = getWidgetFactory().createStyledText(typeComposite, SWT.FULL_SELECTION | SWT.SINGLE);
        testObjectiveDescription.setLayoutData(GridDataUtil.createHorizontalFill());
        testObjectiveDescription.setEditable(true);
        testObjectiveDescription.setText(getTestObjectiveReference());
		
		Button btn = getWidgetFactory().createButton(typeComposite, TestUIPlugin.getString("BROWSE"), SWT.PUSH); //$NON-NLS-1$
		btn.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_END));
		btn.addSelectionListener(new SelectionListener() {
            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(new Shell());
                fd.open();
                IPath path = new Path(fd.getFilterPath()); 
                testObjectiveDescription.setText(path.addTrailingSeparator().toOSString() + fd.getFileName());
            }
            public void widgetDefaultSelected(SelectionEvent e) {}
        });

		typeComposite.redraw();
        typeComposite.layout();
		getWidgetFactory().paintBordersFor(typeComposite);
    }
    
	public void setInput(Object object)
	{
	    if (testObjectiveDescription != null)
	        testObjectiveDescription.removeModifyListener(this);

	    if (object instanceof TPFTestSuite) {
	        setTestSuite((TPFTestSuite)object);
	        EList testObjectives = getTestSuite().getTestObjectives();
	        if (testObjectives!=null 
	                && testObjectives.size()>0 
	                && testObjectives.get(0) instanceof TPFTestObjective) {
	            TPFTestObjective testObjective = (TPFTestObjective)testObjectives.get(0);
	            if (testObjective!=null) {
	                int index = getIndexFromType(testObjective.getType());
	                String objective  = testObjective.getReference();
	                if (index>-1 && objective!=null) {
	                    setTestObjectiveReference(objective);
	                    createObjectiveControl(typeComposite, index, getTestObjectiveReference());
	                    type.select(index);
	                }
	            }  
	        }
	    }
	    if (testObjectiveDescription != null)
	        testObjectiveDescription.addModifyListener(this);
	}
	
	protected int getIndexFromType(String type) {
	    for (int i=0; i<types.length; i++)
	        if (types[i].equals(type))
	            return i;
	    return -1;
	}
    
    /**
     * @return Returns the widgetFactory.
     */
    protected WidgetFactory getWidgetFactory() {
        return widgetFactory;
    }
    /**
     * @param widgetFactory The widgetFactory to set.
     */
    private void setWidgetFactory(WidgetFactory widgetFactory) {
        this.widgetFactory = widgetFactory;
    }
    /**
     * @return Returns the baseEditorExtension.
     */
    public BaseEditorExtension getBaseEditorExtension() {
        return baseEditorExtension;
    }
    /**
     * @param baseEditorExtension The baseEditorExtension to set.
     */
    private void setBaseEditorExtension(BaseEditorExtension baseEditorExtension) {
        this.baseEditorExtension = baseEditorExtension;
    }
    /**
     * @return Returns the testObjectiveReference.
     */
    public String getTestObjectiveReference() {
        return testObjectiveReference;
    }
    /**
     * @param testObjectiveReference The testObjectiveReference to set.
     */
    public void setTestObjectiveReference(String testObjectiveReference) {
        this.testObjectiveReference = testObjectiveReference;
    }
    
	/**
	 * 
	 * @see org.eclipse.swt.events.ModifyListener#modifyText(org.eclipse.swt.events.ModifyEvent)
	 */
	public void modifyText(ModifyEvent e)
	{
		if(e.widget == testObjectiveDescription)
		{
	        EList testObjectives = getTestSuite().getTestObjectives();
	        TPFTestObjective testObjective = null;
	        if (testObjectives!=null 
	                && testObjectives.size() == 1 
	                && testObjectives.get(0) instanceof TPFTestObjective)
	            testObjective = (TPFTestObjective)testObjectives.get(0);
	        
	        if (testObjective!=null) {
	            testObjective.setType(type.getText());
	            testObjective.setReference(testObjectiveDescription.getText());
	        } else {
	            testObjective = Common_TestprofileFactory.eINSTANCE.createTPFTestObjective();
	            testObjective.setType(type.getText());
	            testObjective.setReference(testObjectiveDescription.getText());
	            getTestSuite().getTestObjectives().add(testObjective);
	        }
			getBaseEditorExtension().markDirty();
		}
	}
    /**
     * Gets the test context to which this test objective belongs.
     * @return Returns the test context.
     */
    public TPFTestSuite getTestSuite() {
        return testSuite;
    }
    /**
     * Sets the test context to which this test objective belongs.
     * @param testSuite The test context to set.
     */
    public void setTestSuite(TPFTestSuite testSuite) {
        this.testSuite = testSuite;
    }
}
