/*******************************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form.util;

import java.util.Iterator;
import java.util.Vector;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.models.common.common.CommonPackage;
import org.eclipse.hyades.models.common.configuration.CFGArtifact;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormSection;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.model.IWorkbenchAdapter;

/**
 * This class implements the test suites section in deployment editor overview page.
 * 
 * @author bjiang
 * @since 3.0
 */
public class DeploymentTestSuitesSection extends FormSection
{
    public class DeploymentTestSuitesAdapter
    extends AdapterImpl implements IDisposable
    {
    	private EStructuralFeature feature;
    	private String statusLinePrefix;
    	private Composite parent;
    	private FormWidgetFactory widgetFactory;
    	
    	public DeploymentTestSuitesAdapter(EStructuralFeature feature, String statusLinePrefix, Composite parent, FormWidgetFactory factory)
    	{
    		this.feature = feature;
    		this.statusLinePrefix = statusLinePrefix;
    		this.parent = parent;
    		this.widgetFactory = factory;
    		
    		GridLayout gridLayout = new GridLayout();
    		gridLayout.numColumns = 2;
    		gridLayout.marginHeight = 0;
    		gridLayout.marginWidth = 0;
    		gridLayout.verticalSpacing = 2;
    		parent.setLayout(gridLayout);
    	}
    	
    	/**
    	 * @see org.eclipse.hyades.ui.util.IDisposable#dispose()
    	 */
    	public void dispose()
    	{
    		feature = null;
    		setTarget(null);
    	}

    	/**
    	 * @see org.eclipse.emf.common.notify.Adapter#notifyChanged(org.eclipse.emf.common.notify.Notification)
    	 */
    	public void notifyChanged(Notification msg)
    	{
    		if(msg.getFeature() != feature)
    			return;
    			
    		switch(msg.getEventType())
    		{
    			case Notification.ADD:
    			case Notification.ADD_MANY:
    			case Notification.REMOVE:
    			case Notification.REMOVE_MANY:
    			case Notification.MOVE:
    				refreshComposite((EObject)msg.getNotifier());
    				break;
    		}
    	}
    	
    	protected void refreshComposite(EObject notifier)
    	{
    		disposeChildren(this.parent);
    		
    		EList namedElements = (EList)notifier.eGet(feature);
    		Vector testSuites = new Vector();
    		for(Iterator i = namedElements.iterator(); i.hasNext(); )
    		{
    		    Object obj = i.next();
    		    if(obj instanceof CFGArtifact)
    		    {
    		        EList classes = ((CFGArtifact)obj).getDeployableInstances();
    		        for(Iterator clsIt = classes.iterator(); clsIt.hasNext(); )
    		        {
    		            Object cls = clsIt.next(); 
    		            if(cls instanceof TPFTestSuite)
    		                testSuites.add(cls);
    		        }
    		    }
    		    else if(obj instanceof TPFTestSuite)
    		        testSuites.add(obj);
    		}
    		
    		for(int i = 0; i < testSuites.size(); i++)
    	    {
    	        TPFTestSuite testSuite = (TPFTestSuite)testSuites.get(i);
    		    ImageDescriptor imageDescriptor = null;
    			IWorkbenchAdapter workbenchAdapter = (IWorkbenchAdapter)testSuite.getAdapter(IWorkbenchAdapter.class);
    			if((workbenchAdapter != null))
    				imageDescriptor = workbenchAdapter.getImageDescriptor(testSuite);
    			if(imageDescriptor == null)
    				imageDescriptor = TestUIImages.INSTANCE.getImageDescriptor(TestUIImages.IMG_DEFAULT);
    	
    			Label imageLabel = widgetFactory.createLabel(parent, "");
    			imageLabel.setImage(imageDescriptor.createImage());
    			
    			String name = (testSuite.getName() == null) ? "" : testSuite.getName();
    			this.widgetFactory.createLabel(parent, name);
    	    }
    		
    		parent.pack(true);
    		Composite container = parent.getParent();
    		container.setSize(container.computeSize(container.getSize().x, SWT.DEFAULT));					
    		container.getParent().setSize(container.getParent().computeSize(container.getParent().getSize().x, SWT.DEFAULT));
    	}
    	
    	protected void disposeChildren(Composite parent)
    	{
    		Control[] children = parent.getChildren();
    		for (int i = 0, maxi = children.length; i < maxi; i++)
    			children[i].dispose();
    	}
    }
    
    private DeploymentTestSuitesAdapter adapter;
    private Composite listParent;
    private FormWidgetFactory widgetFactory;
    
    /**
	 * Disposes this section.
	 */
	public void dispose()
	{
		widgetFactory = null;
		listParent = null;
		
		if(adapter != null)
		{
			if(adapter.getTarget() != null)
				adapter.getTarget().eAdapters().remove(adapter);
			adapter.dispose();
		}
		
		super.dispose();
	}
	
	/**
	 * Creates the content of this section.
	 * @param parent the parent composite.
	 * @param formWidgetFactory the widget factory.
	 * @return The composite which represents the content of the section.
	 */
	public Composite createClient(Composite parent, FormWidgetFactory formWidgetFactory)
	{
		this.widgetFactory = formWidgetFactory;
		
		Composite container = formWidgetFactory.createComposite(parent);
		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 2;
		container.setLayout(gridLayout);
		container.setLayoutData(GridDataUtil.createFill());
				
		listParent = formWidgetFactory.createComposite(container);
/*		gridLayout = new GridLayout();
		gridLayout.numColumns = 2;
		gridLayout.marginHeight = 0;
		gridLayout.marginWidth = 0;
		gridLayout.verticalSpacing = 2;
		hyperlinksParent.setLayout(gridLayout);
		hyperlinksParent.setLayoutData(GridDataUtil.createFill());
*/		
		return container;
	}
	
	public void initialize(EObject container, EStructuralFeature namedElementFeature, String statusLinePrefix)
	{
		if(!CommonPackage.eINSTANCE.getCMNNamedElement().isSuperTypeOf((EClass)namedElementFeature.getEType()))
			return;
			
		if(!namedElementFeature.isMany())
			return;
			
		adapter = new DeploymentTestSuitesAdapter(namedElementFeature, statusLinePrefix, listParent, widgetFactory);
		container.eAdapters().add(adapter);
		adapter.setTarget(container);
		
		adapter.refreshComposite(container);
	}
	
	/**
	 * Utility method.  Clients may choose not to execute this in order to customize the
	 * section.
	 * @return Control
	 */
	public Control createControl(Composite parent, FormWidgetFactory formWidgetFactory, String headerText, String headerDescription)
	{
		setCollapsable(true);
		setHeaderText(headerText);
		setDescription(headerDescription);
		Control control = createControl(parent, formWidgetFactory);
		control.setLayoutData(new GridData(GridData.FILL_BOTH | GridData.VERTICAL_ALIGN_BEGINNING));
		return control;
	}
}
