/*******************************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.launch.shortcuts;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.debug.core.ILaunchManager;

/**
 * This class is used by the PropertyTester extension point for evaluating the
 * "isLaunchable" property. This property is used by the Launch Shortcut extension
 * for determining whether a Run menu should be provided for the current
 * selection.
 * @author jcanches
 */
public class LaunchPropertyTester extends PropertyTester {
	
	public static final String PROPERTY_IS_LAUNCHABLE = "isLaunchable";
	
	/* (non-Javadoc)
	 * @see org.eclipse.core.expressions.IPropertyTester#test(java.lang.Object, java.lang.String, java.lang.Object[], java.lang.Object)
	 */
	public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
		if (PROPERTY_IS_LAUNCHABLE.equals(property)) {
			return new Boolean(LaunchShortcut.getRunnableItemFromElement(receiver, ILaunchManager.RUN_MODE) != null)
				.equals(expectedValue);
		}
		return false;
	}
	
}
