/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.model.ui;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.model.IWorkbenchAdapter;

import org.eclipse.hyades.ui.util.IDisposable;

/**
 * @author marcelop
 * @since 0.3.0
 */
public class AddChildAction 
extends SelectionListenerAction implements IDisposable
{
	private boolean actionPeformed = false;
	private EClassifier parentClassifier;
	private EObject parent;

	/**
	 * Constructor for AddTestSuiteChildAction
	 * @param parentClass
	 * @param text
	 */
	public AddChildAction(EClassifier parentClassifier, String text)
	{
		super(text);
		this.parentClassifier = parentClassifier;
	}
	
	/**
	 * @see org.eclipse.hyades.ui.util.IDisposable#dispose()
	 */
	public void dispose()
	{
		parentClassifier = null;
		parent = null;
		actionPeformed = false;
	}

	/**
	 * Returns whether the most recent wizard has being completed or canceled.  This
	 * information is reset at the beging of an execution and when the selection 
	 * changes. 
	 * @return <code>true</code> if the wizard was completed or <code>false</code> if
	 * it was canceled.
	 */
	public boolean actionPerformed()
	{
		return actionPeformed;
	}
	
	protected void setActionPerformed(boolean actionPerformed)
	{
		this.actionPeformed = actionPerformed;
	}
	
	/**
	 * Sets the default parent EObject that is returned by 
	 * {@link #getParent(IStructuredSelection)}.  If <code>null</code> then the
	 * selection is analysed in order to identify the parent.
	 * 
	 * <p>The parent must be an instance of the parentClassifier specified in the
	 * constructor.
	 * 
	 * @param parent
	 */
	public void setParent(EObject parent)
	{
		this.parent = null;
		if((parentClassifier != null) && parentClassifier.isInstance(parent))
			this.parent = parent;
	}

	/**
	 * Returns the parent associated with the first element of the structured 
	 * selection or <code>null</code>.
	 * @param structuredSelection
	 * @return EOBject
	 */
	protected EObject getParent(IStructuredSelection structuredSelection)
	{
		if(parentClassifier == null)
			return null;

		if(parent != null)
			return parent;
						
		if((structuredSelection == null) || (structuredSelection.size() != 1))
			return null;

		Object selection = structuredSelection.getFirstElement();
		if(parentClassifier.isInstance(selection))
			return (EObject)selection;
		
		if(selection instanceof EObject)
		{
			EObject container = ((EObject)selection).eContainer();
			if(parentClassifier.isInstance(container))
				return container;
		}
		
		if(selection instanceof IAdaptable)
		{
			IWorkbenchAdapter workbenchAdapter = (IWorkbenchAdapter)((IAdaptable)selection).getAdapter(IWorkbenchAdapter.class);
			if(workbenchAdapter != null)
			{
				Object parent = workbenchAdapter.getParent(selection);
				if(parentClassifier.isInstance(parent))
					return (EObject)parent;
			}
		}
		
		return null;
	}	
}
