/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.model.ui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.actions.SelectionListenerAction;

import org.eclipse.hyades.ui.util.IDisposable;

/**
 * This action works on EMF objects that are contained by another EMF object. 
 * @author marcelop
 * @since 0.3.0
 */
public class ChildrenSelectionAction 
extends SelectionListenerAction implements IDisposable
{
	private StructuredViewer structuredViewer;
	private List children;
	private boolean actionPerformed;

	/**
	 * Constructor for ChildrenSelectionAction
	 * @param text
	 */
	public ChildrenSelectionAction(String text)
	{
		super(text);
	}
	
	/**
	 * @see org.eclipse.hyades.ui.util.IDisposable#dispose()
	 */
	public void dispose()
	{
		if(children != null)
			children.clear();
		structuredViewer = null;
	}
	
	/**
	 * Returns the children obtained from the last selection update.  All the
	 * objects are EObjects.   This information is reset at the end of an 
	 * execution and when the selection changes.
	 * @return List
	 */
	protected List getChildren()
	{
		if(children == null)
			children = new ArrayList();
		return children;
	}
	
	/**
	 * Sets the action performed flag.
	 * @param actionPerformed
	 */
	protected void setActionPerformed(boolean actionPerformed)
	{
		this.actionPerformed = actionPerformed;
	}
	
	/**
	 * Returns whether the most run has being completed.  This information is reset 
	 * at the selection changes. 
	 * @return boolean.
	 */
	public boolean actionPerformed()
	{
		return actionPerformed;
	}

	/**
	 * Sets the structuredViewer that should be updated after running this action.
	 * @param structuredViewer
	 */
	public void setStructuredViewer(StructuredViewer structuredViewer)
	{
		this.structuredViewer = structuredViewer;
	}

	/**
	 * Returns the structuredViewer to be updated after running this action.
	 * @return structuredViewer
	 */
	public StructuredViewer getStructuredViewer()
	{
		return structuredViewer;
	}

	/**
	 * @see org.eclipse.ui.actions.SelectionListenerAction#updateSelection(org.eclipse.jface.viewers.IStructuredSelection)
	 */
	protected boolean updateSelection(IStructuredSelection selection)
	{
		setActionPerformed(false);
		if(children != null)
			children.clear();
		
		if(selection.isEmpty())
			return false;
		
		List childCandidates = new ArrayList();
		for (Iterator i = selection.iterator(); i.hasNext();)
		{
			Object object = i.next();
			if(!(object instanceof EObject))
				return false;
				
			if(((EObject)object).eContainer() == null)
				return false;
				
			childCandidates.add(object);
		}
		
		getChildren().addAll(childCandidates);
		return !getChildren().isEmpty();
	}

}
