/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;

import org.eclipse.hyades.models.common.common.CMNNamedElement;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.util.ICommonConstants;
import org.eclipse.hyades.test.ui.TestUI;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.ui.internal.provider.IResourceChangeUpdater;
import org.eclipse.hyades.ui.internal.util.UIUtil;

/**
 * @author marcelop
 * @since 0.2.0
 * @deprecated
 */
public class ExecutionResourceChangeUpdater 
implements IResourceChangeUpdater
{
	private ExecutionNavigator executionNavigator;
	private List addedObjects;
	private List removedObjects;
	private List changedObjects;
	private List resourcesToSave;

	private Object[] expandedElements;
	private Object[] selectedElements;
	
	private boolean active;
	
	/**
	 * Constructor for ExecutionResourceChangeUpdater
	 */
	public ExecutionResourceChangeUpdater(ExecutionNavigator executionNavigator)
	{
		this.executionNavigator = executionNavigator;
		active = true;
	}

	/**
	 * @see org.eclipse.hyades.ui.util.IDisposable#dispose()
	 */
	public void dispose()
	{
		executionNavigator = null;
	}

	/**
	 * @see org.eclipse.hyades.ui.internal.provider.IResourceChangeUpdater#started()
	 */
	public void started()
	{
		addedObjects = new UniqueEList();
		removedObjects = new UniqueEList();
		changedObjects = new UniqueEList();
		resourcesToSave = new UniqueEList();
	}

	/**
	 * @see org.eclipse.hyades.ui.internal.provider.IResourceChangeUpdater#ended()
	 */
	public void ended()
	{
		if(!addedObjects.isEmpty())
		{
			for (Iterator i = addedObjects.iterator(); i.hasNext();)
			{
				Object object = i.next();
				Object parent = ((ITreeContentProvider)executionNavigator.getViewer().getContentProvider()).getParent(object);
				if(parent == null)
				{
					executionNavigator.getTreeViewer().refresh(true);
					return;
				}
				executionNavigator.getTreeViewer().add(parent, object);
			}
		}

		if(!removedObjects.isEmpty())
			executionNavigator.getTreeViewer().remove(removedObjects.toArray());

		if(!changedObjects.isEmpty())
		{
			for (Iterator i = changedObjects.iterator(); i.hasNext();)
				executionNavigator.getTreeViewer().refresh(i.next(), true);
		}
		
		if(!resourcesToSave.isEmpty())
		{
			for (Iterator i = resourcesToSave.iterator(); i.hasNext();)
			{
				try
				{
					EMFUtil.save((Resource)i.next());
				}
				catch (Exception e)
				{
				}
			}			
		}

		List objectsToSelect = new ArrayList();
		for(Iterator i = addedObjects.iterator(); i.hasNext();)
		{
			Object object = i.next();
			if(object instanceof TPFExecutionResult)
			{
				objectsToSelect.add(object);
				if(TestUIPlugin.getInstance().getPreferenceStore().getBoolean(TestUI.OPEN_EDITOR))
				{
					IFile file = EMFUtil.getWorkspaceFile((TPFExecutionResult)object);
					if(file != null && file.exists())
						UIUtil.openEditor(file, TestUIExtension.EXECUTION_EDITOR_PART_ID, false);				
				}
			}
		}

		if(expandedElements != null)
		{
			convertURIToEObject(expandedElements);
			executionNavigator.getTreeViewer().setExpandedElements(expandedElements);
			if(objectsToSelect.isEmpty())
			{
				convertURIToEObject(selectedElements);
				executionNavigator.getTreeViewer().setSelection(new StructuredSelection(selectedElements), true);
			}
	
			expandedElements = null;
			selectedElements = null;
		}
		
		if(!objectsToSelect.isEmpty())
		{
			executionNavigator.getTreeViewer().setSelection(new StructuredSelection(objectsToSelect), true);
			objectsToSelect.clear();
		}

		addedObjects.clear();
		addedObjects = null;
		
		removedObjects.clear();
		removedObjects = null;
		
		changedObjects.clear();
		changedObjects = null;
		
		resourcesToSave.clear();
		resourcesToSave = null;
	}

	/**
	 * @see org.eclipse.hyades.ui.internal.provider.IResourceChangeUpdater#add(org.eclipse.core.resources.IResource, org.eclipse.core.resources.IResource[])
	 */
	public boolean add(IResource parent, IResource[] affectedResources)
	{
		ResourceSet resourceSet = executionNavigator.getResourceSet();
		for(int i = 0, maxi = affectedResources.length; i < maxi; i++)
		{
			if(affectedResources[i].getType() != IResource.FILE)
			{
				addedObjects.add(affectedResources[i]);
			}
			else
			{
				URI uri = getFileURI(affectedResources[i]);
				if(uri == null)
					continue;
					
				EObject[] eObjects = EMFUtil.load(null, (IFile)affectedResources[i]);
				if((eObjects.length == 1) && isValid(eObjects[0]))
				{
					Resource resource = eObjects[0].eResource();
					resourceSet.getResources().add(resource);
					addedObjects.addAll(resource.getContents());
				}
			}
		}
		
		return false;
	}

	/**
	 * @see org.eclipse.hyades.ui.internal.provider.IResourceChangeUpdater#remove(org.eclipse.core.resources.IResource, org.eclipse.core.resources.IResource[])
	 */
	public boolean remove(IResource parent, IResource[] affectedResources)
	{
		ResourceSet resourceSet = executionNavigator.getResourceSet();
		for(int i = 0, maxi = affectedResources.length; i < maxi; i++)
		{
			if(affectedResources[i].getType() != IResource.FILE)
			{
				removedObjects.add(affectedResources[i]);
			}
			else
			{
				URI uri = getFileURI(affectedResources[i]);
				if(uri == null)
					continue;
					
				Resource resource = resourceSet.getResource(uri, false);
				if(resource != null)
				{
					removedObjects.addAll(resource.getContents());
					resourcesToSave.addAll(Arrays.asList(EMFUtil.remove(resource)));
				}
			}
		}
		
		return false;
	}

	/**
	 * @see org.eclipse.hyades.ui.internal.provider.IResourceChangeUpdater#replaced(org.eclipse.core.resources.IResource)
	 */
	public boolean replaced(IResource affectedResource)
	{
		return false;
	}

	/**
	 * @see org.eclipse.hyades.ui.internal.provider.IResourceChangeUpdater#updateProperties(org.eclipse.core.resources.IResource)
	 */
	public boolean updateProperties(IResource affectedResource)
	{
		if(affectedResource.getType() == IResource.FILE)
		{
			EObject[] eObjects = EMFUtil.getEObjects(executionNavigator.getResourceSet(), (IFile)affectedResource);
			if(eObjects.length > 0)
				executionNavigator.getTreeViewer().update(eObjects, null);
		}
		else
		{
			executionNavigator.getTreeViewer().update(affectedResource, null);
		}
		return false;
	}

	/**
	 * @see org.eclipse.hyades.ui.internal.provider.IResourceChangeUpdater#updateChildrenType(org.eclipse.core.resources.IResource)
	 */
	public boolean updateChildrenType(IResource affectedResource)
	{
		return false;
	}

	/**
	 * @see org.eclipse.hyades.ui.internal.provider.IResourceChangeUpdater#updateContent(org.eclipse.core.resources.IResource, org.eclipse.core.resources.IResource)
	 */
	public boolean updateContent(IResource parent, IResource affectedResource)
	{
		URI uri = getFileURI(affectedResource);
		if(uri != null)
		{
			Resource resource = executionNavigator.getResourceSet().getResource(uri, false);
			if(resource != null)
			{
				removedObjects.addAll(resource.getContents());
				resource.unload();
				try
				{
					resource.load(EMFUtil.RESOURCE_OPTIONS);
				}
				catch (IOException e)
				{
					TestUIPlugin.logError(e);
				}
				changedObjects.add(resource);
				addedObjects.addAll(resource.getContents());
				
				if(expandedElements == null)
				{
					expandedElements = executionNavigator.getTreeViewer().getExpandedElements();
					convertEObjectToURI(expandedElements);
					selectedElements = ((IStructuredSelection)executionNavigator.getTreeViewer().getSelection()).toArray();
					convertEObjectToURI(selectedElements);
				}				
			}
		}
			
		return false;
	}

	/**
	 * @see org.eclipse.hyades.ui.internal.provider.IResourceChangeUpdater#setActive(boolean)
	 */
	public void setActive(boolean enable)
	{
		active = enable;
	}

	/**
	 * @see org.eclipse.hyades.ui.internal.provider.IResourceChangeUpdater#isActive()
	 */
	public boolean isActive()
	{
		return active;
	}
	
	/**
	 * Returns the uri associated with the resource if this is a file and has
	 * the correct file extension.
	 * @param resource
	 * @return URI
	 */
	protected URI getFileURI(IResource resource)
	{
		if(resource.getType() == IResource.FILE)
		{
			String fileExtension = resource.getFileExtension();
			if(	ICommonConstants.TEST_SUITE_FILE_EXTENSION.equals(fileExtension) 
				|| ICommonConstants.EXECUTION_FILE_EXTENSION.equals(fileExtension))
				return URI.createPlatformResourceURI(resource.getFullPath().toString());
		}
		
		return null;
	}
	
	/**
	 * Returns whether the eObject is valid in the context of the 
	 * test navigator.
	 * @param eObject
	 * @return boolean
	 */
	protected boolean isValid(EObject eObject)
	{
		return (eObject instanceof CMNNamedElement);
	}
	
	/**
	 * @param expandedElements
	 */
	private void convertEObjectToURI(Object[] objects)
	{
		for (int i = 0, maxi = objects.length; i < maxi; i++)
		{
			if(objects[i] instanceof EObject)
				objects[i] = EcoreUtil.getURI((EObject)objects[i]);
		}
	}
	
	private void convertURIToEObject(Object[] objects)
	{
		for (int i = 0, maxi = objects.length; i < maxi; i++)
		{
			if(objects[i] instanceof URI)
				objects[i] = executionNavigator.getResourceSet().getEObject((URI)objects[i], false);
		}
	}	
	public void refreshContent(IResource affectedResource) {
	}
}
