/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.action;

import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigator;
import org.eclipse.hyades.test.ui.internal.util.ContextIds;
import org.eclipse.hyades.ui.internal.navigator.action.NavigatorAction;
import org.eclipse.ui.help.WorkbenchHelp;


/**
 * This action toggles whether the Test navigator should present the eObjects 
 * children.
 * 
 * @author marcelop
 * @since 0.2.0
 */
public class ToggleEObjectChildrenAction 
extends NavigatorAction
{
	/**
	 * Constructor for ToggleEObjectChildrenAction
	 * @param navigator
	 * @param label
	 */
	public ToggleEObjectChildrenAction(TestNavigator testNavigator, String label)
	{
		super(testNavigator, label);
		setChecked(testNavigator.isShowingEObjectChildren());
		WorkbenchHelp.setHelp(this, TestUIPlugin.getID() + ContextIds.TOGGLE_CHILD_ACT);												
		
	}

	/**
	 * @see org.eclipse.jface.action.IAction#run()
	 */
	public void run()
	{
		((TestNavigator)getNavigator()).setShowingEObjectChildren(isChecked());
	}
}
