/*******************************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.proxy;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionHistory;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFInvocationEvent;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.navigator.IExecutionResultProxyNode;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.swt.graphics.Image;

/**
 * @author jgout
 * @since 3.2
 */
public class DefaultExecutionResultProxyNode extends TypedElementProxyNode implements IExecutionResultProxyNode {
	
	private IProxyNode[] children;
	private String name;
	
	/**
	 * @param event
	 * @param parent
	 */
	private void getEventChildren(TPFExecutionEvent event, List c, TPFExecutionResult parent) {
		if ( event instanceof TPFInvocationEvent) {
			TPFExecutionResult er = ((TPFInvocationEvent)event).getInvokedExecutionResult();
			c.add(new DefaultExecutionResultProxyNode(er, parent));
		} else {
			Iterator iterator = event.getChildren().iterator();
			while (iterator.hasNext()) {
				getEventChildren((TPFExecutionEvent) iterator.next(), c, parent);
			}
		}
	}
	
	/**
	 * @param er
	 * @param parent
	 */
	public DefaultExecutionResultProxyNode(TPFExecutionResult er, Object parent) {
		super(er, parent);
		LinkedList c = new LinkedList();
		TPFExecutionHistory history = er.getExecutionHistory();
		if (history != null ) {
			EList events = history.getExecutionEvents();
			for (Iterator it = events.iterator(); it.hasNext();) {
				getEventChildren((TPFExecutionEvent) it.next(), c, er);
			}
		}
		children = (IProxyNode[]) c.toArray(new IProxyNode[c.size()]);
		//- save the name of this element
		if(er.getName() != null) {
			name = er.getName();
		} else {
			name = "unamed"; //$NON-NLS-1$
		}
		if((er.getTest() != null) && (((er.getTest()).getName()) != null)) {
			name += " [" + (er.getTest()).getName() + "]"; //$NON-NLS-1$ //$NON-NLS-2$
		}
	}


	public Image getImage() {
		return TestUIImages.INSTANCE.getImage(TestUIImages.IMG_EXECUTION);
	}
	
	public IProxyNode[] getChildren() {
		return children;
	}
	
	public String getText() {
		return name;
	}
	
	public TPFExecutionResult getExecutionResult() {
		EObject exec = EMFUtil.getResourceSet().getEObject(getOriginatorURI(), true);
		if (exec instanceof TPFExecutionResult) {
			return (TPFExecutionResult) exec;
		} else {
			return null;
		}
	}
}
