/*******************************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.proxy;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.testprofile.TPFTestComponent;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITestComponentProxyNode;
import org.eclipse.swt.graphics.Image;

/**
 * @author jgout
 * @since 3.2
 */
public class DefaultTestComponentlProxyNode extends TypedElementProxyNode implements ITestComponentProxyNode {
	/**
	 * @param tc
	 * @param parent
	 */
	public DefaultTestComponentlProxyNode(TPFTestComponent tc, Object parent) {
		super(tc, parent);
	}

	public Image getImage() {
		return TestUIImages.INSTANCE.getImage(TestUIImages.IMG_TEST_COMPONENT);
	}
	
	public IProxyNode[] getChildren() {
		//- no children for this node
		return new IProxyNode[0];
	}
	
	public TPFTestComponent getTestComponent() {
		EObject tc = EMFUtil.getResourceSet().getEObject(getOriginatorURI(), true);
		if (tc instanceof TPFTestComponent) {
			return (TPFTestComponent) tc;
		} else {
			return null;
		}
	}
}
