/*******************************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.proxy;

import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.navigator.CMNNamedElementProxyNode;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITestSuiteProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITypedElementProxyFactory;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.extension.IAssociationMapping;
import org.eclipse.hyades.ui.internal.extension.AssociationMappingRegistry;
import org.eclipse.swt.graphics.Image;

/**
 * @author jgout
 * @since 3.2
 */
public class DefaultTestSuiteProxyNode extends TypedElementProxyNode implements ITestSuiteProxyNode {

	private IAssociationDescriptor descriptor;
	private CMNNamedElementProxyNode [] testCases;
	
	/**
	 * @param ts
	 * @param parent
	 */
	public DefaultTestSuiteProxyNode(TPFTestSuite ts, Object parent) {
		super(ts, parent);
		AssociationMappingRegistry registry = (AssociationMappingRegistry)TestUIExtension.getTestSuiteMappingRegistry();
		IAssociationMapping associationMapping = registry.getAssociationMapping(HyadesUIPlugin.EP_TYPE_DESCRIPTIONS);
		descriptor = associationMapping.getDefaultAssociationDescriptor(ts.getType());
		LinkedList tcProxies = new LinkedList();
		EList testcases = ts.getTestCases();
		for (Iterator iter = testcases.iterator(); iter.hasNext();) {
			TPFTestCase tc = (TPFTestCase) iter.next();
			ITypedElementProxyFactory factory = TypedElementFactoryManager.getInstance().getFactory(tc.getType());
			if(factory != null) {
				tcProxies.add(factory.create(tc, this));
			}
		}
		testCases = (CMNNamedElementProxyNode[]) tcProxies.toArray(new CMNNamedElementProxyNode[tcProxies.size()]);	
	}

	public Image getImage() {
		if(descriptor == null) {
			//- the type of this element wasn't registered by any extension (hyades.ui.typeDescriptions) 
			return TestUIImages.INSTANCE.getImage(TestUIImages.IMG_TEST_SUITE);
		} else {
			return descriptor.getImage();
		}
	}

	public IProxyNode[] getChildren() {
		return testCases;
	}
	
	public TPFTestSuite getTestSuite() {
		EObject ts = EMFUtil.getResourceSet().getEObject(getOriginatorURI(), true);
		if (ts instanceof TPFTestSuite) {
			return (TPFTestSuite) ts;
		} else {
			return null;
		}
	}
}
