/*******************************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.proxy;

import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.navigator.CMNNamedElementProxyNode;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.swt.graphics.Image;

/**
 * @author jgout
 * @since 3.2
 */
public class DeploymentProxyNode extends CMNNamedElementProxyNode {
	/**
	 * @param deploy
	 * @param parent
	 */
	public DeploymentProxyNode(TPFDeployment deploy, Object parent) {
		super(deploy, parent);
	}

	public Image getImage() {
		return TestUIImages.INSTANCE.getImage(TestUIImages.IMG_DEPLOYMENT);
	}
	
	public IProxyNode[] getChildren() {
		//- no children for this node
		return new IProxyNode[0];
	}
}
