/*******************************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.proxy;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.test.ui.navigator.DefaultHyadesProxyNodeFactory;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;

/**
 * @author jgout
 * @since 3.2
 */
public class EMFResourceProxyNode extends FileProxyNode {

	private List children;
	private String name;
	
	/**
	 * @param file
	 * @param resource
	 */
	public EMFResourceProxyNode(IFile file, Resource resource) {
		super(file);
		EObject[] eObjects;
		children = new LinkedList();
		
		eObjects = (EObject[]) resource.getContents().toArray(new EObject[resource.getContents().size()]); 
		IProxyNode child = null;
		for (int i = 0; i < eObjects.length; i++) {
			child = DefaultHyadesProxyNodeFactory.getInstance().create(eObjects[0], this);
			if(child != null) {
				children.add(child);
			}
		}
		name = file.getName();
		name = name.substring(0, name.length()-(file.getFileExtension().length()+1));
	}

	public IProxyNode[] getChildren() {
		return (IProxyNode[]) children.toArray(new IProxyNode[children.size()]);
	}
	
	public String getText() {
		return name;
	}

}
