/*******************************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.wizard;

import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.datapool.internal.util.CSVImportExportUtil;
import org.eclipse.hyades.test.ui.datapool.internal.util.GridDataUtil;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

/**
 * @author psun
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class DatapoolCSVImportPage extends WizardPage implements ModifyListener, SelectionListener {

	private Button browseButton = null;
	private Button firstRowVarButton = null;
	private Button firstColEqClsButton = null;
	private Text csvFileText = null;
	private Combo encodingCombo = null;
	private String importEncoding = new String();

	class EncodingSelectionAdapter implements SelectionListener
	{

		/* (non-Javadoc)
		 * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
		 */
		public void widgetSelected(SelectionEvent e) 
		{
			if(e.widget instanceof Combo)
			{
				Combo combo = (Combo)e.widget;
				int index = combo.getSelectionIndex();
				importEncoding = ((String[])combo.getData())[index];
			}
		}

		/* (non-Javadoc)
		 * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
		 */
		public void widgetDefaultSelected(SelectionEvent e) 
		{
		}	
	}
		
	/**
	 * @param pageName
	 */
	protected DatapoolCSVImportPage(String pageName) 
	{
		super(pageName);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.IDialogPage#createControl(org.eclipse.swt.widgets.Composite)
	 */
	public void createControl(Composite parent) 
	{
        Composite mainComposite = new Composite(parent, SWT.NONE);
		GridLayout layout = new GridLayout();
		layout.numColumns = 1;
		mainComposite.setLayout(layout);        
		Label label = new Label(mainComposite, SWT.NULL);
		label.setText(TestUIPlugin.getString("WIZ_DATAPOOL_CSV_PG_SEL"));

        Composite fileComposite = new Composite(mainComposite, SWT.NONE);        
		GridLayout fileLayout = new GridLayout();
		fileLayout = new GridLayout();
		fileLayout.numColumns = 2;
		fileLayout.marginHeight = 0;
		fileLayout.marginWidth = 0;
		fileLayout.makeColumnsEqualWidth = false;
		fileComposite.setLayout(fileLayout);
		GridData gridData = GridDataUtil.createHorizontalFill();
		fileComposite.setLayoutData(gridData);

		csvFileText = new Text(fileComposite, SWT.BORDER); 
		gridData = GridDataUtil.createHorizontalFill();
		gridData.widthHint = 300;
		csvFileText.setLayoutData(gridData);
		csvFileText.addModifyListener(this);
		browseButton = new Button(fileComposite, SWT.PUSH);
		browseButton.setText(TestUIPlugin.getString("BROWSE"));	//$NON-NLS-1$
		browseButton.addSelectionListener(this);

        Composite encodingComposite = new Composite(mainComposite, SWT.NONE);        
		GridLayout encodingLayout = new GridLayout();
		encodingLayout = new GridLayout();
		encodingLayout.numColumns = 2;
		encodingLayout.marginHeight = 0;
		encodingLayout.marginWidth = 0;
		encodingLayout.makeColumnsEqualWidth = false;
		encodingComposite.setLayout(encodingLayout);
		gridData = GridDataUtil.createHorizontalFill();
		encodingComposite.setLayoutData(gridData);

		Label encodingLabel = new Label(encodingComposite, SWT.NULL);
		encodingLabel.setText(TestUIPlugin.getString("WIZ_DATAPOOL_CSV_PG_ENC")); //$NON-NLS-1$

		String[] encodings = {TestUIPlugin.getString("WIZ_DATAPOOL_CSV_ENC_DEFAULT"), //$NON-NLS-1$
							  TestUIPlugin.getString("WIZ_DATAPOOL_CSV_ENC_ASCII"), //$NON-NLS-1$
							  TestUIPlugin.getString("WIZ_DATAPOOL_CSV_ENC_ISOLATIN"), //$NON-NLS-1$
							  TestUIPlugin.getString("WIZ_DATAPOOL_CSV_ENC_UTF8"), //$NON-NLS-1$
							  TestUIPlugin.getString("WIZ_DATAPOOL_CSV_ENC_UTF16"), //$NON-NLS-1$
							  TestUIPlugin.getString("WIZ_DATAPOOL_CSV_ENC_UTF16LE"), //$NON-NLS-1$
							  TestUIPlugin.getString("WIZ_DATAPOOL_CSV_ENC_UTF16BE")}; //$NON-NLS-1$

		String[] encodingValues = {new String(), 
								   CSVImportExportUtil.ASCII,
								   CSVImportExportUtil.ISONLATIN,
								   CSVImportExportUtil.UTF8,
								   CSVImportExportUtil.UTF16,
								   CSVImportExportUtil.UTF16LE,
								   CSVImportExportUtil.UTF16BE};
		
		encodingCombo = new Combo(encodingComposite, SWT.DROP_DOWN | SWT.READ_ONLY);
		encodingCombo.setItems(encodings);
		encodingCombo.setData(encodingValues);
		encodingCombo.select(0);
		encodingCombo.addSelectionListener(new EncodingSelectionAdapter());
				
        Composite optionComposite = new Composite(mainComposite, SWT.NONE);        
		GridLayout optionLayout = new GridLayout();
		optionLayout = new GridLayout();
		optionLayout.numColumns = 2;
		optionLayout.marginHeight = 0;
		optionLayout.marginWidth = 0;
		optionLayout.makeColumnsEqualWidth = false;
		optionComposite.setLayout(optionLayout);
		gridData = GridDataUtil.createHorizontalFill();
		optionComposite.setLayoutData(gridData);
		
		firstRowVarButton = new Button(optionComposite, SWT.CHECK);
		firstRowVarButton.setSelection(true);
		Label firstRowLabel = new Label(optionComposite, SWT.NULL);
		firstRowLabel.setText(TestUIPlugin.getString("WIZ_DATAPOOL_CSV_PG_COL_HEADER"));
		
		firstColEqClsButton = new Button (optionComposite, SWT.CHECK);
		firstColEqClsButton.setSelection(false);
		Label firstColLabel = new Label(optionComposite, SWT.NULL);
		firstColLabel.setText(TestUIPlugin.getString("WIZ_DATAPOOL_CSV_PG_ROW_HEADER"));
			
		setControl(mainComposite);
	}
	
	private String getCSVFileNameFromDialog()
	{
		FileDialog dialog = new FileDialog(getShell());
		dialog.setFilterExtensions(new String[] { "*.csv", "*.*" });
		dialog.setText(TestUIPlugin.getString("WIZ_DATAPOOL_CSV_PG_SEL"));
		if(csvFileText.getText().trim().length() > 0)
			dialog.setFilterPath(csvFileText.getText());
		
		String res = dialog.open();
		return res;
	}
	
	public String getCSVFileName()
	{
		return csvFileText.getText();
	}
	
	public boolean firstRowContainsVariableNameType()
	{
		return firstRowVarButton.getSelection();
	}
	
	public boolean firstColumnContainsEquivalenceClassName()
	{
		return firstColEqClsButton.getSelection();
	}

	public String getImportEncoding()
	{
		return importEncoding;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.ModifyListener#modifyText(org.eclipse.swt.events.ModifyEvent)
	 */
	public void modifyText(ModifyEvent e) 
	{
		if(csvFileText.getText().trim().length() > 0)
		{
			setPageComplete(true);
			getContainer().updateButtons();
		}
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	public void widgetSelected(SelectionEvent e) 
	{
		String tempCSVFileName = getCSVFileNameFromDialog();
		if (tempCSVFileName != null)
		{
			csvFileText.setText(tempCSVFileName);
			setPageComplete(true);
			getContainer().updateButtons();
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	public void widgetDefaultSelected(SelectionEvent e) 
	{
		return;
	}


}
