/*******************************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.wizard;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.models.common.util.ICommonConstants;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.datapool.internal.util.GridDataUtil;
import org.eclipse.hyades.test.ui.dialog.EObjectResourceContentProvider;
import org.eclipse.hyades.test.ui.dialog.EObjectResourceLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;

/**
 * @author psun
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class DatapoolExportSelectionPage extends WizardPage implements SelectionListener {
	
	IDatapool datapool = null;
	private TreeViewer assetViewer;	
	Button filterButton = null;
	private EObjectResourceContentProvider contentProvider;
	private String[] fileExtensions;
	private Image fileImage;
	
	/**
	 * @param pageName
	 */
	protected DatapoolExportSelectionPage(String pageName) 
	{
		super(pageName);
		fileExtensions = getSupportedFileExtensions();
		setPageComplete(false);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.IDialogPage#createControl(org.eclipse.swt.widgets.Composite)
	 */
	public void createControl(Composite parent) 
	{
        Composite composite = new Composite(parent, SWT.NONE);		
		GridLayout layout = new GridLayout();
		composite.setLayout(layout);
		GridData gridData = GridDataUtil.createFill();
		composite.setLayoutData(gridData);
		
		filterButton = new Button(composite, SWT.CHECK);
		filterButton.setText(TestUIPlugin.getString("SHOW_FOLDERS")); //$NON-NLS-1$
		filterButton.addSelectionListener(this);
		createViewer(composite);
		assetViewer.setInput(ResourcesPlugin.getWorkspace().getRoot());
		((Tree)assetViewer.getControl()).addSelectionListener(this);
		((TreeViewer)assetViewer).expandToLevel(2);
		setControl(composite);
		
	}
	
	public IDatapool getDatapool()
	{
		return datapool;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	public void widgetSelected(SelectionEvent e) 
	{
		if(e.widget == filterButton)						
		{
			contentProvider.setFilter((filterButton.getSelection() ? EObjectResourceContentProvider.SHOW_ALL : EObjectResourceContentProvider.FILTER_FOLDERS));
			ISelection selection = assetViewer.getSelection();				
			assetViewer.refresh();
			if(!selection.isEmpty())
				assetViewer.setSelection(selection, true);
		}
		
		if(e.widget == assetViewer.getControl())
		{
			setSelection();
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	public void widgetDefaultSelected(SelectionEvent e) 
	{
		
	}

	protected StructuredViewer createViewer(Composite parent)
	{		
		Tree tree = new Tree(parent, SWT.SINGLE | SWT.FULL_SELECTION | SWT.BORDER);
		GridData gridData = GridDataUtil.createFill();
		gridData.heightHint = 150;
		tree.setLayoutData(gridData);
			
		contentProvider = new EObjectResourceContentProvider(fileExtensions);
		assetViewer = new TreeViewer(tree);
		assetViewer.setContentProvider(contentProvider);
		assetViewer.setLabelProvider(new EObjectResourceLabelProvider(true, fileImage));

		contentProvider.setFilter(EObjectResourceContentProvider.FILTER_FOLDERS);

		ViewerSorter sorter = new ViewerSorter()
		{
			public void sort(Viewer viewer, Object[] elements)
			{
				if(elements.length > 0)
					super.sort(viewer, elements);
			}
		
			public int category(Object element)
			{
				if(element instanceof IResource)
					return 0;

				return 10;
			}		
		};
		assetViewer.setSorter(sorter);
	
		return assetViewer;
	}

	private void setSelection()
	{
		ISelection selection = assetViewer.getSelection();
		if(selection != null && !selection.isEmpty())
		{ 
			Object selectedObject = ((IStructuredSelection)selection).getFirstElement();
			if(selectedObject instanceof IDatapool)
			{
				datapool = (IDatapool)selectedObject;
				if(datapool != null)
				{
					setPageComplete(true);
					getContainer().updateButtons();
				}
			}
		}
	}
			
	private String[] getSupportedFileExtensions()
	{
	    return new String[]{ICommonConstants.DATAPOOL_FILE_EXTENSION};
	}
	
	
}
