/*******************************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.hyades.test.ui.internal.wizard;

import java.util.ArrayList;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.common.configuration.CFGArtifact;
import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.action.AddArtifactAction;
import org.eclipse.hyades.test.ui.internal.action.AddLocationAction;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.model.IWorkbenchAdapter;

/**
 * @author psun
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class DeploymentObjectPage extends WizardPage implements SelectionListener, ISelectionChangedListener {

	private String pageName;
	protected TreeViewer objectViewer;
	private TPFDeployment deployment;
	private Object input;
	private Object type;

	private Button addButton;
	private Button removeButton;
	private Button upButton;
	private Button downButton;


	private class ObjectContentProvider implements ITreeContentProvider
	{
		private ArrayList list = new ArrayList();
	
		public ObjectContentProvider()
		{ 
		}
		
		public void dispose()
		{
			list.clear();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.ITreeContentProvider#getChildren(java.lang.Object)
		 */
		public Object[] getChildren(Object parentElement) {
			return null;
		}

		/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.ITreeContentProvider#getParent(java.lang.Object)
		 */
		public Object getParent(Object element) {
			return null;
		}

		/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.ITreeContentProvider#hasChildren(java.lang.Object)
		 */
		public boolean hasChildren(Object element) {
			return false;
		}

		/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.IStructuredContentProvider#getElements(java.lang.Object)
		 */
		public Object[] getElements(Object inputElement) 
		{
			Object[] elements = new Object[0];
			if(inputElement == null)
				return elements;
			if(inputElement instanceof EList)
			{
				int listSize = ((EList)inputElement).size();
				elements = new Object[listSize];
				for(int i = 0; i < listSize; i++)
				{
					elements[i] = ((EList)inputElement).get(i);
				}
			}
			return elements;
		}

		/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.IContentProvider#inputChanged(org.eclipse.jface.viewers.Viewer, java.lang.Object, java.lang.Object)
		 */
		public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
			
		}

	}

	private class ObjectLabelProvider extends LabelProvider
	{
		private boolean useImages;
	
		/**
		 * Constructor for PerspectiveLabelProvider
		 */
		public ObjectLabelProvider(boolean useImages)
		{
			super();
			this.useImages = useImages;
		}
	
		/**
		 * @see LabelProvider#getImage(Object)
		 */
		public Image getImage(Object element)
		{
			if((!useImages) || (element == null))
				return null;

			if(element instanceof CFGArtifact)
				return TestUIImages.INSTANCE.getImage(TestUIImages.IMG_ARTIFACT);

			if(element instanceof CFGLocation)
				return TestUIImages.INSTANCE.getImage(TestUIImages.IMG_LOCATION);

			if (element instanceof IAdaptable)
			{
				IWorkbenchAdapter adapter =
					(IWorkbenchAdapter)((IAdaptable)element).getAdapter(IWorkbenchAdapter.class);

				if(adapter != null)
					return adapter.getImageDescriptor(element).createImage();
			}

			return null;			
		}

		/**
		 * @see LabelProvider#getText(Object)
		 */
		public String getText(Object element)
		{
			if(element == null)
				return "";

			String text = null;
		
			if(element instanceof CFGArtifact)
				text = ((CFGArtifact)element).getName();
			
			else if(element instanceof CFGLocation)
				text = ((CFGLocation)element).getName();
			
			else if(element instanceof IAdaptable)
			{
				IWorkbenchAdapter adapter =
					(IWorkbenchAdapter)((IAdaptable)element).getAdapter(IWorkbenchAdapter.class);

				if(adapter != null)
					text = adapter.getLabel(element);
			}

			if(text == null)
				text = element.toString();
			
			return text;		
		}
		
	
		/**
		 * @see org.eclipse.jface.viewers.IBaseLabelProvider#dispose()
		 */
		public void dispose()
		{
			super.dispose();
		}
	}	
	
	/**
	 * @param pageName
	 */
	protected DeploymentObjectPage(String pageName, TPFDeployment deployment, Object type) {
		super(pageName);
		this.pageName = pageName;
		this.deployment = deployment;
		this.type = type;
		if(type instanceof CFGLocation)
		{
			input = deployment.getRefLocations();
		}
		if(type instanceof CFGArtifact)
		{
			input = deployment.getArtifacts();
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.IDialogPage#createControl(org.eclipse.swt.widgets.Composite)
	 */
	public void createControl(Composite parent) 
	{
		Composite composite = new Composite(parent, SWT.NONE);
		GridLayout layout = new GridLayout();
		layout.marginWidth = 0;
		layout.marginHeight = 0;
		layout.verticalSpacing = 10;
		layout.numColumns = 2;
		composite.setLayout(layout);
		composite.setLayoutData(GridDataUtil.createFill());

		createViewer(composite);
		
		Composite buttonComposite = new Composite(composite, SWT.NONE);
		GridData data = new GridData();
		data.horizontalSpan = 2;
		data = new GridData(GridData.FILL_VERTICAL);
		buttonComposite.setLayoutData(data);
		layout = new GridLayout();
		layout.marginWidth = 0;
		layout.marginHeight = 0;
		layout.numColumns = 1;
		buttonComposite.setLayout(layout);
		
		createButtons(buttonComposite);

		addButton.addSelectionListener(this);
		removeButton.addSelectionListener(this);
		upButton.addSelectionListener(this);
		downButton.addSelectionListener(this);
	
		setControl(composite);
	}

	protected StructuredViewer createViewer(Composite parent)
	{		
		Tree tree = new Tree(parent, SWT.SINGLE | SWT.FULL_SELECTION | SWT.BORDER );
		GridData gridData = GridDataUtil.createFill();
		gridData.heightHint = 150;
		tree.setLayoutData(gridData);
				
		ObjectContentProvider contentProvider = new ObjectContentProvider();
		objectViewer = new TreeViewer(tree);
		objectViewer.setContentProvider(contentProvider);
		objectViewer.setLabelProvider(new ObjectLabelProvider(true));
		objectViewer.addSelectionChangedListener(this);
		objectViewer.getControl().getAccessible().addAccessibleListener(new AccessibleAdapter() {
			public void getName(AccessibleEvent e) {
				e.result = pageName;
			}
		});
		if(deployment != null)
			objectViewer.setInput(input);

		return objectViewer;
	}

	private void createButtons(Composite parent)
	{
		addButton = new Button(parent, SWT.PUSH);
		addButton.setText(TestUIPlugin.getString("label.Add"));
		GridData data = GridDataUtil.createHorizontalFill();
		addButton.setLayoutData(data);
		addButton.setEnabled(true);

		removeButton = new Button(parent, SWT.PUSH);
		removeButton.setText(TestUIPlugin.getString("label.Remove"));
		data = GridDataUtil.createHorizontalFill();
		removeButton.setLayoutData(data);
		removeButton.setEnabled(false);

		upButton = new Button(parent, SWT.PUSH);
		upButton.setText(TestUIPlugin.getString("LBL_UP"));
		data = GridDataUtil.createHorizontalFill();
		data.verticalAlignment = GridData.VERTICAL_ALIGN_END;
		upButton.setLayoutData(data);
		upButton.setEnabled(false);

		downButton = new Button(parent, SWT.PUSH);
		downButton.setText(TestUIPlugin.getString("LBL_DOWN"));
		data = GridDataUtil.createHorizontalFill();
		data.verticalAlignment = GridData.VERTICAL_ALIGN_END;
		downButton.setLayoutData(data);
		downButton.setEnabled(false);
	}


	public void widgetDefaultSelected(SelectionEvent e)
	{
		widgetSelected(e);
	}
	
	public void widgetSelected(SelectionEvent event)
	{		
		ISelection selection = objectViewer.getSelection();
		Object sel = null;
		if(selection != null && !selection.isEmpty())
		{ 
			sel = ((IStructuredSelection)selection).getFirstElement();
		}
		
		if (event.widget == addButton)
		{
			if(type instanceof CFGArtifact)
			{
				AddArtifactAction addAction = new AddArtifactAction();
				addAction.setDeployment(deployment);
				addAction.run();
			}
			if(type instanceof CFGLocation)
			{
				AddLocationAction addAction = new AddLocationAction();
				addAction.setDeployment(deployment);
				addAction.run();
			}
			objectViewer.refresh();
		}
		else if (event.widget == removeButton)
		{
			if(sel != null && sel instanceof CFGArtifact)
				deployment.getArtifacts().remove((CFGArtifact)sel);
			if(sel != null && sel instanceof CFGLocation)
				deployment.getRefLocations().remove((CFGLocation)sel);
			objectViewer.refresh();

		}

		else if (event.widget == upButton)
		{
			int index = -1;
			if(sel != null && sel instanceof CFGArtifact)
			{
				index = deployment.getArtifacts().indexOf((CFGArtifact)sel);
				deployment.getArtifacts().move(index, index - 1);
			}
			if(sel != null && sel instanceof CFGLocation)
			{
				index = deployment.getRefLocations().indexOf((CFGLocation)sel);
				deployment.getRefLocations().move(index, index - 1);
			}
			objectViewer.refresh();
			if(index - 1 == 0)
			{
				upButton.setEnabled(false);
				downButton.setEnabled(true);						
			}

		}
		else if (event.widget == downButton)
		{
			int index = -1;
			int maxIndex = -1;
			if(sel != null && sel instanceof CFGArtifact)
			{
				index = deployment.getArtifacts().indexOf((CFGArtifact)sel);
				maxIndex = deployment.getArtifacts().size() - 1;
				deployment.getArtifacts().move(index, index + 1);
			}
			if(sel != null && sel instanceof CFGLocation)
			{
				index = deployment.getRefLocations().indexOf((CFGLocation)sel);
				maxIndex = deployment.getRefLocations().size() - 1;
				deployment.getRefLocations().move(index, index + 1);
			}
			objectViewer.refresh();
			if(index + 1 == maxIndex)
			{
				upButton.setEnabled(true);
				downButton.setEnabled(false);						
			}

		}

	}
	
	public void setDeployment(TPFDeployment deployment)
	{
		this.deployment = deployment;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ISelectionChangedListener#selectionChanged(org.eclipse.jface.viewers.SelectionChangedEvent)
	 */
	public void selectionChanged(SelectionChangedEvent event) 
	{
		boolean enable = !objectViewer.getSelection().isEmpty();
		boolean enableUp = false;
		boolean enableDown = false;
		
		ISelection selection = objectViewer.getSelection();
		Object sel = null;
		if(selection != null && !selection.isEmpty())
		{ 
			sel = ((IStructuredSelection)selection).getFirstElement();
			int index = -1;
			int maxIndex = -1;
			if(sel != null && sel instanceof CFGArtifact)
			{
				maxIndex = deployment.getArtifacts().size() - 1;
				index = deployment.getArtifacts().indexOf((CFGArtifact)sel);
			}
			if(sel != null && sel instanceof CFGLocation)
			{
				maxIndex = deployment.getArtifacts().size() - 1;
				index = deployment.getRefLocations().indexOf((CFGLocation)sel);
			}
			if(index != 0)
			{
				enableUp = true;
			}
			if(index != maxIndex)
			{
				enableDown = true;
			}
			
		}
		
		removeButton.setEnabled(enable);
		upButton.setEnabled(enable && enableUp);
		downButton.setEnabled(enable && enableDown);	
	}
	
}
